/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.javascript;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teavm.codegen.NamingException;
import org.teavm.codegen.NamingStrategy;
import org.teavm.codegen.SourceWriter;
import org.teavm.javascript.RenderingContext;
import org.teavm.javascript.RenderingException;
import org.teavm.javascript.ast.AssignmentStatement;
import org.teavm.javascript.ast.BinaryExpr;
import org.teavm.javascript.ast.BlockStatement;
import org.teavm.javascript.ast.BreakStatement;
import org.teavm.javascript.ast.ClassNode;
import org.teavm.javascript.ast.ConditionalExpr;
import org.teavm.javascript.ast.ConditionalStatement;
import org.teavm.javascript.ast.ConstantExpr;
import org.teavm.javascript.ast.ContinueStatement;
import org.teavm.javascript.ast.Expr;
import org.teavm.javascript.ast.ExprVisitor;
import org.teavm.javascript.ast.FieldNode;
import org.teavm.javascript.ast.ForStatement;
import org.teavm.javascript.ast.IncrementStatement;
import org.teavm.javascript.ast.InitClassStatement;
import org.teavm.javascript.ast.InstanceOfExpr;
import org.teavm.javascript.ast.InvocationExpr;
import org.teavm.javascript.ast.MethodNode;
import org.teavm.javascript.ast.MethodNodeVisitor;
import org.teavm.javascript.ast.NativeMethodNode;
import org.teavm.javascript.ast.NewArrayExpr;
import org.teavm.javascript.ast.NewExpr;
import org.teavm.javascript.ast.NewMultiArrayExpr;
import org.teavm.javascript.ast.NodeModifier;
import org.teavm.javascript.ast.QualificationExpr;
import org.teavm.javascript.ast.RegularMethodNode;
import org.teavm.javascript.ast.ReturnStatement;
import org.teavm.javascript.ast.SequentialStatement;
import org.teavm.javascript.ast.Statement;
import org.teavm.javascript.ast.StatementVisitor;
import org.teavm.javascript.ast.StaticClassExpr;
import org.teavm.javascript.ast.SubscriptExpr;
import org.teavm.javascript.ast.SwitchClause;
import org.teavm.javascript.ast.SwitchStatement;
import org.teavm.javascript.ast.ThrowStatement;
import org.teavm.javascript.ast.TryCatchStatement;
import org.teavm.javascript.ast.UnaryExpr;
import org.teavm.javascript.ast.UnwrapArrayExpr;
import org.teavm.javascript.ast.VariableExpr;
import org.teavm.javascript.ast.WhileStatement;
import org.teavm.javascript.ni.GeneratorContext;
import org.teavm.javascript.ni.InjectedBy;
import org.teavm.javascript.ni.Injector;
import org.teavm.javascript.ni.InjectorContext;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.ClassHolder;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReference;
import org.teavm.model.ListableClassHolderSource;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class Renderer
implements ExprVisitor,
StatementVisitor,
RenderingContext {
    private static final MethodReference internRef = new MethodReference("java.lang.String", "intern", ValueType.object("java.lang.String"));
    private static final String variableNames = "abcdefghijkmnopqrstuvwxyz";
    private NamingStrategy naming;
    private SourceWriter writer;
    private ListableClassHolderSource classSource;
    private ClassLoader classLoader;
    private boolean minifying;
    private Map<MethodReference, InjectorHolder> injectorMap = new HashMap<MethodReference, InjectorHolder>();

    public Renderer(SourceWriter writer, ListableClassHolderSource classSource, ClassLoader classLoader) {
        this.naming = writer.getNaming();
        this.writer = writer;
        this.classSource = classSource;
        this.classLoader = classLoader;
    }

    @Override
    public SourceWriter getWriter() {
        return this.writer;
    }

    @Override
    public NamingStrategy getNaming() {
        return this.naming;
    }

    @Override
    public boolean isMinifying() {
        return this.minifying;
    }

    public void setMinifying(boolean minifying) {
        this.minifying = minifying;
    }

    @Override
    public ListableClassHolderSource getClassSource() {
        return this.classSource;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void renderRuntime() throws RenderingException {
        try {
            this.renderRuntimeCls();
            this.renderRuntimeString();
            this.renderRuntimeUnwrapString();
            this.renderRuntimeObjcls();
            this.renderRuntimeNullCheck();
        }
        catch (NamingException e) {
            throw new RenderingException("Error rendering runtime methods. See a cause for details", e);
        }
        catch (IOException e) {
            throw new RenderingException("IO error", e);
        }
    }

    private void renderRuntimeCls() throws IOException {
        this.writer.append("$rt_cls").ws().append("=").ws().append("function(clsProto)").ws().append("{").indent().softNewLine();
        String classClass = "java.lang.Class";
        this.writer.append("var cls").ws().append("=").ws().append("clsProto.classObject;").softNewLine();
        this.writer.append("if").ws().append("(cls").ws().append("===").ws().append("undefined)").ws().append("{").softNewLine().indent();
        MethodReference createMethodRef = new MethodReference(classClass, "createNew", ValueType.object(classClass));
        this.writer.append("cls").ws().append("=").ws().appendMethodBody(createMethodRef).append("();").softNewLine();
        this.writer.append("cls.$data = clsProto;").softNewLine();
        if (this.classSource.get(classClass).getField("name") != null) {
            this.writer.append("cls.").appendField(new FieldReference(classClass, "name")).ws().append("=").ws().append("clsProto.$meta.name").ws().append("!==").ws().append("undefined").ws().append("?").ws().append("$rt_str(clsProto.$meta.name)").ws().append(":").ws().append("null;").softNewLine();
        }
        if (this.classSource.get(classClass).getField("primitive") != null) {
            this.writer.append("cls.").appendField(new FieldReference(classClass, "primitive")).append(" = clsProto.$meta.primitive ? 1 : 0;").newLine();
        }
        if (this.classSource.get(classClass).getField("array") != null) {
            this.writer.append("cls.").appendField(new FieldReference(classClass, "array")).ws().append("=").ws().append("clsProto.$meta.item").ws().append("?").ws().append("1").ws().append(":").ws().append("0;").softNewLine();
        }
        if (this.classSource.get(classClass).getField("isEnum") != null) {
            this.writer.append("cls.").appendField(new FieldReference(classClass, "isEnum")).ws().append("=").ws().append("clsProto.$meta.enum").ws().append("?").ws().append("1").ws().append(":").ws().append("0;").softNewLine();
        }
        this.writer.append("clsProto.classObject").ws().append("=").ws().append("cls;").softNewLine();
        this.writer.outdent().append("}").softNewLine();
        this.writer.append("return cls;").softNewLine();
        this.writer.outdent().append("}").newLine();
    }

    private void renderRuntimeString() throws IOException {
        String stringClass = "java.lang.String";
        MethodReference stringCons = new MethodReference(stringClass, "<init>", ValueType.arrayOf(ValueType.CHARACTER), ValueType.VOID);
        this.writer.append("$rt_str = function(str) {").indent().softNewLine();
        this.writer.append("var characters = $rt_createCharArray(str.length);").softNewLine();
        this.writer.append("var charsBuffer = characters.data;").softNewLine();
        this.writer.append("for (var i = 0; i < str.length; i = (i + 1) | 0) {").indent().softNewLine();
        this.writer.append("charsBuffer[i] = str.charCodeAt(i) & 0xFFFF;").softNewLine();
        this.writer.outdent().append("}").softNewLine();
        this.writer.append("return ").appendClass("java.lang.String").append(".").appendMethod(stringCons).append("(characters);").softNewLine();
        this.writer.outdent().append("}").newLine();
    }

    private void renderRuntimeUnwrapString() throws IOException {
        String stringClass = "java.lang.String";
        MethodReference stringLen = new MethodReference(stringClass, "length", ValueType.INTEGER);
        MethodReference getChars = new MethodReference(stringClass, "getChars", ValueType.INTEGER, ValueType.INTEGER, ValueType.arrayOf(ValueType.CHARACTER), ValueType.INTEGER, ValueType.VOID);
        this.writer.append("$rt_ustr = function(str) {").indent().softNewLine();
        this.writer.append("var result = \"\";").softNewLine();
        this.writer.append("var sz = ").appendMethodBody(stringLen).append("(str);").softNewLine();
        this.writer.append("var array = $rt_createCharArray(sz);").softNewLine();
        this.writer.appendMethodBody(getChars).append("(str, 0, sz, array, 0);").softNewLine();
        this.writer.append("for (var i = 0; i < sz; i = (i + 1) | 0) {").indent().softNewLine();
        this.writer.append("result += String.fromCharCode(array.data[i]);").softNewLine();
        this.writer.outdent().append("}").softNewLine();
        this.writer.append("return result;").softNewLine();
        this.writer.outdent().append("}").newLine();
    }

    private void renderRuntimeNullCheck() throws IOException {
        String npe = "java.lang.NullPointerException";
        this.writer.append("$rt_nullCheck = function(val) {").indent().softNewLine();
        this.writer.append("if (val === null) {").indent().softNewLine();
        this.writer.append("$rt_throw(").appendClass(npe).append('.').appendMethod(npe, "<init>", ValueType.VOID).append("());").softNewLine();
        this.writer.outdent().append("}").softNewLine();
        this.writer.append("return val;").softNewLine();
        this.writer.outdent().append("}").newLine();
    }

    private void renderRuntimeObjcls() throws IOException {
        this.writer.append("$rt_objcls = function() { return ").appendClass("java.lang.Object").append("; }").newLine();
    }

    public void render(ClassNode cls) throws RenderingException {
        try {
            Object value;
            this.writer.append("function ").appendClass(cls.getName()).append("()").ws().append("{").indent().softNewLine();
            for (FieldNode field : cls.getFields()) {
                if (field.getModifiers().contains((Object)NodeModifier.STATIC)) continue;
                value = field.getInitialValue();
                if (value == null) {
                    value = Renderer.getDefaultValue(field.getType());
                }
                this.writer.append("this.").appendField(new FieldReference(cls.getName(), field.getName())).ws().append("=").ws().append(this.constantToString(value)).append(";").softNewLine();
            }
            this.writer.outdent().append("}").newLine();
            for (FieldNode field : cls.getFields()) {
                if (!field.getModifiers().contains((Object)NodeModifier.STATIC)) continue;
                value = field.getInitialValue();
                if (value == null) {
                    value = Renderer.getDefaultValue(field.getType());
                }
                this.writer.appendClass(cls.getName()).append('.').appendField(new FieldReference(cls.getName(), field.getName())).ws().append("=").ws().append(this.constantToString(value)).append(";").softNewLine();
            }
            this.writer.append("$rt_declClass(").appendClass(cls.getName()).append(",").ws().append("{").indent().softNewLine();
            this.writer.append("name").ws().append(":").ws().append("\"").append(Renderer.escapeString(cls.getName())).append("\"");
            if (cls.getModifiers().contains((Object)NodeModifier.ENUM)) {
                this.writer.append(",").softNewLine().append("enum").ws().append(":").ws().append("true");
            }
            if (!cls.getInterfaces().isEmpty()) {
                this.writer.append(",").softNewLine().append("interfaces").ws().append(":").ws().append("[");
                for (int i = 0; i < cls.getInterfaces().size(); ++i) {
                    String iface = cls.getInterfaces().get(i);
                    if (i > 0) {
                        this.writer.append(",").ws();
                    }
                    this.writer.appendClass(iface);
                }
                this.writer.append("]");
            }
            if (cls.getParentName() != null) {
                this.writer.append(",").softNewLine();
                this.writer.append("superclass").ws().append(":").ws().appendClass(cls.getParentName());
            }
            if (!cls.getModifiers().contains((Object)NodeModifier.INTERFACE)) {
                this.writer.append(",").softNewLine().append("clinit").ws().append(":").ws().append("function()").ws().append("{").ws().appendClass(cls.getName()).append("_$clinit();").ws().append("}");
            }
            this.writer.ws().append("});").newLine().outdent();
            ArrayList<MethodNode> nonInitMethods = new ArrayList<MethodNode>();
            ArrayList<MethodNode> virtualMethods = new ArrayList<MethodNode>();
            if (!cls.getModifiers().contains((Object)NodeModifier.INTERFACE)) {
                this.writer.append("function ").appendClass(cls.getName()).append("_$clinit()").ws().append("{").softNewLine().indent();
                this.writer.appendClass(cls.getName()).append("_$clinit").ws().append("=").ws().append("function(){};").newLine();
                ArrayList<String> stubNames = new ArrayList<String>();
                for (MethodNode method : cls.getMethods()) {
                    if (!method.getModifiers().contains((Object)NodeModifier.STATIC) && !method.getReference().getName().equals("<init>")) {
                        nonInitMethods.add(method);
                        continue;
                    }
                    this.renderBody(method, true);
                    stubNames.add(this.naming.getFullNameFor(method.getReference()));
                }
                MethodHolder methodHolder = this.classSource.get(cls.getName()).getMethod(new MethodDescriptor("<clinit>", ValueType.VOID));
                if (methodHolder != null) {
                    this.writer.appendMethodBody(new MethodReference(cls.getName(), methodHolder.getDescriptor())).append("();").softNewLine();
                }
                this.writer.outdent().append("}").newLine();
                for (MethodNode method : cls.getMethods()) {
                    cls.getMethods();
                    if (!method.getModifiers().contains((Object)NodeModifier.STATIC)) {
                        virtualMethods.add(method);
                        continue;
                    }
                    if (!method.isOriginalNamePreserved()) continue;
                    this.renderStaticDeclaration(method);
                }
                if (stubNames.size() > 0) {
                    this.writer.append("$rt_methodStubs(").appendClass(cls.getName()).append("_$clinit").append(",").ws().append("[");
                    for (int i = 0; i < stubNames.size(); ++i) {
                        if (i > 0) {
                            this.writer.append(",").ws();
                        }
                        this.writer.append("'").append((String)stubNames.get(i)).append("'");
                    }
                    this.writer.append("]);").newLine();
                }
            }
            for (MethodNode method : nonInitMethods) {
                this.renderBody(method, false);
            }
            this.renderVirtualDeclarations(cls.getName(), virtualMethods);
        }
        catch (NamingException e) {
            throw new RenderingException("Error rendering class " + cls.getName() + ". See a cause for details", e);
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    private static Object getDefaultValue(ValueType type) {
        if (type instanceof ValueType.Primitive) {
            ValueType.Primitive primitive = (ValueType.Primitive)type;
            switch (primitive.getKind()) {
                case BOOLEAN: {
                    return false;
                }
                case BYTE: {
                    return (byte)0;
                }
                case SHORT: {
                    return (short)0;
                }
                case INTEGER: {
                    return 0;
                }
                case CHARACTER: {
                    return Character.valueOf('\u0000');
                }
                case LONG: {
                    return 0L;
                }
                case FLOAT: {
                    return Float.valueOf(0.0f);
                }
                case DOUBLE: {
                    return 0.0;
                }
            }
        }
        return null;
    }

    private void renderInitializer(MethodNode method) throws IOException {
        int i;
        MethodReference ref = method.getReference();
        this.writer.appendClass(ref.getClassName()).append(".").appendMethod(ref).ws().append("=").ws().append("function(");
        for (i = 1; i <= ref.parameterCount(); ++i) {
            if (i > 1) {
                this.writer.append(",").ws();
            }
            this.writer.append(this.variableName(i));
        }
        this.writer.append(")").ws().append("{").newLine().indent();
        this.writer.append("var result").ws().append("=").ws().append("new ").appendClass(ref.getClassName()).append("();").softNewLine();
        this.writer.append("result.").appendMethod(ref).append("(");
        for (i = 1; i <= ref.parameterCount(); ++i) {
            if (i > 1) {
                this.writer.append(",").ws();
            }
            this.writer.append(this.variableName(i));
        }
        this.writer.append(");").softNewLine();
        this.writer.append("return result;").softNewLine();
        this.writer.outdent().append("}").newLine();
    }

    private void renderVirtualDeclarations(String className, List<MethodNode> methods) throws NamingException, IOException {
        MethodReference ref;
        for (MethodNode method : methods) {
            ref = method.getReference();
            if (!ref.getDescriptor().getName().equals("<init>")) continue;
            this.renderInitializer(method);
        }
        if (methods.isEmpty()) {
            return;
        }
        this.writer.append("$rt_virtualMethods(").appendClass(className).indent();
        for (MethodNode method : methods) {
            int i;
            ref = method.getReference();
            this.writer.append(",").newLine();
            if (method.isOriginalNamePreserved()) {
                this.writer.append("[\"").appendMethod(ref).append("\",").ws().append("\"").append(ref.getName()).append("\"]");
            } else {
                this.writer.append("\"").appendMethod(ref).append("\"");
            }
            this.writer.append(",").ws().append("function(");
            for (i = 1; i <= ref.parameterCount(); ++i) {
                if (i > 1) {
                    this.writer.append(",").ws();
                }
                this.writer.append(this.variableName(i));
            }
            this.writer.append(")").ws().append("{").ws();
            if (ref.getDescriptor().getResultType() != ValueType.VOID) {
                this.writer.append("return ");
            }
            this.writer.appendMethodBody(ref).append("(");
            this.writer.append("this");
            for (i = 1; i <= ref.parameterCount(); ++i) {
                this.writer.append(",").ws().append(this.variableName(i));
            }
            this.writer.append(");").ws().append("}");
        }
        this.writer.append(");").newLine().outdent();
    }

    private void renderStaticDeclaration(MethodNode method) throws NamingException, IOException {
        int i;
        MethodReference ref = method.getReference();
        if (ref.getDescriptor().getName().equals("<init>")) {
            this.renderInitializer(method);
        }
        this.writer.appendClass(ref.getClassName()).append(".").appendMethod(ref).ws().append("=").ws().append("function(");
        for (i = 0; i < ref.parameterCount(); ++i) {
            if (i > 0) {
                this.writer.append(", ");
            }
            this.writer.append(this.variableName(i + 1));
        }
        this.writer.append(")").ws().append("{").softNewLine().indent();
        this.writer.append("return ").appendMethodBody(ref).append("(");
        for (i = 0; i < ref.parameterCount(); ++i) {
            this.writer.append(",").ws().append(this.variableName(i + 1));
        }
        this.writer.append(");").softNewLine();
        this.writer.outdent().append("}").newLine();
        if (method.isOriginalNamePreserved()) {
            this.writer.appendClass(ref.getClassName()).append(".").append(ref.getName()).ws().append("=").ws().appendClass(ref.getClassName()).append(".").appendMethod(ref).append(';').newLine();
        }
    }

    public void renderBody(MethodNode method, boolean inner) throws IOException {
        MethodReference ref = method.getReference();
        if (inner) {
            this.writer.appendMethodBody(ref).ws().append("=").ws().append("function(");
        } else {
            this.writer.append("function ").appendMethodBody(ref).append("(");
        }
        int startParam = 0;
        if (method.getModifiers().contains((Object)NodeModifier.STATIC)) {
            startParam = 1;
        }
        for (int i = startParam; i <= ref.parameterCount(); ++i) {
            if (i > startParam) {
                this.writer.append(",").ws();
            }
            this.writer.append(this.variableName(i));
        }
        this.writer.append(")").ws().append("{").softNewLine().indent();
        method.acceptVisitor(new MethodBodyRenderer());
        this.writer.outdent().append("}").newLine();
    }

    @Override
    public void visit(AssignmentStatement statement) throws RenderingException {
        try {
            if (statement.getLeftValue() != null) {
                statement.getLeftValue().acceptVisitor(this);
                this.writer.ws().append("=").ws();
            }
            statement.getRightValue().acceptVisitor(this);
            this.writer.append(";").softNewLine();
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(SequentialStatement statement) {
        for (Statement part : statement.getSequence()) {
            part.acceptVisitor(this);
        }
    }

    @Override
    public void visit(ConditionalStatement statement) {
        try {
            block5: {
                while (true) {
                    this.writer.append("if").ws().append("(");
                    statement.getCondition().acceptVisitor(this);
                    this.writer.append(")").ws().append("{").softNewLine().indent();
                    for (Statement part : statement.getConsequent()) {
                        part.acceptVisitor(this);
                    }
                    if (statement.getAlternative().isEmpty()) break block5;
                    this.writer.outdent().append("}").ws();
                    if (statement.getAlternative().size() != 1 || !(statement.getAlternative().get(0) instanceof ConditionalStatement)) break;
                    statement = (ConditionalStatement)statement.getAlternative().get(0);
                    this.writer.append("else ");
                }
                this.writer.append("else").ws().append("{").indent().softNewLine();
                for (Statement part : statement.getAlternative()) {
                    part.acceptVisitor(this);
                }
            }
            this.writer.outdent().append("}").softNewLine();
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(SwitchStatement statement) {
        try {
            if (statement.getId() != null) {
                this.writer.append(statement.getId()).append(": ");
            }
            this.writer.append("switch").ws().append("(");
            statement.getValue().acceptVisitor(this);
            this.writer.append(")").ws().append("{").softNewLine().indent();
            for (SwitchClause clause : statement.getClauses()) {
                for (int condition : clause.getConditions()) {
                    this.writer.append("case ").append(condition).append(":").softNewLine();
                }
                this.writer.indent();
                for (Statement part : clause.getBody()) {
                    part.acceptVisitor(this);
                }
                this.writer.outdent();
            }
            if (statement.getDefaultClause() != null) {
                this.writer.append("default:").softNewLine().indent();
                for (Statement part : statement.getDefaultClause()) {
                    part.acceptVisitor(this);
                }
                this.writer.outdent();
            }
            this.writer.outdent().append("}").softNewLine();
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(WhileStatement statement) {
        try {
            if (statement.getId() != null) {
                this.writer.append(statement.getId()).append(":").ws();
            }
            this.writer.append("while").ws().append("(");
            if (statement.getCondition() != null) {
                statement.getCondition().acceptVisitor(this);
            } else {
                this.writer.append("true");
            }
            this.writer.append(")").ws().append("{").softNewLine().indent();
            for (Statement part : statement.getBody()) {
                part.acceptVisitor(this);
            }
            this.writer.outdent().append("}").softNewLine();
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(BlockStatement statement) {
        try {
            this.writer.append(statement.getId()).append(":").ws().append("{").softNewLine().indent();
            for (Statement part : statement.getBody()) {
                part.acceptVisitor(this);
            }
            this.writer.outdent().append("}").softNewLine();
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(ForStatement statement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(BreakStatement statement) {
        try {
            this.writer.append("break");
            if (statement.getTarget() != null) {
                this.writer.append(' ').append(statement.getTarget().getId());
            }
            this.writer.append(";").softNewLine();
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(ContinueStatement statement) {
        try {
            this.writer.append("continue");
            if (statement.getTarget() != null) {
                this.writer.append(' ').append(statement.getTarget().getId());
            }
            this.writer.append(";").softNewLine();
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(ReturnStatement statement) {
        try {
            this.writer.append("return");
            if (statement.getResult() != null) {
                this.writer.append(' ');
                statement.getResult().acceptVisitor(this);
            }
            this.writer.append(";").softNewLine();
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(ThrowStatement statement) {
        try {
            this.writer.append("$rt_throw(");
            statement.getException().acceptVisitor(this);
            this.writer.append(");").softNewLine();
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(IncrementStatement statement) {
        try {
            this.writer.append(this.variableName(statement.getVar()));
            if (statement.getAmount() > 0) {
                if (statement.getAmount() == 1) {
                    this.writer.append("++");
                } else {
                    this.writer.ws().append("+=").ws().append(statement.getAmount());
                }
            } else if (statement.getAmount() == -1) {
                this.writer.append("--");
            } else {
                this.writer.ws().append("-=").ws().append(statement.getAmount());
            }
            this.writer.append(";").softNewLine();
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(InitClassStatement statement) {
        try {
            this.writer.appendClass(statement.getClassName()).append("_$clinit();").softNewLine();
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    public String variableName(int index) {
        if (index == 0) {
            return this.minifying ? "$t" : "$this";
        }
        if (--index < variableNames.length()) {
            return Character.toString(variableNames.charAt(index));
        }
        return Character.toString(variableNames.charAt(index % variableNames.length())) + index / variableNames.length();
    }

    private void visitBinary(BinaryExpr expr, String op) {
        try {
            this.writer.append('(');
            expr.getFirstOperand().acceptVisitor(this);
            this.writer.ws().append(op).ws();
            expr.getSecondOperand().acceptVisitor(this);
            this.writer.append(')');
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    private void visitBinaryFunction(BinaryExpr expr, String function) {
        try {
            this.writer.append(function);
            this.writer.append('(');
            expr.getFirstOperand().acceptVisitor(this);
            this.writer.append(",").ws();
            expr.getSecondOperand().acceptVisitor(this);
            this.writer.append(')');
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(BinaryExpr expr) {
        switch (expr.getOperation()) {
            case ADD: {
                this.visitBinary(expr, "+");
                break;
            }
            case ADD_LONG: {
                this.visitBinaryFunction(expr, "Long_add");
                break;
            }
            case SUBTRACT: {
                this.visitBinary(expr, "-");
                break;
            }
            case SUBTRACT_LONG: {
                this.visitBinaryFunction(expr, "Long_sub");
                break;
            }
            case MULTIPLY: {
                this.visitBinary(expr, "*");
                break;
            }
            case MULTIPLY_LONG: {
                this.visitBinaryFunction(expr, "Long_mul");
                break;
            }
            case DIVIDE: {
                this.visitBinary(expr, "/");
                break;
            }
            case DIVIDE_LONG: {
                this.visitBinaryFunction(expr, "Long_div");
                break;
            }
            case MODULO: {
                this.visitBinary(expr, "%");
                break;
            }
            case MODULO_LONG: {
                this.visitBinaryFunction(expr, "Long_rem");
                break;
            }
            case EQUALS: {
                this.visitBinary(expr, "==");
                break;
            }
            case NOT_EQUALS: {
                this.visitBinary(expr, "!=");
                break;
            }
            case GREATER: {
                this.visitBinary(expr, ">");
                break;
            }
            case GREATER_OR_EQUALS: {
                this.visitBinary(expr, ">=");
                break;
            }
            case LESS: {
                this.visitBinary(expr, "<");
                break;
            }
            case LESS_OR_EQUALS: {
                this.visitBinary(expr, "<=");
                break;
            }
            case STRICT_EQUALS: {
                this.visitBinary(expr, "===");
                break;
            }
            case STRICT_NOT_EQUALS: {
                this.visitBinary(expr, "!==");
                break;
            }
            case COMPARE: {
                this.visitBinaryFunction(expr, "$rt_compare");
                break;
            }
            case COMPARE_LONG: {
                this.visitBinaryFunction(expr, "Long_compare");
                break;
            }
            case OR: {
                this.visitBinary(expr, "||");
                break;
            }
            case AND: {
                this.visitBinary(expr, "&&");
                break;
            }
            case BITWISE_OR: {
                this.visitBinary(expr, "|");
                break;
            }
            case BITWISE_OR_LONG: {
                this.visitBinaryFunction(expr, "Long_or");
                break;
            }
            case BITWISE_AND: {
                this.visitBinary(expr, "&");
                break;
            }
            case BITWISE_AND_LONG: {
                this.visitBinaryFunction(expr, "Long_and");
                break;
            }
            case BITWISE_XOR: {
                this.visitBinary(expr, "^");
                break;
            }
            case BITWISE_XOR_LONG: {
                this.visitBinaryFunction(expr, "Long_xor");
                break;
            }
            case LEFT_SHIFT: {
                this.visitBinary(expr, "<<");
                break;
            }
            case LEFT_SHIFT_LONG: {
                this.visitBinaryFunction(expr, "Long_shl");
                break;
            }
            case RIGHT_SHIFT: {
                this.visitBinary(expr, ">>");
                break;
            }
            case RIGHT_SHIFT_LONG: {
                this.visitBinaryFunction(expr, "Long_shr");
                break;
            }
            case UNSIGNED_RIGHT_SHIFT: {
                this.visitBinary(expr, ">>>");
                break;
            }
            case UNSIGNED_RIGHT_SHIFT_LONG: {
                this.visitBinaryFunction(expr, "Long_shru");
            }
        }
    }

    @Override
    public void visit(UnaryExpr expr) {
        try {
            switch (expr.getOperation()) {
                case NOT: {
                    this.writer.append("(!");
                    expr.getOperand().acceptVisitor(this);
                    this.writer.append(')');
                    break;
                }
                case NEGATE: {
                    this.writer.append("(-");
                    expr.getOperand().acceptVisitor(this);
                    this.writer.append(')');
                    break;
                }
                case LENGTH: {
                    expr.getOperand().acceptVisitor(this);
                    this.writer.append(".length");
                    break;
                }
                case INT_TO_LONG: {
                    this.writer.append("Long_fromInt(");
                    expr.getOperand().acceptVisitor(this);
                    this.writer.append(')');
                    break;
                }
                case NUM_TO_LONG: {
                    this.writer.append("Long_fromNumber(");
                    expr.getOperand().acceptVisitor(this);
                    this.writer.append(')');
                    break;
                }
                case LONG_TO_NUM: {
                    this.writer.append("Long_toNumber(");
                    expr.getOperand().acceptVisitor(this);
                    this.writer.append(')');
                    break;
                }
                case NEGATE_LONG: {
                    this.writer.append("Long_neg(");
                    expr.getOperand().acceptVisitor(this);
                    this.writer.append(')');
                    break;
                }
                case NOT_LONG: {
                    this.writer.append("Long_not(");
                    expr.getOperand().acceptVisitor(this);
                    this.writer.append(')');
                    break;
                }
                case BYTE_TO_INT: {
                    this.writer.append("$rt_byteToInt(");
                    expr.getOperand().acceptVisitor(this);
                    this.writer.append(')');
                    break;
                }
                case SHORT_TO_INT: {
                    this.writer.append("$rt_shortToInt(");
                    expr.getOperand().acceptVisitor(this);
                    this.writer.append(')');
                    break;
                }
                case NULL_CHECK: {
                    this.writer.append("$rt_nullCheck(");
                    expr.getOperand().acceptVisitor(this);
                    this.writer.append(')');
                }
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(ConditionalExpr expr) {
        try {
            this.writer.append('(');
            expr.getCondition().acceptVisitor(this);
            this.writer.ws().append("?").ws();
            expr.getConsequent().acceptVisitor(this);
            this.writer.ws().append(":").ws();
            expr.getAlternative().acceptVisitor(this);
            this.writer.append(')');
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(ConstantExpr expr) {
        try {
            this.writer.append(this.constantToString(expr.getValue()));
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    public String constantToString(Object cst) {
        if (cst == null) {
            return "null";
        }
        if (cst instanceof ValueType) {
            ValueType type = (ValueType)cst;
            return "$rt_cls(" + Renderer.typeToClsString(this.naming, type) + ")";
        }
        if (cst instanceof String) {
            return this.naming.getFullNameFor(internRef) + "($rt_str(\"" + Renderer.escapeString((String)cst) + "\"))";
        }
        if (cst instanceof Long) {
            long value = (Long)cst;
            if (value == 0L) {
                return "Long_ZERO";
            }
            if ((long)((int)value) == value) {
                return "Long_fromInt(" + value + ")";
            }
            return "new Long(" + (value & 0xFFFFFFFFL) + ", " + (value >>> 32) + ")";
        }
        if (cst instanceof Character) {
            return Integer.toString(((Character)cst).charValue());
        }
        return cst.toString();
    }

    public static String typeToClsString(NamingStrategy naming, ValueType type) {
        String value;
        int arrayCount = 0;
        while (type instanceof ValueType.Array) {
            ++arrayCount;
            type = ((ValueType.Array)type).getItemType();
        }
        if (type instanceof ValueType.Object) {
            ValueType.Object objType = (ValueType.Object)type;
            value = naming.getNameFor(objType.getClassName());
        } else if (type instanceof ValueType.Void) {
            value = "$rt_voidcls()";
        } else if (type instanceof ValueType.Primitive) {
            ValueType.Primitive primitiveType = (ValueType.Primitive)type;
            switch (primitiveType.getKind()) {
                case BOOLEAN: {
                    value = "$rt_booleancls()";
                    break;
                }
                case CHARACTER: {
                    value = "$rt_charcls()";
                    break;
                }
                case BYTE: {
                    value = "$rt_bytecls()";
                    break;
                }
                case SHORT: {
                    value = "$rt_shortcls()";
                    break;
                }
                case INTEGER: {
                    value = "$rt_intcls()";
                    break;
                }
                case LONG: {
                    value = "$rt_longcls()";
                    break;
                }
                case FLOAT: {
                    value = "$rt_floatcls()";
                    break;
                }
                case DOUBLE: {
                    value = "$rt_doublecls()";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The type is not renderable");
                }
            }
        } else {
            throw new IllegalArgumentException("The type is not renderable");
        }
        for (int i = 0; i < arrayCount; ++i) {
            value = "$rt_arraycls(" + value + ")";
        }
        return value;
    }

    public static String escapeString(String str) {
        StringBuilder sb = new StringBuilder();
        block8: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block8;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        sb.append("\\u00").append(Character.forDigit(c / 16, 16)).append(Character.forDigit(c % 16, 16));
                        continue block8;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public void visit(VariableExpr expr) {
        try {
            this.writer.append(this.variableName(expr.getIndex()));
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(SubscriptExpr expr) {
        try {
            expr.getArray().acceptVisitor(this);
            this.writer.append('[');
            expr.getIndex().acceptVisitor(this);
            this.writer.append(']');
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(UnwrapArrayExpr expr) {
        try {
            expr.getArray().acceptVisitor(this);
            this.writer.append(".data");
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(InvocationExpr expr) {
        try {
            Injector injector = this.getInjector(expr.getMethod());
            if (injector != null) {
                injector.generate(new InjectorContextImpl(expr.getArguments()), expr.getMethod());
                return;
            }
            String className = this.naming.getNameFor(expr.getMethod().getClassName());
            String name = this.naming.getNameFor(expr.getMethod());
            String fullName = this.naming.getFullNameFor(expr.getMethod());
            switch (expr.getType()) {
                case STATIC: {
                    this.writer.append(fullName).append("(");
                    for (int i = 0; i < expr.getArguments().size(); ++i) {
                        if (i > 0) {
                            this.writer.append(",").ws();
                        }
                        expr.getArguments().get(i).acceptVisitor(this);
                    }
                    this.writer.append(')');
                    break;
                }
                case SPECIAL: {
                    this.writer.append(fullName).append("(");
                    expr.getArguments().get(0).acceptVisitor(this);
                    for (int i = 1; i < expr.getArguments().size(); ++i) {
                        this.writer.append(",").ws();
                        expr.getArguments().get(i).acceptVisitor(this);
                    }
                    this.writer.append(")");
                    break;
                }
                case DYNAMIC: {
                    expr.getArguments().get(0).acceptVisitor(this);
                    this.writer.append(".").append(name).append("(");
                    for (int i = 1; i < expr.getArguments().size(); ++i) {
                        if (i > 1) {
                            this.writer.append(",").ws();
                        }
                        expr.getArguments().get(i).acceptVisitor(this);
                    }
                    this.writer.append(')');
                    break;
                }
                case CONSTRUCTOR: {
                    this.writer.append(className).append(".").append(name).append("(");
                    for (int i = 0; i < expr.getArguments().size(); ++i) {
                        if (i > 0) {
                            this.writer.append(",").ws();
                        }
                        expr.getArguments().get(i).acceptVisitor(this);
                    }
                    this.writer.append(')');
                }
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(QualificationExpr expr) {
        try {
            expr.getQualified().acceptVisitor(this);
            this.writer.append('.').appendField(expr.getField());
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(NewExpr expr) {
        try {
            this.writer.append("new ").append(this.naming.getNameFor(expr.getConstructedClass())).append("()");
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(NewArrayExpr expr) {
        try {
            ValueType type = expr.getType();
            while (type instanceof ValueType.Array) {
                type = ((ValueType.Array)type).getItemType();
            }
            if (type instanceof ValueType.Primitive) {
                switch (((ValueType.Primitive)type).getKind()) {
                    case BOOLEAN: {
                        this.writer.append("$rt_createBooleanArray(");
                        expr.getLength().acceptVisitor(this);
                        this.writer.append(")");
                        break;
                    }
                    case BYTE: {
                        this.writer.append("$rt_createByteArray(");
                        expr.getLength().acceptVisitor(this);
                        this.writer.append(")");
                        break;
                    }
                    case SHORT: {
                        this.writer.append("$rt_createShortArray(");
                        expr.getLength().acceptVisitor(this);
                        this.writer.append(")");
                        break;
                    }
                    case INTEGER: {
                        this.writer.append("$rt_createIntArray(");
                        expr.getLength().acceptVisitor(this);
                        this.writer.append(")");
                        break;
                    }
                    case LONG: {
                        this.writer.append("$rt_createLongArray(");
                        expr.getLength().acceptVisitor(this);
                        this.writer.append(")");
                        break;
                    }
                    case FLOAT: {
                        this.writer.append("$rt_createFloatArray(");
                        expr.getLength().acceptVisitor(this);
                        this.writer.append(")");
                        break;
                    }
                    case DOUBLE: {
                        this.writer.append("$rt_createDoubleArray(");
                        expr.getLength().acceptVisitor(this);
                        this.writer.append(")");
                        break;
                    }
                    case CHARACTER: {
                        this.writer.append("$rt_createCharArray(");
                        expr.getLength().acceptVisitor(this);
                        this.writer.append(")");
                    }
                }
            } else {
                this.writer.append("$rt_createArray(").append(Renderer.typeToClsString(this.naming, expr.getType())).append(",").ws();
                expr.getLength().acceptVisitor(this);
                this.writer.append(")");
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(NewMultiArrayExpr expr) {
        try {
            ValueType type = expr.getType();
            for (int i = 0; i < expr.getDimensions().size(); ++i) {
                type = ((ValueType.Array)type).getItemType();
            }
            if (type instanceof ValueType.Primitive) {
                switch (((ValueType.Primitive)type).getKind()) {
                    case BOOLEAN: {
                        this.writer.append("$rt_createBooleanMultiArray(");
                        break;
                    }
                    case BYTE: {
                        this.writer.append("$rt_createByteMultiArray(");
                        break;
                    }
                    case SHORT: {
                        this.writer.append("$rt_createShortMultiArray(");
                        break;
                    }
                    case INTEGER: {
                        this.writer.append("$rt_createIntMultiArray(");
                        break;
                    }
                    case LONG: {
                        this.writer.append("$rt_createLongMultiArray(");
                        break;
                    }
                    case FLOAT: {
                        this.writer.append("$rt_createFloatMultiArray(");
                        break;
                    }
                    case DOUBLE: {
                        this.writer.append("$rt_createDoubleMultiArray(");
                        break;
                    }
                    case CHARACTER: {
                        this.writer.append("$rt_createCharMultiArray(");
                    }
                }
            } else {
                this.writer.append("$rt_createMultiArray(").append(Renderer.typeToClsString(this.naming, expr.getType())).append(",").ws();
            }
            this.writer.append("[");
            boolean first = true;
            ArrayList<Expr> dimensions = new ArrayList<Expr>(expr.getDimensions());
            Collections.reverse(dimensions);
            for (Expr dimension : dimensions) {
                if (!first) {
                    this.writer.append(",").ws();
                }
                first = false;
                dimension.acceptVisitor(this);
            }
            this.writer.append("])");
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(InstanceOfExpr expr) {
        try {
            String clsName;
            ClassHolder cls;
            if (expr.getType() instanceof ValueType.Object && (cls = this.classSource.get(clsName = ((ValueType.Object)expr.getType()).getClassName())) != null && !cls.getModifiers().contains((Object)ElementModifier.INTERFACE)) {
                this.writer.append("(");
                expr.getExpr().acceptVisitor(this);
                this.writer.append(" instanceof ").appendClass(clsName).append(")");
                return;
            }
            this.writer.append("$rt_isInstance(");
            expr.getExpr().acceptVisitor(this);
            this.writer.append(",").ws().append(Renderer.typeToClsString(this.naming, expr.getType())).append(")");
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(StaticClassExpr expr) {
        try {
            this.writer.append(Renderer.typeToClsString(this.naming, expr.getType()));
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    @Override
    public void visit(TryCatchStatement statement) {
        try {
            this.writer.append("try").ws().append("{").softNewLine().indent();
            ArrayList<TryCatchStatement> sequence = new ArrayList<TryCatchStatement>();
            sequence.add(statement);
            List<Statement> protectedBody = statement.getProtectedBody();
            while (protectedBody.size() == 1 && protectedBody.get(0) instanceof TryCatchStatement) {
                TryCatchStatement nextStatement = (TryCatchStatement)protectedBody.get(0);
                sequence.add(nextStatement);
                protectedBody = nextStatement.getProtectedBody();
            }
            for (Statement part : protectedBody) {
                part.acceptVisitor(this);
            }
            this.writer.outdent().append("}").ws().append("catch").ws().append("($e)").ws().append("{").indent().softNewLine();
            this.writer.append("$je").ws().append("=").ws().append("$e.$javaException;").softNewLine();
            for (TryCatchStatement catchClause : sequence) {
                this.writer.append("if").ws().append("($je");
                if (catchClause.getExceptionType() != null) {
                    this.writer.ws().append("&&").ws().append("$je instanceof ").appendClass(catchClause.getExceptionType());
                }
                this.writer.append(")").ws().append("{").indent().softNewLine();
                if (catchClause.getExceptionVariable() != null) {
                    this.writer.append(this.variableName(catchClause.getExceptionVariable())).ws().append("=").ws().append("$je;").softNewLine();
                }
                for (Statement part : catchClause.getHandler()) {
                    part.acceptVisitor(this);
                }
                this.writer.outdent().append("}").ws().append("else ");
            }
            this.writer.append("{").indent().softNewLine();
            this.writer.append("throw $e;").softNewLine();
            this.writer.outdent().append("}").softNewLine();
            this.writer.outdent().append("}").softNewLine();
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    private Injector getInjector(MethodReference ref) {
        InjectorHolder holder = this.injectorMap.get(ref);
        if (holder == null) {
            AnnotationHolder injectedByAnnot;
            MethodHolder method = this.classSource.get(ref.getClassName()).getMethod(ref.getDescriptor());
            holder = new InjectorHolder(null);
            if (method != null && (injectedByAnnot = method.getAnnotations().get(InjectedBy.class.getName())) != null) {
                ValueType type = injectedByAnnot.getValues().get("value").getJavaClass();
                holder = new InjectorHolder(this.instantiateInjector(((ValueType.Object)type).getClassName()));
            }
            this.injectorMap.put(ref, holder);
        }
        return holder.injector;
    }

    private Injector instantiateInjector(String type) {
        try {
            Class<Injector> cls = Class.forName(type, true, this.classLoader).asSubclass(Injector.class);
            Constructor<Injector> cons = cls.getConstructor(new Class[0]);
            return cons.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Illegal injector: " + type, e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Default constructor was not found in the " + type + " injector", e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Error instantiating injector " + type, e);
        }
    }

    private class InjectorContextImpl
    implements InjectorContext {
        private List<Expr> arguments;

        public InjectorContextImpl(List<Expr> arguments) {
            this.arguments = arguments;
        }

        @Override
        public Expr getArgument(int index) {
            return this.arguments.get(index);
        }

        @Override
        public boolean isMinifying() {
            return Renderer.this.minifying;
        }

        @Override
        public SourceWriter getWriter() {
            return Renderer.this.writer;
        }

        @Override
        public void writeEscaped(String str) throws IOException {
            Renderer.this.writer.append(Renderer.escapeString(str));
        }

        @Override
        public void writeType(ValueType type) throws IOException {
            Renderer.this.writer.append(Renderer.typeToClsString(Renderer.this.naming, type));
        }

        @Override
        public void writeExpr(Expr expr) throws IOException {
            expr.acceptVisitor(Renderer.this);
        }

        @Override
        public int argumentCount() {
            return this.arguments.size();
        }
    }

    private class MethodBodyRenderer
    implements MethodNodeVisitor,
    GeneratorContext {
        private MethodBodyRenderer() {
        }

        @Override
        public void visit(NativeMethodNode methodNode) {
            try {
                methodNode.getGenerator().generate(this, Renderer.this.writer, methodNode.getReference());
            }
            catch (IOException e) {
                throw new RenderingException("IO error occured", e);
            }
        }

        @Override
        public void visit(RegularMethodNode method) {
            try {
                boolean hasVars;
                MethodReference ref = method.getReference();
                int variableCount = 0;
                for (int var : method.getVariables()) {
                    variableCount = Math.max(variableCount, var + 1);
                }
                boolean bl = hasVars = variableCount > ref.parameterCount() + 1;
                if (hasVars) {
                    Renderer.this.writer.append("var ");
                    boolean first = true;
                    for (int i = ref.parameterCount() + 1; i < variableCount; ++i) {
                        if (!first) {
                            Renderer.this.writer.append(",").ws();
                        }
                        first = false;
                        Renderer.this.writer.append(Renderer.this.variableName(i));
                    }
                    Renderer.this.writer.append(";").softNewLine();
                }
                method.getBody().acceptVisitor(Renderer.this);
            }
            catch (IOException e) {
                throw new RenderingException("IO error occured", e);
            }
        }

        @Override
        public String getParameterName(int index) {
            return Renderer.this.variableName(index);
        }

        @Override
        public ListableClassReaderSource getClassSource() {
            return Renderer.this.classSource;
        }
    }

    private static class InjectorHolder {
        public final Injector injector;

        public InjectorHolder(Injector injector) {
            this.injector = injector;
        }
    }
}

