/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.teavm.common.ConcurrentCachedMapper;
import org.teavm.common.FiniteExecutor;
import org.teavm.common.Mapper;
import org.teavm.common.SimpleFiniteExecutor;
import org.teavm.dependency.DependencyConsumer;
import org.teavm.dependency.DependencyGraphBuilder;
import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.DependencyListener;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.DependencyPlugin;
import org.teavm.dependency.DependencyStack;
import org.teavm.dependency.FieldDependency;
import org.teavm.dependency.MethodDependency;
import org.teavm.dependency.PluggableDependency;
import org.teavm.model.AnnotationReader;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class DependencyChecker
implements DependencyInfo {
    private static Object dummyValue = new Object();
    static final boolean shouldLog = System.getProperty("org.teavm.logDependencies", "false").equals("true");
    private ClassReaderSource classSource;
    private ClassLoader classLoader;
    private FiniteExecutor executor;
    private Mapper<MethodReference, MethodReader> methodReaderCache;
    private Mapper<FieldReference, FieldReader> fieldReaderCache;
    private ConcurrentMap<MethodReference, DependencyStack> stacks = new ConcurrentHashMap<MethodReference, DependencyStack>();
    private ConcurrentMap<FieldReference, DependencyStack> fieldStacks = new ConcurrentHashMap<FieldReference, DependencyStack>();
    private ConcurrentMap<String, DependencyStack> classStacks = new ConcurrentHashMap<String, DependencyStack>();
    private ConcurrentCachedMapper<MethodReference, MethodDependency> methodCache;
    private ConcurrentCachedMapper<FieldReference, FieldDependency> fieldCache;
    private ConcurrentMap<String, Object> achievableClasses = new ConcurrentHashMap<String, Object>();
    private ConcurrentMap<String, Object> initializedClasses = new ConcurrentHashMap<String, Object>();
    private List<DependencyListener> listeners = new ArrayList<DependencyListener>();
    ConcurrentMap<MethodReference, DependencyStack> missingMethods = new ConcurrentHashMap<MethodReference, DependencyStack>();
    ConcurrentMap<String, DependencyStack> missingClasses = new ConcurrentHashMap<String, DependencyStack>();
    ConcurrentMap<FieldReference, DependencyStack> missingFields = new ConcurrentHashMap<FieldReference, DependencyStack>();

    public DependencyChecker(ClassReaderSource classSource, ClassLoader classLoader) {
        this(classSource, classLoader, new SimpleFiniteExecutor());
    }

    public DependencyChecker(ClassReaderSource classSource, ClassLoader classLoader, FiniteExecutor executor) {
        this.classSource = classSource;
        this.classLoader = classLoader;
        this.executor = executor;
        this.methodReaderCache = new ConcurrentCachedMapper<MethodReference, MethodReader>(new Mapper<MethodReference, MethodReader>(){

            @Override
            public MethodReader map(MethodReference preimage) {
                return DependencyChecker.this.findMethodReader(preimage);
            }
        });
        this.fieldReaderCache = new ConcurrentCachedMapper<FieldReference, FieldReader>(new Mapper<FieldReference, FieldReader>(){

            @Override
            public FieldReader map(FieldReference preimage) {
                return DependencyChecker.this.findFieldReader(preimage);
            }
        });
        this.methodCache = new ConcurrentCachedMapper<MethodReference, MethodDependency>(new Mapper<MethodReference, MethodDependency>(){

            @Override
            public MethodDependency map(MethodReference preimage) {
                MethodReader method = (MethodReader)DependencyChecker.this.methodReaderCache.map(preimage);
                if (method != null && !method.getReference().equals(preimage)) {
                    DependencyChecker.this.stacks.put(method.getReference(), DependencyChecker.this.stacks.get(preimage));
                    return (MethodDependency)DependencyChecker.this.methodCache.map(method.getReference());
                }
                return DependencyChecker.this.createMethodDep(preimage, method, (DependencyStack)DependencyChecker.this.stacks.get(preimage));
            }
        });
        this.fieldCache = new ConcurrentCachedMapper<FieldReference, FieldDependency>(new Mapper<FieldReference, FieldDependency>(){

            @Override
            public FieldDependency map(FieldReference preimage) {
                FieldReader field = (FieldReader)DependencyChecker.this.fieldReaderCache.map(preimage);
                if (field != null && !field.getReference().equals(preimage)) {
                    DependencyChecker.this.fieldStacks.put(field.getReference(), DependencyChecker.this.fieldStacks.get(preimage));
                    return (FieldDependency)DependencyChecker.this.fieldCache.map(field.getReference());
                }
                return DependencyChecker.this.createFieldNode(preimage, field, (DependencyStack)DependencyChecker.this.fieldStacks.get(preimage));
            }
        });
        this.methodCache.addKeyListener(new ConcurrentCachedMapper.KeyListener<MethodReference>(){

            @Override
            public void keyAdded(MethodReference key) {
                MethodDependency graph = (MethodDependency)DependencyChecker.this.methodCache.getKnown(key);
                if (!graph.isMissing()) {
                    for (DependencyListener listener : DependencyChecker.this.listeners) {
                        listener.methodAchieved(DependencyChecker.this, graph);
                    }
                    DependencyChecker.this.activateDependencyPlugin(graph);
                }
            }
        });
        this.fieldCache.addKeyListener(new ConcurrentCachedMapper.KeyListener<FieldReference>(){

            @Override
            public void keyAdded(FieldReference key) {
                FieldDependency fieldDep = (FieldDependency)DependencyChecker.this.fieldCache.getKnown(key);
                if (!fieldDep.isMissing()) {
                    for (DependencyListener listener : DependencyChecker.this.listeners) {
                        listener.fieldAchieved(DependencyChecker.this, fieldDep);
                    }
                }
            }
        });
    }

    public DependencyNode createNode() {
        return new DependencyNode(this);
    }

    public ClassReaderSource getClassSource() {
        return this.classSource;
    }

    public void addDependencyListener(DependencyListener listener) {
        this.listeners.add(listener);
        listener.started(this);
    }

    public void addEntryPoint(MethodReference methodRef, String ... argumentTypes) {
        ValueType[] parameters = methodRef.getDescriptor().getParameterTypes();
        if (parameters.length != argumentTypes.length) {
            throw new IllegalArgumentException("argumentTypes length does not match the number of method's arguments");
        }
        MethodDependency method = this.linkMethod(methodRef, DependencyStack.ROOT);
        method.use();
        DependencyNode[] varNodes = method.getVariables();
        varNodes[0].propagate(methodRef.getClassName());
        for (int i = 0; i < argumentTypes.length; ++i) {
            varNodes[i + 1].propagate(argumentTypes[i]);
        }
    }

    public void schedulePropagation(final DependencyConsumer consumer, final String type) {
        this.executor.executeFast(new Runnable(){

            @Override
            public void run() {
                consumer.consume(type);
            }
        });
    }

    public FiniteExecutor getExecutor() {
        return this.executor;
    }

    boolean achieveClass(String className, DependencyStack stack) {
        boolean result;
        this.classStacks.putIfAbsent(className, stack);
        boolean bl = result = this.achievableClasses.putIfAbsent(className, dummyValue) == null;
        if (result) {
            for (DependencyListener listener : this.listeners) {
                listener.classAchieved(this, className);
            }
        }
        return result;
    }

    public MethodDependency linkMethod(MethodReference methodRef, DependencyStack stack) {
        if (methodRef == null) {
            throw new IllegalArgumentException();
        }
        this.stacks.putIfAbsent(methodRef, stack);
        return this.methodCache.map(methodRef);
    }

    public void initClass(String className, final DependencyStack stack) {
        this.classStacks.putIfAbsent(className, stack);
        MethodDescriptor clinitDesc = new MethodDescriptor("<clinit>", ValueType.VOID);
        while (className != null && this.initializedClasses.putIfAbsent(className, clinitDesc) == null) {
            this.achieveClass(className, stack);
            this.achieveInterfaces(className, stack);
            ClassReader cls = this.classSource.get(className);
            if (cls == null) {
                this.missingClasses.put(className, stack);
                return;
            }
            if (cls.getMethod(clinitDesc) != null) {
                final MethodReference methodRef = new MethodReference(className, clinitDesc);
                this.executor.executeFast(new Runnable(){

                    @Override
                    public void run() {
                        DependencyChecker.this.linkMethod(methodRef, new DependencyStack(methodRef, stack)).use();
                    }
                });
            }
            className = cls.getParent();
        }
    }

    private void achieveInterfaces(String className, DependencyStack stack) {
        this.classStacks.putIfAbsent(className, stack);
        ClassReader cls = this.classSource.get(className);
        if (cls == null) {
            this.missingClasses.put(className, stack);
            return;
        }
        for (String iface : cls.getInterfaces()) {
            if (!this.achieveClass(iface, stack)) continue;
            this.achieveInterfaces(iface, stack);
        }
    }

    private MethodReader findMethodReader(MethodReference methodRef) {
        String clsName = methodRef.getClassName();
        MethodDescriptor desc = methodRef.getDescriptor();
        ClassReader cls = this.classSource.get(clsName);
        if (cls == null) {
            return null;
        }
        MethodReader reader = cls.getMethod(desc);
        if (reader != null) {
            return reader;
        }
        if (cls.getParent() != null && (reader = this.methodReaderCache.map(new MethodReference(cls.getParent(), desc))) != null) {
            return reader;
        }
        for (String ifaceName : cls.getInterfaces()) {
            reader = this.methodReaderCache.map(new MethodReference(ifaceName, desc));
            if (reader == null) continue;
            return reader;
        }
        return null;
    }

    private FieldReader findFieldReader(FieldReference fieldRef) {
        String clsName = fieldRef.getClassName();
        String name = fieldRef.getFieldName();
        while (clsName != null) {
            ClassReader cls = this.classSource.get(clsName);
            if (cls == null) {
                return null;
            }
            FieldReader field = cls.getField(name);
            if (field != null) {
                return field;
            }
            clsName = cls.getParent();
        }
        return null;
    }

    private MethodDependency createMethodDep(MethodReference methodRef, MethodReader method, DependencyStack stack) {
        DependencyNode resultNode;
        if (stack == null) {
            stack = DependencyStack.ROOT;
        }
        ValueType[] arguments = methodRef.getParameterTypes();
        int paramCount = arguments.length + 1;
        int varCount = Math.max(paramCount, method != null && method.getProgram() != null ? method.getProgram().variableCount() : 0);
        DependencyNode[] parameterNodes = new DependencyNode[varCount];
        for (int i = 0; i < varCount; ++i) {
            parameterNodes[i] = new DependencyNode(this);
            if (!shouldLog) continue;
            parameterNodes[i].setTag(methodRef + ":" + i);
        }
        if (methodRef.getDescriptor().getResultType() == ValueType.VOID) {
            resultNode = null;
        } else {
            resultNode = new DependencyNode(this);
            if (shouldLog) {
                resultNode.setTag(methodRef + ":RESULT");
            }
        }
        DependencyNode thrown = this.createNode();
        if (shouldLog) {
            thrown.setTag(methodRef + ":THROWN");
        }
        stack = new DependencyStack(methodRef, stack);
        final MethodDependency dep = new MethodDependency(parameterNodes, paramCount, resultNode, thrown, stack, method, methodRef);
        if (method != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    DependencyGraphBuilder graphBuilder = new DependencyGraphBuilder(DependencyChecker.this);
                    graphBuilder.buildGraph(dep);
                }
            });
        } else {
            this.missingMethods.putIfAbsent(methodRef, stack);
        }
        if (method != null) {
            final DependencyStack callerStack = stack;
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    DependencyChecker.this.initClass(dep.getReference().getClassName(), callerStack);
                }
            });
        }
        return dep;
    }

    public boolean isMethodAchievable(MethodReference methodRef) {
        return this.methodCache.caches(methodRef);
    }

    @Override
    public Collection<MethodReference> getAchievableMethods() {
        return this.methodCache.getCachedPreimages();
    }

    @Override
    public Collection<FieldReference> getAchievableFields() {
        return this.fieldCache.getCachedPreimages();
    }

    @Override
    public Collection<String> getAchievableClasses() {
        return new HashSet<String>(this.achievableClasses.keySet());
    }

    public FieldDependency linkField(FieldReference fieldRef, DependencyStack stack) {
        this.fieldStacks.putIfAbsent(fieldRef, stack);
        return this.fieldCache.map(fieldRef);
    }

    @Override
    public FieldDependency getField(FieldReference fieldRef) {
        return this.fieldCache.getKnown(fieldRef);
    }

    private FieldDependency createFieldNode(FieldReference fieldRef, FieldReader field, DependencyStack stack) {
        DependencyNode node = new DependencyNode(this);
        if (field == null) {
            this.missingFields.putIfAbsent(fieldRef, stack);
        }
        if (shouldLog) {
            node.setTag(fieldRef.getClassName() + "#" + fieldRef.getFieldName());
        }
        if (field != null) {
            this.initClass(fieldRef.getClassName(), stack);
        }
        return new FieldDependency(node, stack, field, fieldRef);
    }

    private void activateDependencyPlugin(MethodDependency methodDep) {
        DependencyPlugin plugin;
        Class<?> depClass;
        AnnotationReader depAnnot = methodDep.getMethod().getAnnotations().get(PluggableDependency.class.getName());
        if (depAnnot == null) {
            return;
        }
        ValueType depType = depAnnot.getValue("value").getJavaClass();
        String depClassName = ((ValueType.Object)depType).getClassName();
        try {
            depClass = Class.forName(depClassName, true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Dependency plugin not found: " + depClassName, e);
        }
        try {
            plugin = (DependencyPlugin)depClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Can't instantiate dependency plugin " + depClassName, e);
        }
        plugin.methodAchieved(this, methodDep);
    }

    @Override
    public MethodDependency getMethod(MethodReference methodRef) {
        return this.methodCache.getKnown(methodRef);
    }

    public void checkForMissingItems() {
        if (!this.hasMissingItems()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        try {
            this.showMissingItems(sb);
        }
        catch (IOException e) {
            throw new AssertionError((Object)"StringBuilder should not throw IOException");
        }
        throw new IllegalStateException(sb.toString());
    }

    public boolean hasMissingItems() {
        return !this.missingClasses.isEmpty() || !this.missingMethods.isEmpty() || !this.missingFields.isEmpty();
    }

    public void showMissingItems(Appendable sb) throws IOException {
        ArrayList<String> items = new ArrayList<String>();
        HashMap stackMap = new HashMap();
        for (String cls : this.missingClasses.keySet()) {
            stackMap.put(cls, this.missingClasses.get(cls));
            items.add(cls);
        }
        for (MethodReference method : this.missingMethods.keySet()) {
            stackMap.put(method.toString(), this.missingMethods.get(method));
            items.add(method.toString());
        }
        for (FieldReference field : this.missingFields.keySet()) {
            stackMap.put(field.toString(), this.missingFields.get(field));
            items.add(field.toString());
        }
        Collections.sort(items);
        sb.append("Can't compile due to the following items missing:\n");
        for (String item : items) {
            sb.append("  ").append(item).append("\n");
            DependencyStack stack = (DependencyStack)stackMap.get(item);
            if (stack == null) {
                sb.append("    at unknown location\n");
            } else {
                while (stack.getMethod() != null) {
                    sb.append("    at " + stack.getMethod() + "\n");
                    stack = stack.getCause();
                }
            }
            sb.append('\n');
        }
    }
}

