/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

import java.util.Arrays;
import java.util.Comparator;
import org.teavm.common.Graph;
import org.teavm.common.GraphBuilder;
import org.teavm.common.Loop;
import org.teavm.common.LoopGraph;

public class GraphIndexer {
    static final byte NONE = 0;
    static final byte VISITING = 1;
    static final byte VISITED = 2;
    private int[] indexToNode;
    private int[] nodeToIndex;
    private Graph graph;

    public GraphIndexer(Graph graph) {
        this.sort(graph);
    }

    private int sort(Graph graph) {
        int node;
        LoopGraph loopGraph = new LoopGraph(graph);
        int sz = graph.size();
        int[] indexToNode = new int[sz + 1];
        int[] nodeToIndex = new int[sz + 1];
        int[] visitIndex = new int[sz + 1];
        Arrays.fill(nodeToIndex, -1);
        Arrays.fill(indexToNode, -1);
        Arrays.fill(visitIndex, -1);
        byte[] state = new byte[sz];
        int lastIndex = 0;
        int lastVisitIndex = 0;
        int[] stack = new int[sz * 2];
        int stackSize = 0;
        int n = stack[stackSize++] = loopGraph.loopAt(0) != null ? loopGraph.loopAt(0).getHead() : 0;
        block7: while (stackSize > 0) {
            node = stack[--stackSize];
            switch (state[node]) {
                case 1: {
                    state[node] = 2;
                    nodeToIndex[node] = lastIndex++;
                    break;
                }
                case 0: {
                    visitIndex[node] = lastVisitIndex++;
                    state[node] = 1;
                    stack[stackSize++] = node;
                    int[] successors = graph.outgoingEdges(node);
                    LoopEntrance[] edges = new LoopEntrance[successors.length];
                    for (int i = 0; i < edges.length; ++i) {
                        int successor = successors[i];
                        Loop successorLoop = loopGraph.loopAt(successor);
                        LoopEntrance edge = new LoopEntrance();
                        edge.head = successorLoop != null ? visitIndex[successorLoop.getHead()] : -1;
                        edge.follower = successor;
                        edges[i] = edge;
                    }
                    Arrays.sort(edges, new Comparator<LoopEntrance>(){

                        @Override
                        public int compare(LoopEntrance o1, LoopEntrance o2) {
                            return Integer.compare(o2.head, o1.head);
                        }
                    });
                    block9: for (LoopEntrance edge : edges) {
                        int next = edge.follower;
                        switch (state[next]) {
                            case 0: {
                                stack[stackSize++] = next;
                                continue block9;
                            }
                        }
                    }
                    continue block7;
                }
            }
        }
        --lastIndex;
        for (node = 0; node < sz; ++node) {
            int index = nodeToIndex[node];
            if (index < 0) continue;
            nodeToIndex[node] = index = lastIndex - index;
            indexToNode[index] = node;
        }
        indexToNode[sz] = sz;
        nodeToIndex[sz] = sz;
        GraphBuilder sorted = new GraphBuilder(lastIndex + 2);
        for (int i = 0; i <= lastIndex; ++i) {
            for (int next : graph.outgoingEdges(indexToNode[i])) {
                sorted.addEdge(i, nodeToIndex[next]);
            }
        }
        this.graph = sorted.build();
        this.indexToNode = indexToNode;
        this.nodeToIndex = nodeToIndex;
        return lastIndex + 1;
    }

    public int nodeAt(int index) {
        return this.indexToNode[index];
    }

    public int indexOf(int node) {
        return this.nodeToIndex[node];
    }

    public int size() {
        return this.indexToNode.length - 1;
    }

    public Graph getGraph() {
        return this.graph;
    }

    private static class LoopEntrance {
        int head;
        int follower;

        private LoopEntrance() {
        }
    }
}

