/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.teavm.common.Graph;
import org.teavm.common.IntegerArray;

public class GraphBuilder {
    private GraphImpl builtGraph;
    private List<IntegerArray> addedEdges = new ArrayList<IntegerArray>();
    private int sz;

    public GraphBuilder() {
    }

    public GraphBuilder(int sz) {
        this.addedEdges.addAll(Collections.nCopies(sz, null));
        this.sz = sz;
    }

    public void clear() {
        this.addedEdges.clear();
        this.sz = 0;
    }

    public void addEdge(int from, int to) {
        if (to < 0 || from < 0) {
            throw new IllegalArgumentException();
        }
        this.sz = Math.max(this.sz, Math.max(from, to) + 1);
        this.builtGraph = null;
        if (this.addedEdges.size() == from) {
            this.addedEdges.add(IntegerArray.of(to));
        } else if (this.addedEdges.size() <= from) {
            this.addedEdges.addAll(Collections.nCopies(from - this.addedEdges.size(), null));
            this.addedEdges.add(IntegerArray.of(to));
        } else {
            IntegerArray set = this.addedEdges.get(from);
            if (set == null) {
                this.addedEdges.set(from, IntegerArray.of(to));
            } else {
                set.add(to);
            }
        }
    }

    public Graph build() {
        if (this.builtGraph == null) {
            int i;
            IntegerArray[] incomingEdges = new IntegerArray[this.sz];
            for (int i2 = 0; i2 < this.sz; ++i2) {
                incomingEdges[i2] = new IntegerArray(1);
            }
            int[][] outgoingEdgeList = new int[this.sz][];
            for (i = 0; i < this.addedEdges.size(); ++i) {
                IntegerArray edgeList = this.addedEdges.get(i);
                outgoingEdgeList[i] = edgeList != null ? edgeList.getAll() : new int[]{};
                for (int j : outgoingEdgeList[i]) {
                    incomingEdges[j].add(i);
                }
            }
            for (i = this.addedEdges.size(); i < this.sz; ++i) {
                outgoingEdgeList[i] = new int[0];
            }
            int[][] incomingEdgeList = new int[this.sz][];
            for (int i3 = 0; i3 < this.sz; ++i3) {
                incomingEdgeList[i3] = incomingEdges[i3].getAll();
            }
            this.builtGraph = new GraphImpl(incomingEdgeList, outgoingEdgeList);
        }
        return this.builtGraph;
    }

    private static class GraphImpl
    implements Graph {
        private final int[][] incomingEdgeList;
        private final int[][] outgoingEdgeList;

        public GraphImpl(int[][] incomingEdgeList, int[][] outgoingEdgeList) {
            this.incomingEdgeList = incomingEdgeList;
            this.outgoingEdgeList = outgoingEdgeList;
        }

        @Override
        public int size() {
            return this.incomingEdgeList.length;
        }

        @Override
        public int[] incomingEdges(int node) {
            int[] result = this.incomingEdgeList[node];
            return Arrays.copyOf(result, result.length);
        }

        @Override
        public int copyIncomingEdges(int node, int[] target) {
            int[] result = this.incomingEdgeList[node];
            System.arraycopy(result, 0, target, 0, result.length);
            return result.length;
        }

        @Override
        public int[] outgoingEdges(int node) {
            int[] result = this.outgoingEdgeList[node];
            return Arrays.copyOf(result, result.length);
        }

        @Override
        public int copyOutgoingEdges(int node, int[] target) {
            int[] result = this.outgoingEdgeList[node];
            System.arraycopy(result, 0, target, 0, result.length);
            return result.length;
        }

        @Override
        public int incomingEdgesCount(int node) {
            return this.incomingEdgeList[node].length;
        }

        @Override
        public int outgoingEdgesCount(int node) {
            return this.outgoingEdgeList[node].length;
        }
    }
}

