/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.codegen;

import java.io.IOException;
import org.teavm.codegen.NamingException;
import org.teavm.codegen.NamingStrategy;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class SourceWriter
implements Appendable {
    private Appendable innerWriter;
    private int indentSize;
    private NamingStrategy naming;
    private boolean lineStart;
    private boolean minified;

    SourceWriter(NamingStrategy naming, Appendable innerWriter) {
        this.naming = naming;
        this.innerWriter = innerWriter;
    }

    void setMinified(boolean minified) {
        this.minified = minified;
    }

    public SourceWriter append(String value) throws IOException {
        this.appendIndent();
        this.innerWriter.append(value);
        return this;
    }

    public SourceWriter append(Object value) throws IOException {
        return this.append(String.valueOf(value));
    }

    public SourceWriter append(int value) throws IOException {
        return this.append(String.valueOf(value));
    }

    @Override
    public SourceWriter append(char value) throws IOException {
        this.appendIndent();
        this.innerWriter.append(value);
        return this;
    }

    @Override
    public SourceWriter append(CharSequence csq) throws IOException {
        this.appendIndent();
        this.innerWriter.append(csq);
        return this;
    }

    @Override
    public SourceWriter append(CharSequence csq, int start, int end) throws IOException {
        this.appendIndent();
        this.innerWriter.append(csq, start, end);
        return this;
    }

    public SourceWriter appendClass(String cls) throws NamingException, IOException {
        return this.append(this.naming.getNameFor(cls));
    }

    public SourceWriter appendField(FieldReference field) throws NamingException, IOException {
        return this.append(this.naming.getNameFor(field));
    }

    public SourceWriter appendMethod(MethodReference method) throws NamingException, IOException {
        return this.append(this.naming.getNameFor(method));
    }

    public SourceWriter appendMethod(String className, String name, ValueType ... params) throws NamingException, IOException {
        return this.append(this.naming.getNameFor(new MethodReference(className, new MethodDescriptor(name, params))));
    }

    public SourceWriter appendMethodBody(MethodReference method) throws NamingException, IOException {
        return this.append(this.naming.getFullNameFor(method));
    }

    public SourceWriter appendMethodBody(String className, String name, ValueType ... params) throws NamingException, IOException {
        return this.append(this.naming.getFullNameFor(new MethodReference(className, new MethodDescriptor(name, params))));
    }

    private void appendIndent() throws IOException {
        if (this.minified) {
            return;
        }
        if (this.lineStart) {
            for (int i = 0; i < this.indentSize; ++i) {
                this.innerWriter.append("    ");
            }
            this.lineStart = false;
        }
    }

    public SourceWriter newLine() throws IOException {
        this.innerWriter.append('\n');
        this.lineStart = true;
        return this;
    }

    public SourceWriter ws() throws IOException {
        if (!this.minified) {
            this.innerWriter.append(' ');
        }
        return this;
    }

    public SourceWriter softNewLine() throws IOException {
        if (!this.minified) {
            this.innerWriter.append('\n');
            this.lineStart = true;
        }
        return this;
    }

    public SourceWriter indent() {
        ++this.indentSize;
        return this;
    }

    public SourceWriter outdent() {
        --this.indentSize;
        return this;
    }

    public NamingStrategy getNaming() {
        return this.naming;
    }
}

