/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.cli;

import java.util.Arrays;
import org.teavm.apachecommons.cli.CommandLine;
import org.teavm.apachecommons.cli.DefaultParser;
import org.teavm.apachecommons.cli.HelpFormatter;
import org.teavm.apachecommons.cli.Option;
import org.teavm.apachecommons.cli.Options;
import org.teavm.apachecommons.cli.ParseException;
import org.teavm.devserver.DevServer;
import org.teavm.tooling.ConsoleTeaVMToolLog;
import org.teavm.tooling.TeaVMToolLog;

public final class TeaVMDevServerRunner {
    private static Options options = new Options();
    private DevServer devServer;
    private CommandLine commandLine;

    private static void setupOptions() {
        options.addOption(Option.builder((String)"d").argName("directory").hasArg().desc("a directory, relative to server's root, which serves generated files").longOpt("targetdir").build());
        options.addOption(Option.builder((String)"f").argName("file").hasArg().desc("a file where to put decompiled classes (classes.js by default)").longOpt("targetfile").build());
        options.addOption(Option.builder((String)"p").argName("classpath").hasArgs().desc("classpath element (either directory or jar file)").longOpt("classpath").build());
        options.addOption(Option.builder((String)"s").argName("sourcepath").hasArg().desc("source path (either directory or jar file which contains source code)").longOpt("sourcepath").build());
        options.addOption(Option.builder().argName("number").hasArg().desc("port (default is 9090)").longOpt("port").build());
        options.addOption(Option.builder((String)"i").desc("display indicator on web page").longOpt("indicator").build());
        options.addOption(Option.builder().desc("deobfuscate stack traces").longOpt("deobfuscate-stack").build());
        options.addOption(Option.builder().desc("automatically reload page when compilation completes").longOpt("auto-reload").build());
        options.addOption(Option.builder((String)"v").desc("display more messages on server log").longOpt("verbose").build());
        options.addOption(Option.builder().argName("URL").hasArg().desc("delegate requests to URL").longOpt("proxy-url").build());
        options.addOption(Option.builder().argName("path").hasArg().desc("delegate requests from path").longOpt("proxy-path").build());
    }

    private TeaVMDevServerRunner(CommandLine commandLine) {
        this.commandLine = commandLine;
        this.devServer = new DevServer();
    }

    public static void main(String[] args) {
        CommandLine commandLine;
        if (args.length == 0) {
            TeaVMDevServerRunner.printUsage();
            return;
        }
        DefaultParser parser = new DefaultParser();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            TeaVMDevServerRunner.printUsage();
            return;
        }
        TeaVMDevServerRunner runner = new TeaVMDevServerRunner(commandLine);
        runner.parseArguments();
        runner.runAll();
    }

    private void parseArguments() {
        String[] args;
        this.parseClassPathOptions();
        this.parseSourcePathOptions();
        this.parseOutputOptions();
        this.devServer.setIndicator(this.commandLine.hasOption("indicator"));
        this.devServer.setDeobfuscateStack(this.commandLine.hasOption("deobfuscate-stack"));
        this.devServer.setReloadedAutomatically(this.commandLine.hasOption("auto-reload"));
        this.devServer.setLog((TeaVMToolLog)new ConsoleTeaVMToolLog(this.commandLine.hasOption('v')));
        if (this.commandLine.hasOption("port")) {
            try {
                this.devServer.setPort(Integer.parseInt(this.commandLine.getOptionValue("port")));
            }
            catch (NumberFormatException e) {
                System.err.println("port must be numeric");
                TeaVMDevServerRunner.printUsage();
            }
        }
        if (this.commandLine.hasOption("proxy-url")) {
            this.devServer.setProxyUrl(this.commandLine.getOptionValue("proxy-url"));
        }
        if (this.commandLine.hasOption("proxy-path")) {
            this.devServer.setProxyPath(this.commandLine.getOptionValue("proxy-path"));
        }
        if ((args = this.commandLine.getArgs()).length != 1) {
            System.err.println("Unexpected arguments");
            TeaVMDevServerRunner.printUsage();
        } else {
            this.devServer.setMainClass(args[0]);
        }
    }

    private void parseOutputOptions() {
        if (this.commandLine.hasOption("d")) {
            this.devServer.setPathToFile(this.commandLine.getOptionValue("d"));
        }
        if (this.commandLine.hasOption("f")) {
            this.devServer.setFileName(this.commandLine.getOptionValue("f"));
        }
    }

    private void parseClassPathOptions() {
        if (this.commandLine.hasOption('p')) {
            this.devServer.setClassPath(this.commandLine.getOptionValues('p'));
        }
    }

    private void parseSourcePathOptions() {
        if (this.commandLine.hasOption('s')) {
            this.devServer.getSourcePath().addAll(Arrays.asList(this.commandLine.getOptionValues('s')));
        }
    }

    private void runAll() {
        this.devServer.start();
    }

    private static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java " + TeaVMDevServerRunner.class.getName() + " [OPTIONS] [qualified.main.Class]", options);
        System.exit(-1);
    }

    static {
        TeaVMDevServerRunner.setupOptions();
    }
}

