/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.parsing;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.teavm.asm.AnnotationVisitor;
import org.teavm.asm.Attribute;
import org.teavm.asm.Handle;
import org.teavm.asm.Label;
import org.teavm.asm.MethodVisitor;
import org.teavm.asm.Type;
import org.teavm.asm.tree.AbstractInsnNode;
import org.teavm.asm.tree.InsnList;
import org.teavm.asm.tree.LabelNode;
import org.teavm.asm.tree.LineNumberNode;
import org.teavm.asm.tree.LocalVariableNode;
import org.teavm.asm.tree.MethodNode;
import org.teavm.asm.tree.TryCatchBlockNode;
import org.teavm.model.BasicBlock;
import org.teavm.model.FieldReference;
import org.teavm.model.Instruction;
import org.teavm.model.InvokeDynamicInstruction;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHandle;
import org.teavm.model.Program;
import org.teavm.model.ReferenceCache;
import org.teavm.model.RuntimeConstant;
import org.teavm.model.TextLocation;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.ArrayElementType;
import org.teavm.model.instructions.ArrayLengthInstruction;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.BinaryBranchingCondition;
import org.teavm.model.instructions.BinaryBranchingInstruction;
import org.teavm.model.instructions.BinaryInstruction;
import org.teavm.model.instructions.BinaryOperation;
import org.teavm.model.instructions.BranchingCondition;
import org.teavm.model.instructions.BranchingInstruction;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.CastIntegerDirection;
import org.teavm.model.instructions.CastIntegerInstruction;
import org.teavm.model.instructions.CastNumberInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.CloneArrayInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ConstructMultiArrayInstruction;
import org.teavm.model.instructions.DoubleConstantInstruction;
import org.teavm.model.instructions.EmptyInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.FloatConstantInstruction;
import org.teavm.model.instructions.GetElementInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.IntegerSubtype;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.IsInstanceInstruction;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.instructions.LongConstantInstruction;
import org.teavm.model.instructions.MonitorEnterInstruction;
import org.teavm.model.instructions.MonitorExitInstruction;
import org.teavm.model.instructions.NegateInstruction;
import org.teavm.model.instructions.NullConstantInstruction;
import org.teavm.model.instructions.NumericOperandType;
import org.teavm.model.instructions.PutElementInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.instructions.SwitchInstruction;
import org.teavm.model.instructions.SwitchTableEntry;
import org.teavm.model.instructions.UnwrapArrayInstruction;
import org.teavm.model.util.TransitionExtractor;

public class ProgramParser {
    private ReferenceCache referenceCache;
    private static final byte ROOT = 0;
    private static final byte SINGLE = 1;
    private static final byte DOUBLE_FIRST_HALF = 2;
    private static final byte DOUBLE_SECOND_HALF = 3;
    private String fileName;
    private StackFrame[] stackBefore;
    private StackFrame[] stackAfter;
    private StackFrame stack;
    private int index;
    private int[] nextIndexes;
    private Map<Label, Integer> labelIndexes;
    private Map<Label, Integer> lineNumbers;
    private List<List<Instruction>> targetInstructions;
    private List<Instruction> builder = new ArrayList<Instruction>();
    private List<BasicBlock> basicBlocks = new ArrayList<BasicBlock>();
    private int minLocal;
    private Program program;
    private Map<Integer, List<LocalVariableNode>> localVariableMap = new HashMap<Integer, List<LocalVariableNode>>();
    private Map<Instruction, Map<Integer, String>> variableDebugNames = new HashMap<Instruction, Map<Integer, String>>();
    private MethodVisitor methodVisitor = new MethodVisitor(458752){

        @Override
        public void visitVarInsn(int opcode, int local) {
            switch (opcode) {
                case 21: 
                case 23: 
                case 25: {
                    ProgramParser.this.emitAssignInsn(ProgramParser.this.minLocal + ProgramParser.this.mapLocal(local), ProgramParser.this.pushSingle());
                    break;
                }
                case 22: 
                case 24: {
                    ProgramParser.this.emitAssignInsn(ProgramParser.this.minLocal + ProgramParser.this.mapLocal(local), ProgramParser.this.pushDouble());
                    break;
                }
                case 54: 
                case 56: 
                case 58: {
                    ProgramParser.this.emitAssignInsn(ProgramParser.this.popSingle(), ProgramParser.this.minLocal + ProgramParser.this.mapLocal(local));
                    break;
                }
                case 55: 
                case 57: {
                    ProgramParser.this.emitAssignInsn(ProgramParser.this.popDouble(), ProgramParser.this.minLocal + ProgramParser.this.mapLocal(local));
                }
            }
        }

        private ValueType parseType(String type) {
            if (type.startsWith("[")) {
                return ProgramParser.this.referenceCache.parseValueTypeCached(type);
            }
            return ProgramParser.this.referenceCache.getCached(ValueType.object(type.replace('/', '.')));
        }

        @Override
        public void visitTypeInsn(int opcode, String type) {
            switch (opcode) {
                case 187: {
                    String cls = type.replace('/', '.');
                    ConstructInstruction insn = new ConstructInstruction();
                    insn.setReceiver(ProgramParser.this.getVariable(ProgramParser.this.pushSingle()));
                    insn.setType(ProgramParser.this.referenceCache.getCached(cls));
                    ProgramParser.this.addInstruction(insn);
                    break;
                }
                case 189: {
                    ValueType valueType = this.parseType(type);
                    ConstructArrayInstruction insn = new ConstructArrayInstruction();
                    insn.setSize(ProgramParser.this.getVariable(ProgramParser.this.popSingle()));
                    insn.setReceiver(ProgramParser.this.getVariable(ProgramParser.this.pushSingle()));
                    insn.setItemType(valueType);
                    ProgramParser.this.addInstruction(insn);
                    break;
                }
                case 193: {
                    IsInstanceInstruction insn = new IsInstanceInstruction();
                    insn.setValue(ProgramParser.this.getVariable(ProgramParser.this.popSingle()));
                    insn.setReceiver(ProgramParser.this.getVariable(ProgramParser.this.pushSingle()));
                    insn.setType(this.parseType(type));
                    ProgramParser.this.addInstruction(insn);
                    break;
                }
                case 192: {
                    CastInstruction insn = new CastInstruction();
                    insn.setValue(ProgramParser.this.getVariable(ProgramParser.this.popSingle()));
                    insn.setReceiver(ProgramParser.this.getVariable(ProgramParser.this.pushSingle()));
                    insn.setTargetType(this.parseType(type));
                    ProgramParser.this.addInstruction(insn);
                    break;
                }
            }
        }

        @Override
        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        }

        @Override
        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
            SwitchTableEntry[] table = new SwitchTableEntry[labels.length];
            ProgramParser.access$1002(ProgramParser.this, new int[labels.length + 1]);
            for (int i = 0; i < labels.length; ++i) {
                Label label = labels[i];
                int target = (Integer)ProgramParser.this.labelIndexes.get(label);
                SwitchTableEntry entry = new SwitchTableEntry();
                entry.setCondition(i + min);
                entry.setTarget(ProgramParser.this.getBasicBlock(target));
                table[i] = entry;
                ((ProgramParser)ProgramParser.this).nextIndexes[i] = target;
            }
            SwitchInstruction insn = new SwitchInstruction();
            insn.setCondition(ProgramParser.this.getVariable(ProgramParser.this.popSingle()));
            insn.getEntries().addAll(Arrays.asList(table));
            ProgramParser.this.addInstruction(insn);
            int defaultIndex = (Integer)ProgramParser.this.labelIndexes.get(dflt);
            insn.setDefaultTarget(ProgramParser.this.getBasicBlock(defaultIndex));
            ((ProgramParser)ProgramParser.this).nextIndexes[labels.length] = defaultIndex;
        }

        @Override
        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return null;
        }

        @Override
        public void visitMultiANewArrayInsn(String desc, int dims) {
            ValueType arrayType = this.parseType(desc);
            Variable[] dimensions = new Variable[dims];
            for (int i = dims - 1; i >= 0; --i) {
                dimensions[i] = ProgramParser.this.getVariable(ProgramParser.this.popSingle());
            }
            ConstructMultiArrayInstruction insn = new ConstructMultiArrayInstruction();
            insn.setItemType(arrayType);
            insn.setReceiver(ProgramParser.this.getVariable(ProgramParser.this.pushSingle()));
            insn.getDimensions().addAll(Arrays.asList(dimensions));
            ProgramParser.this.addInstruction(insn);
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            InvokeDynamicInstruction insn = new InvokeDynamicInstruction();
            insn.setBootstrapMethod(ProgramParser.this.parseHandle(bsm));
            switch (insn.getBootstrapMethod().getKind()) {
                case GET_STATIC_FIELD: 
                case PUT_STATIC_FIELD: 
                case INVOKE_STATIC: 
                case INVOKE_CONSTRUCTOR: {
                    break;
                }
                default: {
                    insn.setInstance(ProgramParser.this.getVariable(ProgramParser.this.popSingle()));
                }
            }
            Type[] types = Type.getArgumentTypes(desc);
            Variable[] args = new Variable[types.length];
            int j = args.length;
            for (int i = types.length - 1; i >= 0; --i) {
                args[--j] = types[i].getSize() == 2 ? ProgramParser.this.getVariable(ProgramParser.this.popDouble()) : ProgramParser.this.getVariable(ProgramParser.this.popSingle());
            }
            insn.getArguments().addAll(Arrays.asList(args));
            Type returnType = Type.getReturnType(desc);
            if (returnType.getSize() > 0) {
                insn.setReceiver(ProgramParser.this.getVariable(returnType.getSize() == 2 ? ProgramParser.this.pushDouble() : ProgramParser.this.pushSingle()));
            }
            insn.setMethod(ProgramParser.this.referenceCache.getCached(new MethodDescriptor(name, MethodDescriptor.parseSignature(desc))));
            for (Object bsmArg : bsmArgs) {
                insn.getBootstrapArguments().add(this.convertConstant(bsmArg));
            }
            ProgramParser.this.addInstruction(insn);
        }

        private RuntimeConstant convertConstant(Object value) {
            if (value instanceof Integer) {
                return new RuntimeConstant((Integer)value);
            }
            if (value instanceof Long) {
                return new RuntimeConstant((Long)value);
            }
            if (value instanceof Float) {
                return new RuntimeConstant(((Float)value).floatValue());
            }
            if (value instanceof Double) {
                return new RuntimeConstant((Double)value);
            }
            if (value instanceof String) {
                return new RuntimeConstant((String)value);
            }
            if (value instanceof Type) {
                Type type = (Type)value;
                if (type.getSort() == 11) {
                    return new RuntimeConstant(ProgramParser.this.parseSignature(type.getDescriptor()));
                }
                return new RuntimeConstant(ProgramParser.this.referenceCache.parseValueTypeCached(type.getDescriptor()));
            }
            if (value instanceof Handle) {
                return new RuntimeConstant(ProgramParser.this.parseHandle((Handle)value));
            }
            throw new IllegalArgumentException("Unknown runtime constant: " + value);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            switch (opcode) {
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    String ownerCls;
                    if (owner.startsWith("[")) {
                        if (name.equals("clone") && desc.startsWith("()")) {
                            CloneArrayInstruction insn = new CloneArrayInstruction();
                            insn.setArray(ProgramParser.this.getVariable(ProgramParser.this.popSingle()));
                            insn.setReceiver(ProgramParser.this.getVariable(ProgramParser.this.pushSingle()));
                            ProgramParser.this.addInstruction(insn);
                            break;
                        }
                        ownerCls = "java.lang.Object";
                    } else {
                        ownerCls = owner.replace('/', '.');
                    }
                    Type[] types = Type.getArgumentTypes(desc);
                    Variable[] args = new Variable[types.length];
                    int j = args.length;
                    for (int i = types.length - 1; i >= 0; --i) {
                        args[--j] = types[i].getSize() == 2 ? ProgramParser.this.getVariable(ProgramParser.this.popDouble()) : ProgramParser.this.getVariable(ProgramParser.this.popSingle());
                    }
                    MethodDescriptor method = ProgramParser.this.referenceCache.getCached(new MethodDescriptor(name, MethodDescriptor.parseSignature(desc)));
                    int instance = -1;
                    if (opcode != 184) {
                        instance = ProgramParser.this.popSingle();
                    }
                    Type returnType = Type.getReturnType(desc);
                    int result = -1;
                    if (returnType.getSize() > 0) {
                        int n = result = returnType.getSize() == 2 ? ProgramParser.this.pushDouble() : ProgramParser.this.pushSingle();
                    }
                    if (instance == -1) {
                        InvokeInstruction insn = new InvokeInstruction();
                        insn.setType(InvocationType.SPECIAL);
                        insn.setMethod(ProgramParser.this.referenceCache.getCached(ownerCls, method));
                        if (result >= 0) {
                            insn.setReceiver(ProgramParser.this.getVariable(result));
                        }
                        insn.setArguments(args);
                        ProgramParser.this.addInstruction(insn);
                        break;
                    }
                    InvokeInstruction insn = new InvokeInstruction();
                    if (opcode == 183) {
                        insn.setType(InvocationType.SPECIAL);
                    } else {
                        insn.setType(InvocationType.VIRTUAL);
                    }
                    insn.setMethod(ProgramParser.this.referenceCache.getCached(ownerCls, method));
                    if (result >= 0) {
                        insn.setReceiver(ProgramParser.this.getVariable(result));
                    }
                    insn.setInstance(ProgramParser.this.getVariable(instance));
                    insn.setArguments(args);
                    ProgramParser.this.addInstruction(insn);
                    break;
                }
            }
        }

        @Override
        public void visitMaxs(int maxStack, int maxLocals) {
        }

        @Override
        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            SwitchTableEntry[] table = new SwitchTableEntry[labels.length];
            ProgramParser.access$1002(ProgramParser.this, new int[labels.length + 1]);
            for (int i = 0; i < labels.length; ++i) {
                Label label = labels[i];
                int target = (Integer)ProgramParser.this.labelIndexes.get(label);
                SwitchTableEntry entry = new SwitchTableEntry();
                entry.setCondition(keys[i]);
                entry.setTarget(ProgramParser.this.getBasicBlock(target));
                table[i] = entry;
                ((ProgramParser)ProgramParser.this).nextIndexes[i] = target;
            }
            SwitchInstruction insn = new SwitchInstruction();
            insn.setCondition(ProgramParser.this.getVariable(ProgramParser.this.popSingle()));
            insn.getEntries().addAll(Arrays.asList(table));
            ProgramParser.this.addInstruction(insn);
            int defaultTarget = (Integer)ProgramParser.this.labelIndexes.get(dflt);
            insn.setDefaultTarget(ProgramParser.this.getBasicBlock(defaultTarget));
            ((ProgramParser)ProgramParser.this).nextIndexes[labels.length] = (Integer)ProgramParser.this.labelIndexes.get(dflt);
        }

        @Override
        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        }

        @Override
        public void visitLineNumber(int line, Label start) {
        }

        @Override
        public void visitLdcInsn(Object cst) {
            if (cst instanceof Integer) {
                this.pushConstant((Integer)cst);
            } else if (cst instanceof Float) {
                this.pushConstant(((Float)cst).floatValue());
            } else if (cst instanceof Long) {
                this.pushConstant((Long)cst);
            } else if (cst instanceof Double) {
                this.pushConstant((Double)cst);
            } else if (cst instanceof String) {
                StringConstantInstruction insn = new StringConstantInstruction();
                insn.setConstant(ProgramParser.this.referenceCache.getCached((String)cst));
                insn.setReceiver(ProgramParser.this.getVariable(ProgramParser.this.pushSingle()));
                ProgramParser.this.addInstruction(insn);
            } else if (cst instanceof Type) {
                ClassConstantInstruction insn = new ClassConstantInstruction();
                insn.setConstant(ProgramParser.this.referenceCache.getCached(ValueType.parse(((Type)cst).getDescriptor())));
                insn.setReceiver(ProgramParser.this.getVariable(ProgramParser.this.pushSingle()));
                ProgramParser.this.addInstruction(insn);
            } else {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public void visitLabel(Label label) {
        }

        private void emitBranching(BranchingCondition condition, int value, int target) {
            BranchingInstruction insn = new BranchingInstruction(condition);
            insn.setOperand(ProgramParser.this.getVariable(value));
            insn.setConsequent(ProgramParser.this.getBasicBlock(target));
            insn.setAlternative(ProgramParser.this.getBasicBlock(ProgramParser.this.index + 1));
            ProgramParser.this.addInstruction(insn);
        }

        private void emitBranching(BinaryBranchingCondition condition, int first, int second, int target) {
            BinaryBranchingInstruction insn = new BinaryBranchingInstruction(condition);
            insn.setFirstOperand(ProgramParser.this.getVariable(first));
            insn.setSecondOperand(ProgramParser.this.getVariable(second));
            insn.setConsequent(ProgramParser.this.getBasicBlock(target));
            insn.setAlternative(ProgramParser.this.getBasicBlock(ProgramParser.this.index + 1));
            ProgramParser.this.addInstruction(insn);
        }

        private void emitBinary(BinaryOperation operation, NumericOperandType operandType, int first, int second, int receiver) {
            BinaryInstruction insn = new BinaryInstruction(operation, operandType);
            insn.setFirstOperand(ProgramParser.this.getVariable(first));
            insn.setSecondOperand(ProgramParser.this.getVariable(second));
            insn.setReceiver(ProgramParser.this.getVariable(receiver));
            ProgramParser.this.addInstruction(insn);
        }

        private void emitNeg(NumericOperandType operandType, int operand, int receiver) {
            NegateInstruction insn = new NegateInstruction(operandType);
            insn.setOperand(ProgramParser.this.getVariable(operand));
            insn.setReceiver(ProgramParser.this.getVariable(receiver));
            ProgramParser.this.addInstruction(insn);
        }

        private void emitNumberCast(NumericOperandType source, NumericOperandType target, int value, int result) {
            CastNumberInstruction insn = new CastNumberInstruction(source, target);
            insn.setReceiver(ProgramParser.this.getVariable(result));
            insn.setValue(ProgramParser.this.getVariable(value));
            ProgramParser.this.addInstruction(insn);
        }

        @Override
        public void visitJumpInsn(int opcode, Label label) {
            int target = (Integer)ProgramParser.this.labelIndexes.get(label);
            switch (opcode) {
                case 153: {
                    this.emitBranching(BranchingCondition.EQUAL, ProgramParser.this.popSingle(), target);
                    break;
                }
                case 154: {
                    this.emitBranching(BranchingCondition.NOT_EQUAL, ProgramParser.this.popSingle(), target);
                    break;
                }
                case 198: {
                    this.emitBranching(BranchingCondition.NULL, ProgramParser.this.popSingle(), target);
                    break;
                }
                case 199: {
                    this.emitBranching(BranchingCondition.NOT_NULL, ProgramParser.this.popSingle(), target);
                    break;
                }
                case 157: {
                    this.emitBranching(BranchingCondition.GREATER, ProgramParser.this.popSingle(), target);
                    break;
                }
                case 156: {
                    this.emitBranching(BranchingCondition.GREATER_OR_EQUAL, ProgramParser.this.popSingle(), target);
                    break;
                }
                case 155: {
                    this.emitBranching(BranchingCondition.LESS, ProgramParser.this.popSingle(), target);
                    break;
                }
                case 158: {
                    this.emitBranching(BranchingCondition.LESS_OR_EQUAL, ProgramParser.this.popSingle(), target);
                    break;
                }
                case 165: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    this.emitBranching(BinaryBranchingCondition.REFERENCE_EQUAL, a, b, target);
                    break;
                }
                case 166: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    this.emitBranching(BinaryBranchingCondition.REFERENCE_NOT_EQUAL, a, b, target);
                    break;
                }
                case 159: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    this.emitBinary(BinaryOperation.COMPARE, NumericOperandType.INT, a, b, a);
                    this.emitBranching(BranchingCondition.EQUAL, a, target);
                    break;
                }
                case 160: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    this.emitBinary(BinaryOperation.COMPARE, NumericOperandType.INT, a, b, a);
                    this.emitBranching(BranchingCondition.NOT_EQUAL, a, target);
                    break;
                }
                case 162: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    this.emitBinary(BinaryOperation.COMPARE, NumericOperandType.INT, a, b, a);
                    this.emitBranching(BranchingCondition.GREATER_OR_EQUAL, a, target);
                    break;
                }
                case 163: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    this.emitBinary(BinaryOperation.COMPARE, NumericOperandType.INT, a, b, a);
                    this.emitBranching(BranchingCondition.GREATER, a, target);
                    break;
                }
                case 164: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    this.emitBinary(BinaryOperation.COMPARE, NumericOperandType.INT, a, b, a);
                    this.emitBranching(BranchingCondition.LESS_OR_EQUAL, a, target);
                    break;
                }
                case 161: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    this.emitBinary(BinaryOperation.COMPARE, NumericOperandType.INT, a, b, a);
                    this.emitBranching(BranchingCondition.LESS, a, target);
                    break;
                }
                case 167: {
                    JumpInstruction insn = new JumpInstruction();
                    insn.setTarget(ProgramParser.this.getBasicBlock(target));
                    ProgramParser.this.addInstruction(insn);
                    ProgramParser.access$1002(ProgramParser.this, new int[]{(Integer)ProgramParser.this.labelIndexes.get(label)});
                    return;
                }
                default: {
                    throw new RuntimeException("Unknown opcode");
                }
            }
            ProgramParser.access$1002(ProgramParser.this, new int[]{(Integer)ProgramParser.this.labelIndexes.get(label), ProgramParser.this.index + 1});
        }

        @Override
        public void visitIntInsn(int opcode, int operand) {
            switch (opcode) {
                case 16: 
                case 17: {
                    IntegerConstantInstruction insn = new IntegerConstantInstruction();
                    insn.setConstant(operand);
                    insn.setReceiver(ProgramParser.this.getVariable(ProgramParser.this.pushSingle()));
                    ProgramParser.this.addInstruction(insn);
                    break;
                }
                case 188: {
                    ValueType.Primitive itemType;
                    switch (operand) {
                        case 4: {
                            itemType = ValueType.BOOLEAN;
                            break;
                        }
                        case 8: {
                            itemType = ValueType.BYTE;
                            break;
                        }
                        case 9: {
                            itemType = ValueType.SHORT;
                            break;
                        }
                        case 11: {
                            itemType = ValueType.LONG;
                            break;
                        }
                        case 10: {
                            itemType = ValueType.INTEGER;
                            break;
                        }
                        case 5: {
                            itemType = ValueType.CHARACTER;
                            break;
                        }
                        case 7: {
                            itemType = ValueType.DOUBLE;
                            break;
                        }
                        case 6: {
                            itemType = ValueType.FLOAT;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Illegal opcode");
                        }
                    }
                    ConstructArrayInstruction insn = new ConstructArrayInstruction();
                    insn.setSize(ProgramParser.this.getVariable(ProgramParser.this.popSingle()));
                    insn.setReceiver(ProgramParser.this.getVariable(ProgramParser.this.pushSingle()));
                    insn.setItemType(itemType);
                    ProgramParser.this.addInstruction(insn);
                    break;
                }
            }
        }

        private void pushConstant(int value) {
            IntegerConstantInstruction insn = new IntegerConstantInstruction();
            insn.setConstant(value);
            insn.setReceiver(ProgramParser.this.getVariable(ProgramParser.this.pushSingle()));
            ProgramParser.this.addInstruction(insn);
        }

        private void pushConstant(long value) {
            LongConstantInstruction insn = new LongConstantInstruction();
            insn.setConstant(value);
            insn.setReceiver(ProgramParser.this.getVariable(ProgramParser.this.pushDouble()));
            ProgramParser.this.addInstruction(insn);
        }

        private void pushConstant(double value) {
            DoubleConstantInstruction insn = new DoubleConstantInstruction();
            insn.setConstant(value);
            insn.setReceiver(ProgramParser.this.getVariable(ProgramParser.this.pushDouble()));
            ProgramParser.this.addInstruction(insn);
        }

        private void pushConstant(float value) {
            FloatConstantInstruction insn = new FloatConstantInstruction();
            insn.setConstant(value);
            insn.setReceiver(ProgramParser.this.getVariable(ProgramParser.this.pushSingle()));
            ProgramParser.this.addInstruction(insn);
        }

        private void loadArrayElement(int sz, ArrayElementType type) {
            int arrIndex = ProgramParser.this.popSingle();
            int array = ProgramParser.this.popSingle();
            int var = sz == 1 ? ProgramParser.this.pushSingle() : ProgramParser.this.pushDouble();
            UnwrapArrayInstruction unwrapInsn = new UnwrapArrayInstruction(type);
            unwrapInsn.setArray(ProgramParser.this.getVariable(array));
            unwrapInsn.setReceiver(unwrapInsn.getArray());
            ProgramParser.this.addInstruction(unwrapInsn);
            GetElementInstruction insn = new GetElementInstruction(type);
            insn.setArray(ProgramParser.this.getVariable(array));
            insn.setIndex(ProgramParser.this.getVariable(arrIndex));
            insn.setReceiver(ProgramParser.this.getVariable(var));
            ProgramParser.this.addInstruction(insn);
        }

        private void storeArrayElement(int sz, ArrayElementType type) {
            int value = sz == 1 ? ProgramParser.this.popSingle() : ProgramParser.this.popDouble();
            int arrIndex = ProgramParser.this.popSingle();
            int array = ProgramParser.this.popSingle();
            UnwrapArrayInstruction unwrapInsn = new UnwrapArrayInstruction(type);
            unwrapInsn.setArray(ProgramParser.this.getVariable(array));
            unwrapInsn.setReceiver(unwrapInsn.getArray());
            ProgramParser.this.addInstruction(unwrapInsn);
            PutElementInstruction insn = new PutElementInstruction(type);
            insn.setArray(ProgramParser.this.getVariable(array));
            insn.setIndex(ProgramParser.this.getVariable(arrIndex));
            insn.setValue(ProgramParser.this.getVariable(value));
            ProgramParser.this.addInstruction(insn);
        }

        @Override
        public void visitInsn(int opcode) {
            switch (opcode) {
                case 1: {
                    NullConstantInstruction insn = new NullConstantInstruction();
                    insn.setReceiver(ProgramParser.this.getVariable(ProgramParser.this.pushSingle()));
                    ProgramParser.this.addInstruction(insn);
                    break;
                }
                case 2: {
                    this.pushConstant(-1);
                    break;
                }
                case 3: {
                    this.pushConstant(0);
                    break;
                }
                case 4: {
                    this.pushConstant(1);
                    break;
                }
                case 5: {
                    this.pushConstant(2);
                    break;
                }
                case 6: {
                    this.pushConstant(3);
                    break;
                }
                case 7: {
                    this.pushConstant(4);
                    break;
                }
                case 8: {
                    this.pushConstant(5);
                    break;
                }
                case 9: {
                    this.pushConstant(0L);
                    break;
                }
                case 10: {
                    this.pushConstant(1L);
                    break;
                }
                case 14: {
                    this.pushConstant(0.0);
                    break;
                }
                case 15: {
                    this.pushConstant(1.0);
                    break;
                }
                case 11: {
                    this.pushConstant(0.0f);
                    break;
                }
                case 12: {
                    this.pushConstant(1.0f);
                    break;
                }
                case 13: {
                    this.pushConstant(2.0f);
                    break;
                }
                case 51: {
                    this.loadArrayElement(1, ArrayElementType.BYTE);
                    CastIntegerInstruction insn = new CastIntegerInstruction(IntegerSubtype.BYTE, CastIntegerDirection.TO_INTEGER);
                    insn.setValue(ProgramParser.this.getVariable(ProgramParser.this.popSingle()));
                    insn.setReceiver(ProgramParser.this.getVariable(ProgramParser.this.pushSingle()));
                    ProgramParser.this.addInstruction(insn);
                    break;
                }
                case 46: {
                    this.loadArrayElement(1, ArrayElementType.INT);
                    break;
                }
                case 48: {
                    this.loadArrayElement(1, ArrayElementType.FLOAT);
                    break;
                }
                case 53: {
                    this.loadArrayElement(1, ArrayElementType.SHORT);
                    CastIntegerInstruction insn = new CastIntegerInstruction(IntegerSubtype.SHORT, CastIntegerDirection.TO_INTEGER);
                    insn.setValue(ProgramParser.this.getVariable(ProgramParser.this.popSingle()));
                    insn.setReceiver(ProgramParser.this.getVariable(ProgramParser.this.pushSingle()));
                    ProgramParser.this.addInstruction(insn);
                    break;
                }
                case 52: {
                    this.loadArrayElement(1, ArrayElementType.CHAR);
                    CastIntegerInstruction insn = new CastIntegerInstruction(IntegerSubtype.CHAR, CastIntegerDirection.TO_INTEGER);
                    insn.setValue(ProgramParser.this.getVariable(ProgramParser.this.popSingle()));
                    insn.setReceiver(ProgramParser.this.getVariable(ProgramParser.this.pushSingle()));
                    ProgramParser.this.addInstruction(insn);
                    break;
                }
                case 50: {
                    this.loadArrayElement(1, ArrayElementType.OBJECT);
                    break;
                }
                case 49: {
                    this.loadArrayElement(2, ArrayElementType.DOUBLE);
                    break;
                }
                case 47: {
                    this.loadArrayElement(2, ArrayElementType.LONG);
                    break;
                }
                case 84: {
                    this.storeArrayElement(1, ArrayElementType.BYTE);
                    break;
                }
                case 79: {
                    this.storeArrayElement(1, ArrayElementType.INT);
                    break;
                }
                case 81: {
                    this.storeArrayElement(1, ArrayElementType.FLOAT);
                    break;
                }
                case 86: {
                    this.storeArrayElement(1, ArrayElementType.SHORT);
                    break;
                }
                case 85: {
                    this.storeArrayElement(1, ArrayElementType.CHAR);
                    break;
                }
                case 83: {
                    this.storeArrayElement(1, ArrayElementType.OBJECT);
                    break;
                }
                case 82: {
                    this.storeArrayElement(2, ArrayElementType.DOUBLE);
                    break;
                }
                case 80: {
                    this.storeArrayElement(2, ArrayElementType.LONG);
                    break;
                }
                case 87: {
                    ProgramParser.this.popSingle();
                    break;
                }
                case 88: {
                    if (((ProgramParser)ProgramParser.this).stack.type == 1) {
                        ProgramParser.this.popSingle();
                        ProgramParser.this.popSingle();
                        break;
                    }
                    ProgramParser.this.popDouble();
                    break;
                }
                case 89: {
                    ProgramParser.this.popSingle();
                    int orig = ProgramParser.this.pushSingle();
                    int copy = ProgramParser.this.pushSingle();
                    ProgramParser.this.emitAssignInsn(orig, copy);
                    break;
                }
                case 90: {
                    ProgramParser.this.popSingle();
                    ProgramParser.this.popSingle();
                    int ins = ProgramParser.this.pushSingle();
                    int b = ProgramParser.this.pushSingle();
                    int a = ProgramParser.this.pushSingle();
                    ProgramParser.this.emitAssignInsn(a - 1, a);
                    ProgramParser.this.emitAssignInsn(b - 1, b);
                    ProgramParser.this.emitAssignInsn(a, ins);
                    break;
                }
                case 91: {
                    ProgramParser.this.popSingle();
                    if (((ProgramParser)ProgramParser.this).stack.type == 1) {
                        ProgramParser.this.popSingle();
                        ProgramParser.this.popSingle();
                        int ins = ProgramParser.this.pushSingle();
                        int c = ProgramParser.this.pushSingle();
                        int b = ProgramParser.this.pushSingle();
                        int a = ProgramParser.this.pushSingle();
                        ProgramParser.this.emitAssignInsn(a - 1, a);
                        ProgramParser.this.emitAssignInsn(b - 1, b);
                        ProgramParser.this.emitAssignInsn(c - 1, c);
                        ProgramParser.this.emitAssignInsn(a, ins);
                        break;
                    }
                    ProgramParser.this.popDouble();
                    int ins = ProgramParser.this.pushSingle();
                    int b = ProgramParser.this.pushDouble();
                    int a = ProgramParser.this.pushSingle();
                    ProgramParser.this.emitAssignInsn(a - 1, a);
                    ProgramParser.this.emitAssignInsn(b - 1, b);
                    ProgramParser.this.emitAssignInsn(a, ins);
                    break;
                }
                case 92: {
                    if (((ProgramParser)ProgramParser.this).stack.type == 1) {
                        ProgramParser.this.popSingle();
                        ProgramParser.this.popSingle();
                        int origA = ProgramParser.this.pushSingle();
                        int origB = ProgramParser.this.pushSingle();
                        int copyA = ProgramParser.this.pushSingle();
                        int copyB = ProgramParser.this.pushSingle();
                        ProgramParser.this.emitAssignInsn(origA, copyA);
                        ProgramParser.this.emitAssignInsn(origB, copyB);
                        break;
                    }
                    ProgramParser.this.popDouble();
                    int orig = ProgramParser.this.pushDouble();
                    int copy = ProgramParser.this.pushDouble();
                    ProgramParser.this.emitAssignInsn(orig, copy);
                    break;
                }
                case 93: {
                    if (((ProgramParser)ProgramParser.this).stack.type == 1) {
                        ProgramParser.this.popSingle();
                        ProgramParser.this.popSingle();
                        ProgramParser.this.popSingle();
                        int ins1 = ProgramParser.this.pushSingle();
                        int ins2 = ProgramParser.this.pushSingle();
                        int b = ProgramParser.this.pushSingle();
                        int a1 = ProgramParser.this.pushSingle();
                        int a2 = ProgramParser.this.pushSingle();
                        ProgramParser.this.emitAssignInsn(a2 - 2, a2);
                        ProgramParser.this.emitAssignInsn(a1 - 2, a1);
                        ProgramParser.this.emitAssignInsn(b - 2, b);
                        ProgramParser.this.emitAssignInsn(a1, ins1);
                        ProgramParser.this.emitAssignInsn(a2, ins2);
                        break;
                    }
                    ProgramParser.this.popDouble();
                    ProgramParser.this.popSingle();
                    int ins = ProgramParser.this.pushDouble();
                    int b = ProgramParser.this.pushSingle();
                    int a = ProgramParser.this.pushDouble();
                    ProgramParser.this.emitAssignInsn(a - 2, a);
                    ProgramParser.this.emitAssignInsn(b - 2, b);
                    ProgramParser.this.emitAssignInsn(a, ins);
                    break;
                }
                case 94: {
                    if (((ProgramParser)ProgramParser.this).stack.type == 1) {
                        ProgramParser.this.popSingle();
                        ProgramParser.this.popSingle();
                        if (((ProgramParser)ProgramParser.this).stack.type == 1) {
                            ProgramParser.this.popSingle();
                            ProgramParser.this.popSingle();
                            int ins1 = ProgramParser.this.pushSingle();
                            int ins2 = ProgramParser.this.pushSingle();
                            int c = ProgramParser.this.pushSingle();
                            int b = ProgramParser.this.pushSingle();
                            int a1 = ProgramParser.this.pushSingle();
                            int a2 = ProgramParser.this.pushSingle();
                            ProgramParser.this.emitAssignInsn(a2 - 2, a2);
                            ProgramParser.this.emitAssignInsn(a1 - 2, a1);
                            ProgramParser.this.emitAssignInsn(b - 2, b);
                            ProgramParser.this.emitAssignInsn(c - 2, c);
                            ProgramParser.this.emitAssignInsn(a1, ins1);
                            ProgramParser.this.emitAssignInsn(a2, ins2);
                            break;
                        }
                        ProgramParser.this.popDouble();
                        int ins1 = ProgramParser.this.pushSingle();
                        int ins2 = ProgramParser.this.pushSingle();
                        int b = ProgramParser.this.pushDouble();
                        int a1 = ProgramParser.this.pushSingle();
                        int a2 = ProgramParser.this.pushSingle();
                        ProgramParser.this.emitAssignInsn(a2 - 2, a2);
                        ProgramParser.this.emitAssignInsn(a1 - 2, a1);
                        ProgramParser.this.emitAssignInsn(b - 2, b);
                        ProgramParser.this.emitAssignInsn(a1, ins1);
                        ProgramParser.this.emitAssignInsn(a2, ins2);
                        break;
                    }
                    ProgramParser.this.popDouble();
                    if (((ProgramParser)ProgramParser.this).stack.type == 1) {
                        ProgramParser.this.popSingle();
                        ProgramParser.this.popSingle();
                        int ins = ProgramParser.this.pushDouble();
                        int c = ProgramParser.this.pushSingle();
                        int b = ProgramParser.this.pushSingle();
                        int a = ProgramParser.this.pushDouble();
                        ProgramParser.this.emitAssignInsn(a - 2, a);
                        ProgramParser.this.emitAssignInsn(b - 2, b);
                        ProgramParser.this.emitAssignInsn(c - 2, c);
                        ProgramParser.this.emitAssignInsn(a, ins);
                        break;
                    }
                    ProgramParser.this.popDouble();
                    int ins = ProgramParser.this.pushDouble();
                    int b = ProgramParser.this.pushDouble();
                    int a = ProgramParser.this.pushDouble();
                    ProgramParser.this.emitAssignInsn(a - 2, a);
                    ProgramParser.this.emitAssignInsn(b - 2, b);
                    ProgramParser.this.emitAssignInsn(a, ins);
                    break;
                }
                case 95: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    ProgramParser.this.pushSingle();
                    ProgramParser.this.pushSingle();
                    int tmp = b + 1;
                    ProgramParser.this.emitAssignInsn(a, tmp);
                    ProgramParser.this.emitAssignInsn(b, a);
                    ProgramParser.this.emitAssignInsn(tmp, b);
                    break;
                }
                case 100: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushSingle();
                    this.emitBinary(BinaryOperation.SUBTRACT, NumericOperandType.INT, a, b, r);
                    break;
                }
                case 102: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushSingle();
                    this.emitBinary(BinaryOperation.SUBTRACT, NumericOperandType.FLOAT, a, b, r);
                    break;
                }
                case 96: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushSingle();
                    this.emitBinary(BinaryOperation.ADD, NumericOperandType.INT, a, b, r);
                    break;
                }
                case 98: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushSingle();
                    this.emitBinary(BinaryOperation.ADD, NumericOperandType.FLOAT, a, b, r);
                    break;
                }
                case 104: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushSingle();
                    this.emitBinary(BinaryOperation.MULTIPLY, NumericOperandType.INT, a, b, r);
                    break;
                }
                case 106: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushSingle();
                    this.emitBinary(BinaryOperation.MULTIPLY, NumericOperandType.FLOAT, a, b, r);
                    break;
                }
                case 108: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushSingle();
                    this.emitBinary(BinaryOperation.DIVIDE, NumericOperandType.INT, a, b, r);
                    break;
                }
                case 110: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushSingle();
                    this.emitBinary(BinaryOperation.DIVIDE, NumericOperandType.FLOAT, a, b, r);
                    break;
                }
                case 112: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushSingle();
                    this.emitBinary(BinaryOperation.MODULO, NumericOperandType.INT, a, b, r);
                    break;
                }
                case 114: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushSingle();
                    this.emitBinary(BinaryOperation.MODULO, NumericOperandType.FLOAT, a, b, r);
                    break;
                }
                case 97: {
                    int b = ProgramParser.this.popDouble();
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushDouble();
                    this.emitBinary(BinaryOperation.ADD, NumericOperandType.LONG, a, b, r);
                    break;
                }
                case 99: {
                    int b = ProgramParser.this.popDouble();
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushDouble();
                    this.emitBinary(BinaryOperation.ADD, NumericOperandType.DOUBLE, a, b, r);
                    break;
                }
                case 101: {
                    int b = ProgramParser.this.popDouble();
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushDouble();
                    this.emitBinary(BinaryOperation.SUBTRACT, NumericOperandType.LONG, a, b, r);
                    break;
                }
                case 103: {
                    int b = ProgramParser.this.popDouble();
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushDouble();
                    this.emitBinary(BinaryOperation.SUBTRACT, NumericOperandType.DOUBLE, a, b, r);
                    break;
                }
                case 105: {
                    int b = ProgramParser.this.popDouble();
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushDouble();
                    this.emitBinary(BinaryOperation.MULTIPLY, NumericOperandType.LONG, a, b, r);
                    break;
                }
                case 107: {
                    int b = ProgramParser.this.popDouble();
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushDouble();
                    this.emitBinary(BinaryOperation.MULTIPLY, NumericOperandType.DOUBLE, a, b, r);
                    break;
                }
                case 111: {
                    int b = ProgramParser.this.popDouble();
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushDouble();
                    this.emitBinary(BinaryOperation.DIVIDE, NumericOperandType.DOUBLE, a, b, r);
                    break;
                }
                case 109: {
                    int b = ProgramParser.this.popDouble();
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushDouble();
                    this.emitBinary(BinaryOperation.DIVIDE, NumericOperandType.LONG, a, b, r);
                    break;
                }
                case 113: {
                    int b = ProgramParser.this.popDouble();
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushDouble();
                    this.emitBinary(BinaryOperation.MODULO, NumericOperandType.LONG, a, b, r);
                    break;
                }
                case 115: {
                    int b = ProgramParser.this.popDouble();
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushDouble();
                    this.emitBinary(BinaryOperation.MODULO, NumericOperandType.DOUBLE, a, b, r);
                    break;
                }
                case 116: {
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushSingle();
                    this.emitNeg(NumericOperandType.INT, a, r);
                    break;
                }
                case 118: {
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushSingle();
                    this.emitNeg(NumericOperandType.FLOAT, a, r);
                    break;
                }
                case 117: {
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushDouble();
                    this.emitNeg(NumericOperandType.LONG, a, r);
                    break;
                }
                case 119: {
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushDouble();
                    this.emitNeg(NumericOperandType.DOUBLE, a, r);
                    break;
                }
                case 149: 
                case 150: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushSingle();
                    this.emitBinary(BinaryOperation.COMPARE, NumericOperandType.FLOAT, a, b, r);
                    break;
                }
                case 148: {
                    int b = ProgramParser.this.popDouble();
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushSingle();
                    this.emitBinary(BinaryOperation.COMPARE, NumericOperandType.LONG, a, b, r);
                    break;
                }
                case 151: 
                case 152: {
                    int b = ProgramParser.this.popDouble();
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushSingle();
                    this.emitBinary(BinaryOperation.COMPARE, NumericOperandType.DOUBLE, a, b, r);
                    break;
                }
                case 120: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushSingle();
                    this.emitBinary(BinaryOperation.SHIFT_LEFT, NumericOperandType.INT, a, b, r);
                    break;
                }
                case 122: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushSingle();
                    this.emitBinary(BinaryOperation.SHIFT_RIGHT, NumericOperandType.INT, a, b, r);
                    break;
                }
                case 124: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushSingle();
                    this.emitBinary(BinaryOperation.SHIFT_RIGHT_UNSIGNED, NumericOperandType.INT, a, b, r);
                    break;
                }
                case 121: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushDouble();
                    this.emitBinary(BinaryOperation.SHIFT_LEFT, NumericOperandType.LONG, a, b, r);
                    break;
                }
                case 123: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushDouble();
                    this.emitBinary(BinaryOperation.SHIFT_RIGHT, NumericOperandType.LONG, a, b, r);
                    break;
                }
                case 125: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushDouble();
                    this.emitBinary(BinaryOperation.SHIFT_RIGHT_UNSIGNED, NumericOperandType.LONG, a, b, r);
                    break;
                }
                case 126: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushSingle();
                    this.emitBinary(BinaryOperation.AND, NumericOperandType.INT, a, b, r);
                    break;
                }
                case 128: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushSingle();
                    this.emitBinary(BinaryOperation.OR, NumericOperandType.INT, a, b, r);
                    break;
                }
                case 130: {
                    int b = ProgramParser.this.popSingle();
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushSingle();
                    this.emitBinary(BinaryOperation.XOR, NumericOperandType.INT, a, b, r);
                    break;
                }
                case 127: {
                    int b = ProgramParser.this.popDouble();
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushDouble();
                    this.emitBinary(BinaryOperation.AND, NumericOperandType.LONG, a, b, r);
                    break;
                }
                case 129: {
                    int b = ProgramParser.this.popDouble();
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushDouble();
                    this.emitBinary(BinaryOperation.OR, NumericOperandType.LONG, a, b, r);
                    break;
                }
                case 131: {
                    int b = ProgramParser.this.popDouble();
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushDouble();
                    this.emitBinary(BinaryOperation.XOR, NumericOperandType.LONG, a, b, r);
                    break;
                }
                case 145: {
                    CastIntegerInstruction insn = new CastIntegerInstruction(IntegerSubtype.BYTE, CastIntegerDirection.FROM_INTEGER);
                    insn.setValue(ProgramParser.this.getVariable(ProgramParser.this.popSingle()));
                    insn.setReceiver(ProgramParser.this.getVariable(ProgramParser.this.pushSingle()));
                    ProgramParser.this.addInstruction(insn);
                    break;
                }
                case 146: {
                    CastIntegerInstruction insn = new CastIntegerInstruction(IntegerSubtype.CHAR, CastIntegerDirection.FROM_INTEGER);
                    insn.setValue(ProgramParser.this.getVariable(ProgramParser.this.popSingle()));
                    insn.setReceiver(ProgramParser.this.getVariable(ProgramParser.this.pushSingle()));
                    ProgramParser.this.addInstruction(insn);
                    break;
                }
                case 147: {
                    CastIntegerInstruction insn = new CastIntegerInstruction(IntegerSubtype.SHORT, CastIntegerDirection.FROM_INTEGER);
                    insn.setValue(ProgramParser.this.getVariable(ProgramParser.this.popSingle()));
                    insn.setReceiver(ProgramParser.this.getVariable(ProgramParser.this.pushSingle()));
                    ProgramParser.this.addInstruction(insn);
                    break;
                }
                case 134: {
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushSingle();
                    this.emitNumberCast(NumericOperandType.INT, NumericOperandType.FLOAT, a, r);
                    break;
                }
                case 133: {
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushDouble();
                    this.emitNumberCast(NumericOperandType.INT, NumericOperandType.LONG, a, r);
                    break;
                }
                case 135: {
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushDouble();
                    this.emitNumberCast(NumericOperandType.INT, NumericOperandType.DOUBLE, a, r);
                    break;
                }
                case 139: {
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushSingle();
                    this.emitNumberCast(NumericOperandType.FLOAT, NumericOperandType.INT, a, r);
                    break;
                }
                case 140: {
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushDouble();
                    this.emitNumberCast(NumericOperandType.FLOAT, NumericOperandType.LONG, a, r);
                    break;
                }
                case 141: {
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushDouble();
                    this.emitNumberCast(NumericOperandType.FLOAT, NumericOperandType.DOUBLE, a, r);
                    break;
                }
                case 143: {
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushDouble();
                    this.emitNumberCast(NumericOperandType.DOUBLE, NumericOperandType.LONG, a, r);
                    break;
                }
                case 142: {
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushSingle();
                    this.emitNumberCast(NumericOperandType.DOUBLE, NumericOperandType.INT, a, r);
                    break;
                }
                case 144: {
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushSingle();
                    this.emitNumberCast(NumericOperandType.DOUBLE, NumericOperandType.FLOAT, a, r);
                    break;
                }
                case 136: {
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushSingle();
                    this.emitNumberCast(NumericOperandType.LONG, NumericOperandType.INT, a, r);
                    break;
                }
                case 137: {
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushSingle();
                    this.emitNumberCast(NumericOperandType.LONG, NumericOperandType.FLOAT, a, r);
                    break;
                }
                case 138: {
                    int a = ProgramParser.this.popDouble();
                    int r = ProgramParser.this.pushDouble();
                    this.emitNumberCast(NumericOperandType.LONG, NumericOperandType.DOUBLE, a, r);
                    break;
                }
                case 172: 
                case 174: 
                case 176: {
                    ExitInstruction insn = new ExitInstruction();
                    insn.setValueToReturn(ProgramParser.this.getVariable(ProgramParser.this.popSingle()));
                    ProgramParser.this.addInstruction(insn);
                    ProgramParser.access$1002(ProgramParser.this, new int[0]);
                    return;
                }
                case 173: 
                case 175: {
                    ExitInstruction insn = new ExitInstruction();
                    insn.setValueToReturn(ProgramParser.this.getVariable(ProgramParser.this.popDouble()));
                    ProgramParser.this.addInstruction(insn);
                    ProgramParser.access$1002(ProgramParser.this, new int[0]);
                    return;
                }
                case 177: {
                    ExitInstruction insn = new ExitInstruction();
                    ProgramParser.this.addInstruction(insn);
                    ProgramParser.access$1002(ProgramParser.this, new int[0]);
                    return;
                }
                case 190: {
                    int a = ProgramParser.this.popSingle();
                    int r = ProgramParser.this.pushSingle();
                    UnwrapArrayInstruction unwrapInsn = new UnwrapArrayInstruction(ArrayElementType.OBJECT);
                    unwrapInsn.setArray(ProgramParser.this.getVariable(a));
                    unwrapInsn.setReceiver(ProgramParser.this.getVariable(r));
                    ProgramParser.this.addInstruction(unwrapInsn);
                    ArrayLengthInstruction insn = new ArrayLengthInstruction();
                    insn.setArray(ProgramParser.this.getVariable(a));
                    insn.setReceiver(ProgramParser.this.getVariable(r));
                    ProgramParser.this.addInstruction(insn);
                    break;
                }
                case 191: {
                    RaiseInstruction insn = new RaiseInstruction();
                    insn.setException(ProgramParser.this.getVariable(ProgramParser.this.popSingle()));
                    ProgramParser.this.addInstruction(insn);
                    ProgramParser.access$1002(ProgramParser.this, new int[0]);
                    return;
                }
                case 194: {
                    MonitorEnterInstruction insn = new MonitorEnterInstruction();
                    insn.setObjectRef(ProgramParser.this.getVariable(ProgramParser.this.popSingle()));
                    ProgramParser.this.addInstruction(insn);
                    break;
                }
                case 195: {
                    MonitorExitInstruction insn = new MonitorExitInstruction();
                    insn.setObjectRef(ProgramParser.this.getVariable(ProgramParser.this.popSingle()));
                    ProgramParser.this.addInstruction(insn);
                    break;
                }
            }
        }

        @Override
        public void visitIincInsn(int var, int increment) {
            var = ProgramParser.this.minLocal + ProgramParser.this.mapLocal(var);
            int tmp = ProgramParser.this.pushSingle();
            ProgramParser.this.popSingle();
            IntegerConstantInstruction intInsn = new IntegerConstantInstruction();
            intInsn.setConstant(increment);
            intInsn.setReceiver(ProgramParser.this.getVariable(tmp));
            ProgramParser.this.addInstruction(intInsn);
            this.emitBinary(BinaryOperation.ADD, NumericOperandType.INT, var, tmp, var);
        }

        @Override
        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            String ownerCls = owner.replace('/', '.');
            switch (opcode) {
                case 180: {
                    int instance = ProgramParser.this.popSingle();
                    ValueType type = ProgramParser.this.referenceCache.parseValueTypeCached(desc);
                    int value = desc.equals("D") || desc.equals("J") ? ProgramParser.this.pushDouble() : ProgramParser.this.pushSingle();
                    GetFieldInstruction insn = new GetFieldInstruction();
                    insn.setInstance(ProgramParser.this.getVariable(instance));
                    insn.setField(ProgramParser.this.referenceCache.getCached(new FieldReference(ownerCls, name)));
                    insn.setFieldType(type);
                    insn.setReceiver(ProgramParser.this.getVariable(value));
                    ProgramParser.this.addInstruction(insn);
                    break;
                }
                case 181: {
                    int value = desc.equals("D") || desc.equals("J") ? ProgramParser.this.popDouble() : ProgramParser.this.popSingle();
                    int instance = ProgramParser.this.popSingle();
                    PutFieldInstruction insn = new PutFieldInstruction();
                    insn.setInstance(ProgramParser.this.getVariable(instance));
                    insn.setField(ProgramParser.this.referenceCache.getCached(new FieldReference(ownerCls, name)));
                    insn.setValue(ProgramParser.this.getVariable(value));
                    insn.setFieldType(ProgramParser.this.referenceCache.parseValueTypeCached(desc));
                    ProgramParser.this.addInstruction(insn);
                    break;
                }
                case 178: {
                    ValueType primitiveClassLiteral = ProgramParser.getPrimitiveTypeField(owner + "." + name);
                    if (primitiveClassLiteral != null) {
                        ClassConstantInstruction insn = new ClassConstantInstruction();
                        insn.setConstant(primitiveClassLiteral);
                        insn.setReceiver(ProgramParser.this.getVariable(ProgramParser.this.pushSingle()));
                        ProgramParser.this.addInstruction(insn);
                        break;
                    }
                    ValueType type = ProgramParser.this.referenceCache.parseValueTypeCached(desc);
                    int value = desc.equals("D") || desc.equals("J") ? ProgramParser.this.pushDouble() : ProgramParser.this.pushSingle();
                    GetFieldInstruction insn = new GetFieldInstruction();
                    insn.setField(ProgramParser.this.referenceCache.getCached(new FieldReference(ownerCls, name)));
                    insn.setFieldType(type);
                    insn.setReceiver(ProgramParser.this.getVariable(value));
                    ProgramParser.this.addInstruction(insn);
                    break;
                }
                case 179: {
                    int value = desc.equals("D") || desc.equals("J") ? ProgramParser.this.popDouble() : ProgramParser.this.popSingle();
                    PutFieldInstruction insn = new PutFieldInstruction();
                    insn.setField(ProgramParser.this.referenceCache.getCached(new FieldReference(ownerCls, name)));
                    insn.setValue(ProgramParser.this.getVariable(value));
                    insn.setFieldType(ProgramParser.this.referenceCache.parseValueTypeCached(desc));
                    ProgramParser.this.addInstruction(insn);
                    break;
                }
            }
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void visitCode() {
        }

        @Override
        public void visitAttribute(Attribute attr) {
        }

        @Override
        public AnnotationVisitor visitAnnotationDefault() {
            return null;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return null;
        }
    };

    public ProgramParser(ReferenceCache methodReferenceCache) {
        this.referenceCache = methodReferenceCache;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Program parse(MethodNode method) {
        this.program = new Program();
        InsnList instructions = method.instructions;
        if (instructions.size() == 0) {
            return this.program;
        }
        this.prepare(method);
        this.program.createBasicBlock();
        this.getBasicBlock(0);
        JumpInstruction insn = new JumpInstruction();
        insn.setTarget(this.program.basicBlockAt(1));
        this.program.basicBlockAt(0).add(insn);
        this.doAnalyze(method);
        this.assemble(method);
        for (int i = 0; i < this.program.basicBlockCount(); ++i) {
            BasicBlock block = this.program.basicBlockAt(i);
            for (int j = 0; j < block.getTryCatchBlocks().size(); ++j) {
                TryCatchBlock tryCatch = block.getTryCatchBlocks().get(j);
                if (tryCatch.getHandler() != block) continue;
                block.getTryCatchBlocks().remove(j--);
            }
        }
        int signatureVars = this.countSignatureVariables(method.desc);
        while (this.program.variableCount() <= signatureVars) {
            this.program.createVariable();
        }
        return this.program;
    }

    private int countSignatureVariables(String desc) {
        int count = 1;
        for (Type paramType : Type.getArgumentTypes(desc)) {
            count += paramType.getSize();
        }
        return count;
    }

    private int pushSingle() {
        this.stack = new StackFrame(this.stack, 1);
        return this.stack.depth;
    }

    private int pushDouble() {
        this.stack = new StackFrame(this.stack, 2);
        this.stack = new StackFrame(this.stack, 3);
        return this.stack.next.depth;
    }

    private int popSingle() {
        if (this.stack == null || this.stack.type != 1) {
            throw new AssertionError((Object)("Illegal stack state at " + this.index));
        }
        int depth = this.stack.depth;
        this.stack = this.stack.next;
        return depth;
    }

    private int popDouble() {
        if (this.stack == null || this.stack.type != 3) {
            throw new AssertionError((Object)("***Illegal stack state at " + this.index));
        }
        this.stack = this.stack.next;
        if (this.stack == null || this.stack.type != 2) {
            throw new AssertionError((Object)("***Illegal stack state at " + this.index));
        }
        int depth = this.stack.depth;
        this.stack = this.stack.next;
        return depth;
    }

    public Map<Integer, String> getDebugNames(Instruction insn) {
        Map<Integer, String> map = this.variableDebugNames.get(insn);
        return map != null ? Collections.unmodifiableMap(map) : Collections.emptyMap();
    }

    private void prepare(MethodNode method) {
        InsnList instructions = method.instructions;
        this.minLocal = 0;
        if ((method.access & 8) != 0) {
            this.minLocal = 1;
        }
        this.labelIndexes = new HashMap<Label, Integer>();
        this.lineNumbers = new HashMap<Label, Integer>();
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractInsnNode node = instructions.get(i);
            if (node instanceof LabelNode) {
                this.labelIndexes.put(((LabelNode)node).getLabel(), i);
            }
            if (!(node instanceof LineNumberNode)) continue;
            LineNumberNode lineNumberNode = (LineNumberNode)node;
            this.lineNumbers.put(lineNumberNode.start.getLabel(), lineNumberNode.line);
        }
        for (LocalVariableNode localVar : method.localVariables) {
            int location = this.labelIndexes.get(localVar.start.getLabel());
            this.localVariableMap.computeIfAbsent(location, k -> new ArrayList()).add(localVar);
        }
        this.targetInstructions = new ArrayList<List<Instruction>>(instructions.size());
        this.targetInstructions.addAll(Collections.nCopies(instructions.size(), null));
        this.basicBlocks.addAll(Collections.nCopies(instructions.size(), null));
        this.stackBefore = new StackFrame[instructions.size()];
        this.stackAfter = new StackFrame[instructions.size()];
    }

    private void doAnalyze(MethodNode method) {
        InsnList instructions = method.instructions;
        ArrayDeque<Step> workStack = new ArrayDeque<Step>();
        Iterator<TryCatchBlockNode> iterator = method.tryCatchBlocks.iterator();
        while (iterator.hasNext()) {
            TryCatchBlockNode tryCatchBlockNode;
            TryCatchBlockNode tryCatchNode = tryCatchBlockNode = iterator.next();
            if (tryCatchNode.start == tryCatchNode.handler) continue;
            workStack.push(new Step(-2, this.labelIndexes.get(tryCatchNode.handler.getLabel())));
        }
        workStack.push(new Step(-1, 0));
        while (!workStack.isEmpty()) {
            Step step = (Step)workStack.pop();
            this.index = step.target;
            if (this.stackBefore[this.index] != null) continue;
            switch (step.source) {
                case -1: {
                    this.stack = new StackFrame(this.minLocal + method.maxLocals - 1);
                    break;
                }
                case -2: {
                    this.stack = new StackFrame(this.minLocal + method.maxLocals - 1);
                    this.pushSingle();
                    break;
                }
                default: {
                    this.stack = this.stackAfter[step.source];
                }
            }
            this.stackBefore[this.index] = this.stack;
            this.nextIndexes = new int[]{this.index + 1};
            instructions.get(this.index).accept(this.methodVisitor);
            this.stackAfter[this.index] = this.stack;
            this.flushInstructions();
            if (this.nextIndexes.length != 1) {
                this.emitNextBasicBlock();
            }
            for (int next : this.nextIndexes) {
                workStack.push(new Step(this.index, next));
            }
        }
        iterator = method.tryCatchBlocks.iterator();
        while (iterator.hasNext()) {
            TryCatchBlockNode tryCatchBlockNode;
            TryCatchBlockNode tryCatchNode = tryCatchBlockNode = iterator.next();
            if (tryCatchNode.start == tryCatchNode.handler) continue;
            int start = this.labelIndexes.get(tryCatchNode.start.getLabel());
            int end = this.labelIndexes.get(tryCatchNode.end.getLabel());
            this.getBasicBlock(start);
            this.getBasicBlock(end);
            for (int i = start; i < end; ++i) {
                BasicBlock block = this.basicBlocks.get(i);
                if (block == null) continue;
                TryCatchBlock tryCatch = new TryCatchBlock();
                if (tryCatchNode.type != null) {
                    tryCatch.setExceptionType(this.referenceCache.getCached(tryCatchNode.type.replace('/', '.')));
                }
                tryCatch.setHandler(this.getBasicBlock(this.labelIndexes.get(tryCatchNode.handler.getLabel())));
                tryCatch.getHandler().setExceptionVariable(this.program.variableAt(this.minLocal + method.maxLocals));
                block.getTryCatchBlocks().add(tryCatch);
            }
        }
    }

    private void assemble(MethodNode methodNode) {
        BasicBlock basicBlock = null;
        HashMap accumulatedDebugNames = new HashMap();
        Integer lastLineNumber = null;
        TextLocation lastLocation = TextLocation.EMPTY;
        for (int i = 0; i < this.basicBlocks.size(); ++i) {
            Label label;
            Integer lineNumber;
            AbstractInsnNode insnNode;
            BasicBlock newBasicBlock = this.basicBlocks.get(i);
            if (newBasicBlock != null) {
                if (basicBlock != null && !this.hasProperLastInstruction(basicBlock)) {
                    JumpInstruction insn = new JumpInstruction();
                    insn.setTarget(newBasicBlock);
                    basicBlock.add(insn);
                }
                if ((basicBlock = newBasicBlock).instructionCount() > 0) {
                    HashMap debugNames = new HashMap(accumulatedDebugNames);
                    this.variableDebugNames.put(basicBlock.getFirstInstruction(), debugNames);
                }
            }
            List<Instruction> builtInstructions = this.targetInstructions.get(i);
            List<LocalVariableNode> localVarNodes = this.localVariableMap.get(i);
            if (localVarNodes != null) {
                if (builtInstructions == null || builtInstructions.isEmpty()) {
                    builtInstructions = Arrays.asList(new EmptyInstruction());
                }
                HashMap<Integer, String> debugNames = new HashMap<Integer, String>();
                this.variableDebugNames.put(builtInstructions.get(0), debugNames);
                for (LocalVariableNode localVar : localVarNodes) {
                    debugNames.put(localVar.index + this.minLocal, this.referenceCache.getCached(localVar.name));
                }
                accumulatedDebugNames.putAll(debugNames);
            }
            if ((insnNode = methodNode.instructions.get(i)) instanceof LabelNode && (lineNumber = this.lineNumbers.get(label = ((LabelNode)insnNode).getLabel())) != null && !lineNumber.equals(lastLineNumber)) {
                lastLineNumber = lineNumber;
                lastLocation = new TextLocation(this.fileName, lastLineNumber);
            }
            if (builtInstructions == null) continue;
            for (Instruction insn : builtInstructions) {
                insn.setLocation(lastLocation);
            }
            basicBlock.addAll(builtInstructions);
        }
    }

    private boolean hasProperLastInstruction(BasicBlock basicBlock) {
        Instruction lastInsn = basicBlock.getLastInstruction();
        if (lastInsn == null) {
            return false;
        }
        TransitionExtractor extractor = new TransitionExtractor();
        lastInsn.acceptVisitor(extractor);
        return extractor.getTargets() != null;
    }

    private void flushInstructions() {
        this.targetInstructions.set(this.index, this.builder);
        this.builder = new ArrayList<Instruction>();
    }

    private BasicBlock getBasicBlock(int index) {
        BasicBlock block = this.basicBlocks.get(index);
        if (block == null) {
            block = this.program.createBasicBlock();
            this.basicBlocks.set(index, block);
        }
        return block;
    }

    private void emitNextBasicBlock() {
        if (this.index + 1 < this.basicBlocks.size()) {
            this.getBasicBlock(this.index + 1);
        }
    }

    private Variable getVariable(int index) {
        while (index >= this.program.variableCount()) {
            this.program.createVariable();
        }
        return this.program.variableAt(index);
    }

    private void emitAssignInsn(int source, int target) {
        AssignInstruction insn = new AssignInstruction();
        insn.setAssignee(this.getVariable(source));
        insn.setReceiver(this.getVariable(target));
        this.addInstruction(insn);
    }

    private void addInstruction(Instruction insn) {
        this.builder.add(insn);
    }

    private int mapLocal(int local) {
        return local;
    }

    private MethodHandle parseHandle(Handle handle) {
        String owner = this.referenceCache.getCached(handle.getOwner().replace('/', '.'));
        String name = this.referenceCache.getCached(handle.getName());
        switch (handle.getTag()) {
            case 1: {
                return MethodHandle.fieldGetter(owner, name, this.referenceCache.getCached(ValueType.parse(handle.getDesc())));
            }
            case 2: {
                return MethodHandle.staticFieldGetter(owner, name, this.referenceCache.getCached(ValueType.parse(handle.getDesc())));
            }
            case 3: {
                return MethodHandle.fieldSetter(owner, name, this.referenceCache.getCached(ValueType.parse(handle.getDesc())));
            }
            case 4: {
                return MethodHandle.staticFieldSetter(owner, name, this.referenceCache.getCached(ValueType.parse(handle.getDesc())));
            }
            case 5: {
                return MethodHandle.virtualCaller(owner, name, this.parseSignature(handle.getDesc()));
            }
            case 6: {
                return MethodHandle.staticCaller(owner, name, this.parseSignature(handle.getDesc()));
            }
            case 7: {
                return MethodHandle.specialCaller(owner, name, this.parseSignature(handle.getDesc()));
            }
            case 8: {
                return MethodHandle.constructorCaller(owner, name, this.parseSignature(handle.getDesc()));
            }
            case 9: {
                return MethodHandle.interfaceCaller(owner, name, this.parseSignature(handle.getDesc()));
            }
        }
        throw new IllegalArgumentException("Unknown handle tag: " + handle.getTag());
    }

    private ValueType[] parseSignature(String desc) {
        ValueType[] signature = MethodDescriptor.parseSignature(desc);
        for (int i = 0; i < signature.length; ++i) {
            signature[i] = this.referenceCache.getCached(signature[i]);
        }
        return signature;
    }

    private static ValueType getPrimitiveTypeField(String fieldName) {
        switch (fieldName) {
            case "java/lang/Boolean.TYPE": {
                return ValueType.BOOLEAN;
            }
            case "java/lang/Byte.TYPE": {
                return ValueType.BYTE;
            }
            case "java/lang/Short.TYPE": {
                return ValueType.SHORT;
            }
            case "java/lang/Character.TYPE": {
                return ValueType.CHARACTER;
            }
            case "java/lang/Integer.TYPE": {
                return ValueType.INTEGER;
            }
            case "java/lang/Long.TYPE": {
                return ValueType.LONG;
            }
            case "java/lang/Float.TYPE": {
                return ValueType.FLOAT;
            }
            case "java/lang/Double.TYPE": {
                return ValueType.DOUBLE;
            }
            case "java/lang/Void.TYPE": {
                return ValueType.VOID;
            }
        }
        return null;
    }

    static /* synthetic */ int[] access$1002(ProgramParser x0, int[] x1) {
        x0.nextIndexes = x1;
        return x1;
    }

    private static class StackFrame {
        final StackFrame next;
        final byte type;
        final int depth;

        StackFrame(int depth) {
            this.next = null;
            this.type = 0;
            this.depth = depth;
        }

        StackFrame(StackFrame next, byte type) {
            this.next = next;
            this.type = type;
            this.depth = next != null ? next.depth + 1 : 0;
        }
    }

    private static class Step {
        public final int source;
        public final int target;

        public Step(int source, int target) {
            this.source = source;
            this.target = target;
        }
    }
}

