/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.teavm.callgraph.CallGraph;
import org.teavm.callgraph.CallGraphNode;
import org.teavm.callgraph.CallSite;
import org.teavm.dependency.DependencyInfo;
import org.teavm.interop.Async;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ProgramReader;
import org.teavm.model.VariableReader;
import org.teavm.model.instructions.AbstractInstructionReader;
import org.teavm.runtime.Fiber;

public class AsyncMethodFinder {
    private Set<MethodReference> asyncMethods = new HashSet<MethodReference>();
    private DependencyInfo dependency;
    private Map<MethodReference, Boolean> asyncFamilyMethods = new HashMap<MethodReference, Boolean>();
    private Set<MethodReference> readonlyAsyncMethods = Collections.unmodifiableSet(this.asyncMethods);
    private Set<MethodReference> readonlyAsyncFamilyMethods = Collections.unmodifiableSet(this.asyncFamilyMethods.keySet());
    private CallGraph callGraph;
    private ListableClassReaderSource classSource;
    private boolean hasAsyncMethods;

    public AsyncMethodFinder(CallGraph callGraph, DependencyInfo dependency) {
        this.callGraph = callGraph;
        this.dependency = dependency;
    }

    public Set<MethodReference> getAsyncMethods() {
        return this.readonlyAsyncMethods;
    }

    public Set<MethodReference> getAsyncFamilyMethods() {
        return this.readonlyAsyncFamilyMethods;
    }

    public void find(ListableClassReaderSource classSource) {
        ClassReader cls;
        this.classSource = classSource;
        this.hasAsyncMethods = this.findAsyncMethods();
        for (String string : classSource.getClassNames()) {
            cls = classSource.get(string);
            for (MethodReader methodReader : cls.getMethods()) {
                if (!this.dependency.getReachableMethods().contains(methodReader.getReference()) || this.asyncMethods.contains(methodReader.getReference()) || methodReader.getAnnotations().get(Async.class.getName()) == null) continue;
                this.add(methodReader.getReference(), new CallStack(methodReader.getReference(), null));
            }
        }
        if (this.hasAsyncMethods) {
            for (String string : classSource.getClassNames()) {
                cls = classSource.get(string);
                for (MethodReader methodReader : cls.getMethods()) {
                    if (!this.dependency.getReachableMethods().contains(methodReader.getReference()) || this.asyncMethods.contains(methodReader.getReference()) || methodReader.getProgram() == null || !this.hasMonitor(methodReader)) continue;
                    this.add(methodReader.getReference(), new CallStack(methodReader.getReference(), null));
                }
            }
        }
        for (MethodReference methodReference : this.asyncMethods) {
            this.addOverriddenToFamily(methodReference);
        }
        for (String string : classSource.getClassNames()) {
            cls = classSource.get(string);
            for (MethodReader methodReader : cls.getMethods()) {
                this.addToFamily(methodReader.getReference());
            }
        }
        for (Map.Entry entry : new ArrayList<Map.Entry<MethodReference, Boolean>>(this.asyncFamilyMethods.entrySet())) {
            if (((Boolean)entry.getValue()).booleanValue()) continue;
            this.asyncFamilyMethods.remove(entry.getKey());
        }
    }

    private boolean findAsyncMethods() {
        boolean result = false;
        block0: for (String clsName : this.classSource.getClassNames()) {
            ClassReader cls = this.classSource.get(clsName);
            for (MethodReader methodReader : cls.getMethods()) {
                if (!this.asyncMethods.contains(methodReader.getReference()) || methodReader.getProgram() == null || !this.hasMonitor(methodReader)) continue;
                result = true;
                break block0;
            }
        }
        boolean hasThreads = this.dependency.getReachableMethods().contains(new MethodReference(Thread.class, "start", Void.TYPE));
        return result && hasThreads;
    }

    public boolean hasAsyncMethods() {
        return this.hasAsyncMethods;
    }

    private boolean hasMonitor(MethodReader method) {
        if (method.hasModifier(ElementModifier.SYNCHRONIZED)) {
            return true;
        }
        ProgramReader program = method.getProgram();
        AsyncInstructionReader insnReader = new AsyncInstructionReader();
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            program.basicBlockAt(i).readAllInstructions(insnReader);
            if (!insnReader.async) continue;
            return true;
        }
        return false;
    }

    private void add(MethodReference methodRef, CallStack stack) {
        if (methodRef.getClassName().equals(Fiber.class.getName())) {
            return;
        }
        if (!this.asyncMethods.add(methodRef)) {
            return;
        }
        CallGraphNode node = this.callGraph.getNode(methodRef);
        if (node == null) {
            return;
        }
        ClassReader cls = this.classSource.get(methodRef.getClassName());
        if (cls == null) {
            return;
        }
        MethodReader method = cls.getMethod(methodRef.getDescriptor());
        if (method == null) {
            return;
        }
        if (!this.hasAsyncMethods && methodRef.getClassName().equals("java.lang.Object") && (methodRef.getName().equals("monitorEnter") || methodRef.getName().equals("monitorExit"))) {
            return;
        }
        for (CallSite callSite : node.getCallerCallSites()) {
            for (CallGraphNode callGraphNode : callSite.getCallers()) {
                this.add(callGraphNode.getMethod(), new CallStack(callGraphNode.getMethod(), stack));
            }
        }
    }

    private void addOverriddenToFamily(MethodReference methodRef) {
        this.asyncFamilyMethods.put(methodRef, true);
        ClassReader cls = this.classSource.get(methodRef.getClassName());
        if (cls == null) {
            return;
        }
        for (MethodReference overriddenMethod : this.findOverriddenMethods(cls, methodRef.getDescriptor())) {
            this.addOverriddenToFamily(overriddenMethod);
        }
    }

    private boolean addToFamily(MethodReference methodRef) {
        Boolean cachedResult = this.asyncFamilyMethods.get(methodRef);
        if (cachedResult != null) {
            return cachedResult;
        }
        boolean result = this.addToFamilyCacheMiss(methodRef);
        this.asyncFamilyMethods.put(methodRef, result);
        return result;
    }

    private boolean addToFamilyCacheMiss(MethodReference methodRef) {
        if (this.asyncMethods.contains(methodRef)) {
            return true;
        }
        ClassReader cls = this.classSource.get(methodRef.getClassName());
        if (cls == null) {
            return false;
        }
        for (MethodReference overriddenMethod : this.findOverriddenMethods(cls, methodRef.getDescriptor())) {
            if (!this.addToFamily(overriddenMethod)) continue;
            return true;
        }
        return false;
    }

    private Set<MethodReference> findOverriddenMethods(ClassReader cls, MethodDescriptor methodDesc) {
        ArrayList<String> parents = new ArrayList<String>();
        if (cls.getParent() != null) {
            parents.add(cls.getParent());
        }
        parents.addAll(cls.getInterfaces());
        HashSet<String> visited = new HashSet<String>();
        HashSet<MethodReference> overridden = new HashSet<MethodReference>();
        for (String parent : parents) {
            this.findOverriddenMethods(parent, methodDesc, overridden, visited);
        }
        return overridden;
    }

    private void findOverriddenMethods(String className, MethodDescriptor methodDesc, Set<MethodReference> result, Set<String> visited) {
        if (!visited.add(className)) {
            return;
        }
        if (methodDesc.getName().equals("<init>") || methodDesc.getName().equals("<clinit>")) {
            return;
        }
        ClassReader cls = this.classSource.get(className);
        if (cls == null) {
            return;
        }
        MethodReader method = cls.getMethod(methodDesc);
        if (method != null) {
            if (!method.hasModifier(ElementModifier.STATIC) && !method.hasModifier(ElementModifier.FINAL)) {
                result.add(method.getReference());
            }
        } else {
            if (cls.getParent() != null) {
                this.findOverriddenMethods(cls.getParent(), methodDesc, result, visited);
            }
            for (String iface : cls.getInterfaces()) {
                this.findOverriddenMethods(iface, methodDesc, result, visited);
            }
        }
    }

    static class AsyncInstructionReader
    extends AbstractInstructionReader {
        boolean async;

        AsyncInstructionReader() {
        }

        @Override
        public void monitorEnter(VariableReader objectRef) {
            this.async = true;
        }
    }

    static class CallStack {
        MethodReference method;
        CallStack next;

        CallStack(MethodReference method, CallStack next) {
            this.method = method;
            this.next = next;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            CallStack stack = this;
            while (stack != null) {
                sb.append("\n    calling " + stack.method);
                stack = stack.next;
            }
            return sb.toString();
        }
    }
}

