/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

import java.util.ArrayList;
import java.util.List;
import org.teavm.common.Graph;
import org.teavm.common.GraphBuilder;
import org.teavm.common.GraphUtils;
import org.teavm.hppc.IntArrayList;
import org.teavm.hppc.IntHashSet;
import org.teavm.hppc.cursors.IntCursor;

public class MutableDirectedGraph
implements Graph {
    private List<NodeSet> successors = new ArrayList<NodeSet>();
    private List<NodeSet> predecessors = new ArrayList<NodeSet>();

    public MutableDirectedGraph() {
    }

    public MutableDirectedGraph(Graph graph) {
        int[] data = new int[graph.size()];
        for (int i = 0; i < graph.size(); ++i) {
            int sz = graph.copyOutgoingEdges(i, data);
            for (int j = 0; j < sz; ++j) {
                this.addEdge(i, data[j]);
            }
        }
        while (this.successors.size() < graph.size()) {
            this.successors.add(new NodeSet());
            this.predecessors.add(new NodeSet());
        }
    }

    public Graph copyToImmutable() {
        GraphBuilder builder = new GraphBuilder(this.successors.size());
        for (int i = 0; i < this.successors.size(); ++i) {
            for (IntCursor successor : this.successors.get((int)i).list) {
                builder.addEdge(i, successor.value);
            }
        }
        return builder.build();
    }

    public int addNode() {
        int index = this.successors.size();
        this.successors.add(new NodeSet());
        this.predecessors.add(new NodeSet());
        return index;
    }

    @Override
    public int size() {
        return this.successors.size();
    }

    public void addEdge(int from, int to) {
        int max = Math.max(from, to);
        while (max >= this.successors.size()) {
            this.successors.add(new NodeSet());
            this.predecessors.add(new NodeSet());
        }
        NodeSet successorNodes = this.successors.get(from);
        if (successorNodes.set.add(to)) {
            successorNodes.list.add(to);
            NodeSet predecessorNodes = this.predecessors.get(to);
            predecessorNodes.set.add(from);
            predecessorNodes.list.add(from);
        }
    }

    public void deleteEdge(int from, int to) {
        if (from >= this.successors.size() || to >= this.successors.size()) {
            return;
        }
        NodeSet successorNodes = this.successors.get(from);
        if (successorNodes.set.removeAll(to) > 0) {
            successorNodes.list.removeAll(to);
            NodeSet predecessorNodes = this.predecessors.get(to);
            predecessorNodes.set.removeAll(from);
            predecessorNodes.list.removeAll(from);
        }
    }

    public void detachNode(int node) {
        for (IntCursor succ : this.successors.get((int)node).list) {
            NodeSet predecessorNodes = this.predecessors.get(succ.value);
            predecessorNodes.set.removeAll(node);
            predecessorNodes.list.removeAll(node);
        }
        for (IntCursor pred : this.predecessors.get((int)node).list) {
            NodeSet successorNodes = this.successors.get(pred.value);
            successorNodes.set.removeAll(node);
            successorNodes.list.removeAll(node);
        }
        NodeSet predecessorNodes = this.predecessors.get(node);
        predecessorNodes.list.clear();
        predecessorNodes.set.clear();
        NodeSet successorNodes = this.successors.get(node);
        successorNodes.list.clear();
        predecessorNodes.list.clear();
    }

    @Override
    public int[] incomingEdges(int node) {
        return this.predecessors.get((int)node).list.toArray();
    }

    @Override
    public int copyIncomingEdges(int node, int[] target) {
        int index = 0;
        for (IntCursor cursor : this.predecessors.get((int)node).list) {
            target[index++] = cursor.value;
        }
        return index;
    }

    @Override
    public int[] outgoingEdges(int node) {
        return this.successors.get((int)node).list.toArray();
    }

    @Override
    public int copyOutgoingEdges(int node, int[] target) {
        int index = 0;
        for (IntCursor cursor : this.successors.get((int)node).list) {
            target[index++] = cursor.value;
        }
        return index;
    }

    @Override
    public int incomingEdgesCount(int node) {
        return this.predecessors.get((int)node).list.size();
    }

    @Override
    public int outgoingEdgesCount(int node) {
        return this.successors.get((int)node).list.size();
    }

    public String toString() {
        return GraphUtils.printToDot(this);
    }

    static class NodeSet {
        IntHashSet set = new IntHashSet(1);
        IntArrayList list = new IntArrayList(1);

        NodeSet() {
        }
    }
}

