/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.DuplicateFormatFlagsException;
import java.util.FormatFlagsConversionMismatchException;
import java.util.IllegalFormatConversionException;
import java.util.Locale;
import java.util.UnknownFormatConversionException;
import org.teavm.classlib.impl.IntegerUtil;
import org.teavm.classlib.java.util.TFormattable;
import org.teavm.classlib.java.util.TFormatterClosedException;
import org.teavm.classlib.java.util.TIllegalFormatCodePointException;
import org.teavm.classlib.java.util.TIllegalFormatFlagsException;
import org.teavm.classlib.java.util.TIllegalFormatPrecisionException;
import org.teavm.classlib.java.util.TMissingFormatWidthException;

public final class TFormatter
implements Closeable,
Flushable {
    private Locale locale;
    private Appendable out;
    private IOException ioException;

    public TFormatter() {
        this(Locale.getDefault());
    }

    public TFormatter(Appendable a) {
        this(a, Locale.getDefault());
    }

    public TFormatter(Locale l) {
        this(new StringBuilder(), l);
    }

    public TFormatter(Appendable a, Locale l) {
        this.out = a;
        this.locale = l;
    }

    public TFormatter(PrintStream ps) {
        this(new OutputStreamWriter(ps));
    }

    public TFormatter(OutputStream os) {
        this(new OutputStreamWriter(os));
    }

    public TFormatter(OutputStream os, String csn) throws UnsupportedEncodingException {
        this(new OutputStreamWriter(os, csn));
    }

    public TFormatter(OutputStream os, String csn, Locale l) throws UnsupportedEncodingException {
        this(new OutputStreamWriter(os, csn), l);
    }

    public Locale locale() {
        this.requireOpen();
        return this.locale;
    }

    public Appendable out() {
        this.requireOpen();
        return this.out;
    }

    private void requireOpen() {
        if (this.out == null) {
            throw new TFormatterClosedException();
        }
    }

    public String toString() {
        this.requireOpen();
        return this.out.toString();
    }

    @Override
    public void flush() {
        this.requireOpen();
        if (this.out instanceof Flushable) {
            try {
                ((Flushable)((Object)this.out)).flush();
            }
            catch (IOException e) {
                this.ioException = e;
            }
        }
    }

    @Override
    public void close() {
        this.requireOpen();
        try {
            if (this.out instanceof Closeable) {
                ((Closeable)((Object)this.out)).close();
            }
        }
        catch (IOException e) {
            this.ioException = e;
        }
        finally {
            this.out = null;
        }
    }

    public IOException ioException() {
        return this.ioException;
    }

    public TFormatter format(String format, Object ... args) {
        return this.format(this.locale, format, args);
    }

    public TFormatter format(Locale l, String format, Object ... args) {
        this.requireOpen();
        try {
            if (args == null) {
                args = new Object[1];
            }
            new FormatWriter(this, this.out, l, format, args).write();
        }
        catch (IOException e) {
            this.ioException = e;
        }
        return this;
    }

    static class FormatWriter {
        private static final String FORMAT_FLAGS = "--#+ 0,(<";
        private static final int MASK_FOR_GENERAL_FORMAT = 263;
        private static final int MASK_FOR_CHAR_FORMAT = 259;
        private static final int MASK_FOR_INT_DECIMAL_FORMAT = 507;
        private static final int MASK_FOR_INT_RADIX_FORMAT = 423;
        private TFormatter formatter;
        Appendable out;
        Locale locale;
        String format;
        Object[] args;
        int index;
        int formatSpecifierStart;
        int defaultArgumentIndex;
        int argumentIndex;
        int previousArgumentIndex;
        int width;
        int precision;
        int flags;

        FormatWriter(TFormatter formatter, Appendable out, Locale locale, String format, Object[] args) {
            this.formatter = formatter;
            this.out = out;
            this.locale = locale;
            this.format = format;
            this.args = args;
        }

        void write() throws IOException {
            while (true) {
                int next;
                if ((next = this.format.indexOf(37, this.index)) < 0) break;
                this.out.append(this.format.substring(this.index, next));
                this.formatSpecifierStart = this.index = next + 1;
                char specifier = this.parseFormatSpecifier();
                this.configureFormat();
                this.formatValue(specifier);
            }
            this.out.append(this.format.substring(this.index));
        }

        private void formatValue(char specifier) throws IOException {
            switch (specifier) {
                case 'b': {
                    this.formatBoolean(specifier, false);
                    break;
                }
                case 'B': {
                    this.formatBoolean(specifier, true);
                    break;
                }
                case 'h': {
                    this.formatHex(specifier, false);
                    break;
                }
                case 'H': {
                    this.formatHex(specifier, true);
                    break;
                }
                case 's': {
                    this.formatString(specifier, false);
                    break;
                }
                case 'S': {
                    this.formatString(specifier, true);
                    break;
                }
                case 'c': {
                    this.formatChar(specifier, false);
                    break;
                }
                case 'C': {
                    this.formatChar(specifier, true);
                    break;
                }
                case 'd': {
                    this.formatDecimalInt(specifier, false);
                    break;
                }
                case 'D': {
                    this.formatDecimalInt(specifier, true);
                    break;
                }
                case 'o': {
                    this.formatRadixInt(specifier, 3, false);
                    break;
                }
                case 'O': {
                    this.formatRadixInt(specifier, 3, true);
                    break;
                }
                case 'x': {
                    this.formatRadixInt(specifier, 4, false);
                    break;
                }
                case 'X': {
                    this.formatRadixInt(specifier, 4, true);
                    break;
                }
                default: {
                    throw new UnknownFormatConversionException(String.valueOf(specifier));
                }
            }
        }

        private void formatBoolean(char specifier, boolean upperCase) throws IOException {
            this.verifyFlagsForGeneralFormat(specifier);
            Object arg = this.args[this.argumentIndex];
            String s = Boolean.toString(arg instanceof Boolean ? (Boolean)arg : arg != null);
            this.formatGivenString(upperCase, s);
        }

        private void formatHex(char specifier, boolean upperCase) throws IOException {
            this.verifyFlagsForGeneralFormat(specifier);
            Object arg = this.args[this.argumentIndex];
            String s = arg != null ? Integer.toHexString(arg.hashCode()) : "null";
            this.formatGivenString(upperCase, s);
        }

        private void formatString(char specifier, boolean upperCase) throws IOException {
            this.verifyFlagsForGeneralFormat(specifier);
            Object arg = this.args[this.argumentIndex];
            if (arg instanceof TFormattable) {
                int flagsToPass = this.flags & 7;
                if (upperCase) {
                    flagsToPass |= 2;
                }
                ((TFormattable)arg).formatTo(this.formatter, flagsToPass, this.width, this.precision);
            } else {
                this.formatGivenString(upperCase, String.valueOf(arg));
            }
        }

        private void formatChar(char specifier, boolean upperCase) throws IOException {
            int c;
            this.verifyFlags(specifier, 259);
            Object arg = this.args[this.argumentIndex];
            if (this.precision >= 0) {
                throw new TIllegalFormatPrecisionException(this.precision);
            }
            if (arg instanceof Character) {
                c = ((Character)arg).charValue();
            } else if (arg instanceof Byte) {
                c = (char)((Byte)arg).byteValue();
            } else if (arg instanceof Short) {
                c = (char)((Short)arg).shortValue();
            } else if (arg instanceof Integer) {
                c = (Integer)arg;
                if (!Character.isValidCodePoint(c)) {
                    throw new TIllegalFormatCodePointException(c);
                }
            } else {
                if (arg == null) {
                    this.formatGivenString(upperCase, "null");
                    return;
                }
                throw new IllegalFormatConversionException(specifier, arg.getClass());
            }
            this.formatGivenString(upperCase, new String(Character.toChars(c)));
        }

        private void formatDecimalInt(char specifier, boolean upperCase) throws IOException {
            boolean negative;
            String str;
            this.verifyFlags(specifier, 507);
            this.verifyIntFlags();
            Object arg = this.args[this.argumentIndex];
            if (arg instanceof Long) {
                long value = (Long)arg;
                str = Long.toString(Math.abs(value));
                negative = value < 0L;
            } else if (arg instanceof Integer || arg instanceof Byte || arg instanceof Short) {
                int value = ((Number)arg).intValue();
                str = Integer.toString(Math.abs(value));
                negative = value < 0;
            } else {
                throw new IllegalFormatConversionException(specifier, arg != null ? arg.getClass() : null);
            }
            int additionalSymbols = 0;
            StringBuilder sb = new StringBuilder();
            if (negative) {
                if ((this.flags & 0x80) != 0) {
                    sb.append('(');
                    additionalSymbols += 2;
                } else {
                    sb.append('-');
                    ++additionalSymbols;
                }
            } else if ((this.flags & 8) != 0) {
                sb.append('+');
                ++additionalSymbols;
            } else if ((this.flags & 0x10) != 0) {
                sb.append(' ');
                ++additionalSymbols;
            }
            StringBuilder valueSb = new StringBuilder();
            if ((this.flags & 0x40) != 0) {
                char separator = new DecimalFormatSymbols(this.locale).getGroupingSeparator();
                int size = ((DecimalFormat)NumberFormat.getNumberInstance(this.locale)).getGroupingSize();
                int offset = str.length() % size;
                if (offset == 0) {
                    offset = size;
                }
                int prev = 0;
                for (int i = offset; i < str.length(); i += size) {
                    valueSb.append(str.substring(prev, i));
                    valueSb.append(separator);
                    prev = i;
                }
                valueSb.append(str.substring(prev));
            } else {
                valueSb.append(str);
            }
            if ((this.flags & 0x20) != 0) {
                int actual;
                for (int i = actual = valueSb.length() + additionalSymbols; i < this.width; ++i) {
                    sb.append(Character.forDigit(0, 10));
                }
            }
            sb.append((CharSequence)valueSb);
            if (negative && (this.flags & 0x80) != 0) {
                sb.append(')');
            }
            this.formatGivenString(upperCase, sb.toString());
        }

        private void formatRadixInt(char specifier, int radixLog2, boolean upperCase) throws IOException {
            String str;
            this.verifyFlags(specifier, 423);
            this.verifyIntFlags();
            Object arg = this.args[this.argumentIndex];
            if (arg instanceof Long) {
                str = IntegerUtil.toUnsignedLogRadixString((Long)arg, radixLog2);
            } else if (arg instanceof Integer) {
                str = IntegerUtil.toUnsignedLogRadixString((Integer)arg, radixLog2);
            } else if (arg instanceof Short) {
                str = IntegerUtil.toUnsignedLogRadixString((Short)arg & 0xFFFF, radixLog2);
            } else if (arg instanceof Byte) {
                str = IntegerUtil.toUnsignedLogRadixString((Byte)arg & 0xFF, radixLog2);
            } else {
                throw new IllegalFormatConversionException(specifier, arg != null ? arg.getClass() : null);
            }
            StringBuilder sb = new StringBuilder();
            if ((this.flags & 4) != 0) {
                String prefix = radixLog2 == 4 ? "0x" : "0";
                str = prefix + str;
            }
            if ((this.flags & 0x20) != 0) {
                for (int i = str.length(); i < this.width; ++i) {
                    sb.append(Character.forDigit(0, 10));
                }
            }
            sb.append(str);
            this.formatGivenString(upperCase, sb.toString());
        }

        private void verifyIntFlags() {
            if ((this.flags & 8) != 0 && (this.flags & 0x10) != 0) {
                throw new TIllegalFormatFlagsException("+ ");
            }
            if ((this.flags & 0x20) != 0 && (this.flags & 1) != 0) {
                throw new TIllegalFormatFlagsException("0-");
            }
            if (this.precision >= 0) {
                throw new TIllegalFormatPrecisionException(this.precision);
            }
            if ((this.flags & 1) != 0 && this.width < 0) {
                throw new TMissingFormatWidthException(this.format.substring(this.formatSpecifierStart, this.index));
            }
        }

        private void formatGivenString(boolean upperCase, String str) throws IOException {
            if (this.precision > 0) {
                str = str.substring(0, this.precision);
            }
            if (upperCase) {
                str = str.toUpperCase();
            }
            if ((this.flags & 1) != 0) {
                this.out.append(str);
                this.mayBeAppendSpaces(str);
            } else {
                this.mayBeAppendSpaces(str);
                this.out.append(str);
            }
        }

        private void verifyFlagsForGeneralFormat(char conversion) {
            this.verifyFlags(conversion, 263);
        }

        private void verifyFlags(char conversion, int mask) {
            if ((this.flags | mask) != mask) {
                throw new FormatFlagsConversionMismatchException(this.flagsToString(this.flags & ~mask), conversion);
            }
        }

        private String flagsToString(int flags) {
            int flagIndex = Integer.numberOfTrailingZeros(flags);
            return String.valueOf(FORMAT_FLAGS.charAt(flagIndex));
        }

        private void mayBeAppendSpaces(String str) throws IOException {
            if (this.width > str.length()) {
                int diff = this.width - str.length();
                StringBuilder sb = new StringBuilder(diff);
                for (int i = 0; i < diff; ++i) {
                    sb.append(' ');
                }
                this.out.append(sb);
            }
        }

        private void configureFormat() {
            if ((this.flags & 0x100) != 0) {
                this.argumentIndex = Math.max(0, this.previousArgumentIndex);
            }
            if (this.argumentIndex == -1) {
                this.argumentIndex = this.defaultArgumentIndex++;
            }
            this.previousArgumentIndex = this.argumentIndex;
        }

        private char parseFormatSpecifier() {
            this.flags = 0;
            this.argumentIndex = -1;
            this.width = -1;
            this.precision = -1;
            char c = this.format.charAt(this.index);
            if (c != '0' && FormatWriter.isDigit(c)) {
                int n = this.readInt();
                if (this.index < this.format.length() && this.format.charAt(this.index) == '$') {
                    ++this.index;
                    this.argumentIndex = n - 1;
                } else {
                    this.width = n;
                }
            }
            this.parseFlags();
            if (this.width < 0 && this.index < this.format.length() && FormatWriter.isDigit(this.format.charAt(this.index))) {
                this.width = this.readInt();
            }
            if (this.index < this.format.length() && this.format.charAt(this.index) == '.') {
                ++this.index;
                if (this.index >= this.format.length() || !FormatWriter.isDigit(this.format.charAt(this.index))) {
                    throw new UnknownFormatConversionException(String.valueOf(this.format.charAt(this.index - 1)));
                }
                this.precision = this.readInt();
            }
            if (this.index >= this.format.length()) {
                throw new UnknownFormatConversionException(String.valueOf(this.format.charAt(this.format.length() - 1)));
            }
            return this.format.charAt(this.index++);
        }

        private void parseFlags() {
            while (this.index < this.format.length()) {
                int flag;
                char c = this.format.charAt(this.index);
                switch (c) {
                    case '-': {
                        flag = 1;
                        break;
                    }
                    case '#': {
                        flag = 4;
                        break;
                    }
                    case '+': {
                        flag = 8;
                        break;
                    }
                    case ' ': {
                        flag = 16;
                        break;
                    }
                    case '0': {
                        flag = 32;
                        break;
                    }
                    case ',': {
                        flag = 64;
                        break;
                    }
                    case '(': {
                        flag = 128;
                        break;
                    }
                    case '<': {
                        flag = 256;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if ((this.flags & flag) != 0) {
                    throw new DuplicateFormatFlagsException(String.valueOf(c));
                }
                this.flags |= flag;
                ++this.index;
            }
        }

        private int readInt() {
            int result = 0;
            while (this.index < this.format.length() && FormatWriter.isDigit(this.format.charAt(this.index))) {
                result = result * 10 + (this.format.charAt(this.index++) - 48);
            }
            return result;
        }

        private static boolean isDigit(char c) {
            return c >= '0' && c <= '9';
        }
    }
}

