/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teavm.cache.SymbolTable;

public class InMemorySymbolTable
implements SymbolTable {
    private List<String> symbols = new ArrayList<String>();
    private Map<String, Integer> indexes = new HashMap<String, Integer>();

    @Override
    public String at(int index) {
        return this.symbols.get(index);
    }

    @Override
    public int lookup(String symbol) {
        Integer index = this.indexes.get(symbol);
        if (index == null) {
            index = this.symbols.size();
            this.symbols.add(symbol);
            this.indexes.put(symbol, index);
        }
        return index;
    }

    public void invalidate() {
        this.symbols.clear();
        this.indexes.clear();
    }
}

