/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate;

import java.util.List;
import org.teavm.backend.wasm.WasmHeap;
import org.teavm.backend.wasm.generate.WasmClassGenerator;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt32Subtype;
import org.teavm.backend.wasm.model.expression.WasmLoadInt32;
import org.teavm.backend.wasm.model.expression.WasmReturn;
import org.teavm.model.FieldReference;

public class WasmSpecialFunctionGenerator {
    private WasmClassGenerator classGenerator;
    private List<WasmInt32Constant> regionSizeExpressions;

    public WasmSpecialFunctionGenerator(WasmClassGenerator classGenerator, List<WasmInt32Constant> regionSizeExpressions) {
        this.classGenerator = classGenerator;
        this.regionSizeExpressions = regionSizeExpressions;
    }

    public void generateSpecialFunctions(WasmModule module) {
        module.add(this.javaHeapAddress());
        module.add(this.availableBytes());
        module.add(this.regionsAddress());
        module.add(this.regionSize());
    }

    private WasmFunction javaHeapAddress() {
        WasmFunction function = new WasmFunction("teavm_javaHeapAddress");
        function.setExportName("teavm_javaHeapAddress");
        function.setResult(WasmType.INT32);
        int address = this.classGenerator.getFieldOffset(new FieldReference(WasmHeap.class.getName(), "heapAddress"));
        function.getBody().add(new WasmReturn(new WasmLoadInt32(4, new WasmInt32Constant(address), WasmInt32Subtype.INT32)));
        return function;
    }

    private WasmFunction availableBytes() {
        WasmFunction function = new WasmFunction("teavm_availableBytes");
        function.setExportName("teavm_availableBytes");
        function.setResult(WasmType.INT32);
        int address = this.classGenerator.getFieldOffset(new FieldReference(WasmHeap.class.getName(), "heapSize"));
        function.getBody().add(new WasmReturn(new WasmLoadInt32(4, new WasmInt32Constant(address), WasmInt32Subtype.INT32)));
        return function;
    }

    private WasmFunction regionsAddress() {
        WasmFunction function = new WasmFunction("teavm_regionsAddress");
        function.setExportName("teavm_regionsAddress");
        function.setResult(WasmType.INT32);
        int address = this.classGenerator.getFieldOffset(new FieldReference(WasmHeap.class.getName(), "regionsAddress"));
        function.getBody().add(new WasmReturn(new WasmLoadInt32(4, new WasmInt32Constant(address), WasmInt32Subtype.INT32)));
        return function;
    }

    private WasmFunction regionSize() {
        WasmFunction function = new WasmFunction("teavm_regionSize");
        function.setExportName("teavm_regionSize");
        function.setResult(WasmType.INT32);
        WasmInt32Constant constant = new WasmInt32Constant(0);
        this.regionSizeExpressions.add(constant);
        function.getBody().add(new WasmReturn(constant));
        return function;
    }
}

