/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.rendering;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.rendering.NameEmitter;
import org.teavm.model.MethodReference;
import org.teavm.rhino.javascript.Node;
import org.teavm.rhino.javascript.ScriptRuntime;
import org.teavm.rhino.javascript.ast.ArrayComprehension;
import org.teavm.rhino.javascript.ast.ArrayComprehensionLoop;
import org.teavm.rhino.javascript.ast.ArrayLiteral;
import org.teavm.rhino.javascript.ast.AstNode;
import org.teavm.rhino.javascript.ast.AstRoot;
import org.teavm.rhino.javascript.ast.Block;
import org.teavm.rhino.javascript.ast.BreakStatement;
import org.teavm.rhino.javascript.ast.CatchClause;
import org.teavm.rhino.javascript.ast.ConditionalExpression;
import org.teavm.rhino.javascript.ast.ContinueStatement;
import org.teavm.rhino.javascript.ast.DoLoop;
import org.teavm.rhino.javascript.ast.ElementGet;
import org.teavm.rhino.javascript.ast.EmptyStatement;
import org.teavm.rhino.javascript.ast.ExpressionStatement;
import org.teavm.rhino.javascript.ast.ForInLoop;
import org.teavm.rhino.javascript.ast.ForLoop;
import org.teavm.rhino.javascript.ast.FunctionCall;
import org.teavm.rhino.javascript.ast.FunctionNode;
import org.teavm.rhino.javascript.ast.GeneratorExpression;
import org.teavm.rhino.javascript.ast.GeneratorExpressionLoop;
import org.teavm.rhino.javascript.ast.IfStatement;
import org.teavm.rhino.javascript.ast.InfixExpression;
import org.teavm.rhino.javascript.ast.Label;
import org.teavm.rhino.javascript.ast.LabeledStatement;
import org.teavm.rhino.javascript.ast.LetNode;
import org.teavm.rhino.javascript.ast.Name;
import org.teavm.rhino.javascript.ast.NewExpression;
import org.teavm.rhino.javascript.ast.NumberLiteral;
import org.teavm.rhino.javascript.ast.ObjectLiteral;
import org.teavm.rhino.javascript.ast.ObjectProperty;
import org.teavm.rhino.javascript.ast.ParenthesizedExpression;
import org.teavm.rhino.javascript.ast.PropertyGet;
import org.teavm.rhino.javascript.ast.RegExpLiteral;
import org.teavm.rhino.javascript.ast.ReturnStatement;
import org.teavm.rhino.javascript.ast.Scope;
import org.teavm.rhino.javascript.ast.StringLiteral;
import org.teavm.rhino.javascript.ast.SwitchCase;
import org.teavm.rhino.javascript.ast.SwitchStatement;
import org.teavm.rhino.javascript.ast.ThrowStatement;
import org.teavm.rhino.javascript.ast.TryStatement;
import org.teavm.rhino.javascript.ast.UnaryExpression;
import org.teavm.rhino.javascript.ast.VariableDeclaration;
import org.teavm.rhino.javascript.ast.VariableInitializer;
import org.teavm.rhino.javascript.ast.WhileLoop;

public class AstWriter {
    public static final int PRECEDENCE_MEMBER = 2;
    public static final int PRECEDENCE_FUNCTION = 3;
    public static final int PRECEDENCE_POSTFIX = 4;
    public static final int PRECEDENCE_PREFIX = 5;
    public static final int PRECEDENCE_MUL = 6;
    public static final int PRECEDENCE_ADD = 7;
    public static final int PRECEDENCE_SHIFT = 8;
    public static final int PRECEDENCE_RELATION = 9;
    public static final int PRECEDENCE_EQUALITY = 10;
    public static final int PRECEDENCE_BITWISE_AND = 11;
    public static final int PRECEDENCE_BITWISE_XOR = 12;
    public static final int PRECEDENCE_BITWISE_OR = 13;
    public static final int PRECEDENCE_AND = 14;
    public static final int PRECEDENCE_OR = 15;
    public static final int PRECEDENCE_COND = 16;
    public static final int PRECEDENCE_ASSIGN = 17;
    public static final int PRECEDENCE_COMMA = 18;
    private SourceWriter writer;
    private Map<String, NameEmitter> nameMap = new HashMap<String, NameEmitter>();
    private Set<String> aliases = new HashSet<String>();

    public AstWriter(SourceWriter writer) {
        this.writer = writer;
    }

    private void declareName(String name) {
        if (this.nameMap.containsKey(name)) {
            return;
        }
        if (this.aliases.add(name)) {
            this.nameMap.put(name, p -> this.writer.append(name));
            return;
        }
        int i = 0;
        while (true) {
            String alias;
            if (this.aliases.add(alias = name + "_" + i)) {
                this.nameMap.put(name, p -> this.writer.append(alias));
                return;
            }
            ++i;
        }
    }

    public void declareNameEmitter(String name, NameEmitter emitter) {
        this.nameMap.put(name, emitter);
    }

    public void hoist(Object node) {
        this.hoist((AstNode)node);
    }

    public void hoist(AstNode node) {
        node.visit(n -> {
            Scope scope;
            if (n instanceof Scope && (scope = (Scope)n).getSymbolTable() != null) {
                for (String name : scope.getSymbolTable().keySet()) {
                    this.declareName(name);
                }
            }
            return true;
        });
    }

    public void print(Object node) throws IOException {
        this.print((AstNode)node);
    }

    public void print(Object node, int precedence) throws IOException {
        this.print((AstNode)node, precedence);
    }

    public void print(AstNode node) throws IOException {
        this.print(node, 18);
    }

    public void print(AstNode node, int precedence) throws IOException {
        switch (node.getType()) {
            case 137: {
                this.print((AstRoot)node);
                break;
            }
            case 30: 
            case 38: {
                this.print((FunctionCall)node, precedence);
                break;
            }
            case 110: {
                this.print((FunctionNode)node);
                break;
            }
            case 158: {
                this.print((ArrayComprehension)node);
                break;
            }
            case 33: {
                this.print((PropertyGet)node);
                break;
            }
            case 163: {
                this.print((GeneratorExpression)node);
                break;
            }
            case 40: {
                this.print((NumberLiteral)node);
                break;
            }
            case 41: {
                this.print((StringLiteral)node);
                break;
            }
            case 45: {
                this.writer.append("true");
                break;
            }
            case 44: {
                this.writer.append("false");
                break;
            }
            case 43: {
                if (this.nameMap.containsKey("this")) {
                    this.nameMap.get("this").emit(precedence);
                    break;
                }
                this.writer.append("this");
                break;
            }
            case 42: {
                this.writer.append("null");
                break;
            }
            case 39: {
                this.print((Name)node, precedence);
                break;
            }
            case 48: {
                this.print((RegExpLiteral)node);
                break;
            }
            case 67: {
                this.print((ObjectLiteral)node);
                break;
            }
            case 66: {
                this.print((ArrayLiteral)node);
                break;
            }
            case 130: {
                if (node instanceof Block) {
                    this.print((Block)node);
                    break;
                }
                if (!(node instanceof Scope)) break;
                this.print((Scope)node);
                break;
            }
            case 103: {
                this.print((ConditionalExpression)node, precedence);
                break;
            }
            case 36: {
                this.print((ElementGet)node);
                break;
            }
            case 159: {
                this.print((LetNode)node);
                break;
            }
            case 88: {
                this.print((ParenthesizedExpression)node, precedence);
                break;
            }
            case 129: {
                if (!(node instanceof EmptyStatement)) break;
                this.writer.append(';');
                break;
            }
            case 134: 
            case 135: {
                if (node instanceof ExpressionStatement) {
                    this.print((ExpressionStatement)node);
                    break;
                }
                if (!(node instanceof LabeledStatement)) break;
                this.print((LabeledStatement)node);
                break;
            }
            case 121: {
                this.print((BreakStatement)node);
                break;
            }
            case 122: {
                this.print((ContinueStatement)node);
                break;
            }
            case 4: {
                this.print((ReturnStatement)node);
                break;
            }
            case 119: {
                this.print((DoLoop)node);
                break;
            }
            case 120: {
                if (node instanceof ForInLoop) {
                    this.print((ForInLoop)node);
                    break;
                }
                if (!(node instanceof ForLoop)) break;
                this.print((ForLoop)node);
                break;
            }
            case 113: {
                this.print((IfStatement)node);
                break;
            }
            case 115: {
                this.print((SwitchStatement)node);
                break;
            }
            case 50: {
                this.print((ThrowStatement)node);
                break;
            }
            case 82: {
                this.print((TryStatement)node);
                break;
            }
            case 123: 
            case 154: 
            case 155: {
                this.print((VariableDeclaration)node);
                break;
            }
            case 118: {
                this.print((WhileLoop)node);
                break;
            }
            default: {
                if (node instanceof InfixExpression) {
                    this.printInfix((InfixExpression)node, precedence);
                    break;
                }
                if (!(node instanceof UnaryExpression)) break;
                this.printUnary((UnaryExpression)node, precedence);
            }
        }
    }

    private void print(AstRoot node) throws IOException {
        for (Node child : node) {
            this.print((AstNode)child);
            this.writer.softNewLine();
        }
    }

    private void print(Block node) throws IOException {
        this.writer.append('{').softNewLine().indent();
        for (Node child = node.getFirstChild(); child != null; child = child.getNext()) {
            this.print((AstNode)child);
            this.writer.softNewLine();
        }
        this.writer.outdent().append('}');
    }

    private void print(Scope node) throws IOException {
        this.writer.append('{').softNewLine().indent();
        for (Node child = node.getFirstChild(); child != null; child = child.getNext()) {
            this.print((AstNode)child);
            this.writer.softNewLine();
        }
        this.writer.outdent().append('}');
    }

    private void print(LabeledStatement node) throws IOException {
        for (Label label : node.getLabels()) {
            this.writer.append(label.getName()).append(':').ws();
        }
        this.print(node.getStatement());
    }

    private void print(BreakStatement node) throws IOException {
        this.writer.append("break");
        if (node.getBreakLabel() != null) {
            this.writer.append(' ').append(node.getBreakLabel().getString());
        }
        this.writer.append(';');
    }

    private void print(ContinueStatement node) throws IOException {
        this.writer.append("continue");
        if (node.getLabel() != null) {
            this.writer.append(' ').append(node.getLabel().getString());
        }
        this.writer.append(';');
    }

    private void print(ReturnStatement node) throws IOException {
        this.writer.append("return");
        if (node.getReturnValue() != null) {
            this.writer.append(' ');
            this.print(node.getReturnValue());
        }
        this.writer.append(';');
    }

    private void print(ThrowStatement node) throws IOException {
        this.writer.append("throw ");
        this.print(node.getExpression());
        this.writer.append(';');
    }

    private void print(DoLoop node) throws IOException {
        this.writer.append("do ").ws();
        this.print(node.getBody());
        this.writer.append("while").ws().append('(');
        this.print(node.getCondition());
        this.writer.append(");");
    }

    private void print(ForInLoop node) throws IOException {
        this.writer.append("for");
        if (node.isForEach()) {
            this.writer.append(" each");
        }
        this.writer.ws().append("(");
        this.print(node.getIterator());
        this.writer.append(" in ");
        this.print(node.getIteratedObject());
        this.writer.append(')').ws();
        this.print(node.getBody());
    }

    private void print(ForLoop node) throws IOException {
        this.writer.append("for").ws().append('(');
        this.print(node.getInitializer());
        this.writer.append(';');
        this.print(node.getCondition());
        this.writer.append(';');
        this.print(node.getIncrement());
        this.writer.append(')').ws();
        this.print(node.getBody());
    }

    private void print(WhileLoop node) throws IOException {
        this.writer.append("while").ws().append('(');
        this.print(node.getCondition());
        this.writer.append(')').ws();
        this.print(node.getBody());
    }

    private void print(IfStatement node) throws IOException {
        this.writer.append("if").ws().append('(');
        this.print(node.getCondition());
        this.writer.append(')').ws();
        this.print(node.getThenPart());
        if (node.getElsePart() != null) {
            this.writer.ws().append("else ");
            this.print(node.getElsePart());
        }
    }

    private void print(SwitchStatement node) throws IOException {
        this.writer.append("switch").ws().append('(');
        this.print(node.getExpression());
        this.writer.append(')').ws().append('{').indent().softNewLine();
        for (SwitchCase sc : node.getCases()) {
            if (sc.getExpression() == null) {
                this.writer.append("default:");
            } else {
                this.writer.append("case ");
                this.print(sc.getExpression());
                this.writer.append(':');
            }
            this.writer.indent().softNewLine();
            if (sc.getStatements() != null) {
                for (AstNode stmt : sc.getStatements()) {
                    this.print(stmt);
                    this.writer.softNewLine();
                }
            }
            this.writer.outdent();
        }
        this.writer.outdent().append('}');
    }

    private void print(TryStatement node) throws IOException {
        this.writer.append("try ");
        this.print(node.getTryBlock());
        for (CatchClause cc : node.getCatchClauses()) {
            this.writer.ws().append("catch").ws().append('(');
            this.print(cc.getVarName());
            if (cc.getCatchCondition() != null) {
                this.writer.append(" if ");
                this.print(cc.getCatchCondition());
            }
            this.writer.append(')');
            this.print(cc.getBody());
        }
        if (node.getFinallyBlock() != null) {
            this.writer.ws().append("finally ");
            this.print(node.getFinallyBlock());
        }
    }

    private void print(VariableDeclaration node) throws IOException {
        switch (node.getType()) {
            case 123: {
                this.writer.append("var ");
                break;
            }
            case 154: {
                this.writer.append("let ");
                break;
            }
            case 155: {
                this.writer.append("const ");
                break;
            }
        }
        this.print(node.getVariables().get(0));
        for (int i = 1; i < node.getVariables().size(); ++i) {
            this.writer.append(',').ws();
            this.print(node.getVariables().get(i));
        }
        if (node.isStatement()) {
            this.writer.append(';');
        }
    }

    private void print(VariableInitializer node) throws IOException {
        this.print(node.getTarget());
        if (node.getInitializer() != null) {
            this.writer.ws().append('=').ws();
            this.print(node.getInitializer());
        }
    }

    private void print(ExpressionStatement node) throws IOException {
        this.print(node.getExpression());
        this.writer.append(';');
    }

    private void print(ElementGet node) throws IOException {
        this.print(node.getTarget(), 2);
        this.writer.append('[');
        this.print(node.getElement());
        this.writer.append(']');
    }

    private void print(PropertyGet node) throws IOException {
        this.print(node.getLeft(), 2);
        this.writer.append('.');
        Map<String, NameEmitter> oldNameMap = this.nameMap;
        this.nameMap = Collections.emptyMap();
        this.print(node.getRight());
        this.nameMap = oldNameMap;
    }

    private void print(FunctionCall node, int precedence) throws IOException {
        NewExpression newExpr;
        int innerPrecedence;
        if (this.tryJavaInvocation(node)) {
            return;
        }
        if (precedence < 3) {
            this.writer.append('(');
        }
        int n = innerPrecedence = node instanceof NewExpression ? 2 : 3;
        if (node instanceof NewExpression) {
            this.writer.append("new ");
        }
        this.print(node.getTarget(), innerPrecedence);
        this.writer.append('(');
        this.printList(node.getArguments());
        this.writer.append(')');
        if (node instanceof NewExpression && (newExpr = (NewExpression)node).getInitializer() != null) {
            this.writer.ws();
            this.print(newExpr.getInitializer());
        }
        if (precedence < 3) {
            this.writer.append(')');
        }
    }

    private boolean tryJavaInvocation(FunctionCall node) throws IOException {
        if (!(node.getTarget() instanceof PropertyGet)) {
            return false;
        }
        PropertyGet propertyGet = (PropertyGet)node.getTarget();
        String callMethod = this.getJavaMethod(propertyGet.getTarget());
        if (callMethod == null || !propertyGet.getProperty().getIdentifier().equals("invoke")) {
            return false;
        }
        MethodReference method = MethodReference.parseIfPossible(callMethod);
        if (method == null) {
            return false;
        }
        this.writer.appendMethodBody(method).append('(');
        this.printList(node.getArguments());
        this.writer.append(')');
        return true;
    }

    private String getJavaMethod(AstNode node) {
        if (!(node instanceof StringLiteral)) {
            return null;
        }
        String str = ((StringLiteral)node).getValue();
        if (!str.startsWith("$$JSO$$_")) {
            return null;
        }
        return str.substring("$$JSO$$_".length());
    }

    private void print(ConditionalExpression node, int precedence) throws IOException {
        if (precedence < 16) {
            this.writer.append('(');
        }
        this.print(node.getTestExpression(), 15);
        this.writer.ws().append('?').ws();
        this.print(node.getTrueExpression(), 15);
        this.writer.ws().append(':').ws();
        this.print(node.getFalseExpression(), 16);
        if (precedence < 16) {
            this.writer.append(')');
        }
    }

    private void printList(List<? extends AstNode> nodes) throws IOException {
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        this.print(nodes.get(0));
        for (int i = 1; i < nodes.size(); ++i) {
            this.writer.append(',').ws();
            this.print(nodes.get(i));
        }
    }

    private void print(ArrayComprehension node) throws IOException {
        this.writer.append("[");
        for (ArrayComprehensionLoop loop : node.getLoops()) {
            this.writer.append("for").ws().append("(");
            this.print(loop.getIterator());
            this.writer.append(" of ");
            this.print(loop.getIteratedObject());
            this.writer.append(')');
        }
        if (node.getFilter() != null) {
            this.writer.append("if").ws().append("(");
            this.print(node.getFilter());
            this.writer.append(")");
        }
        this.print(node.getResult());
        this.writer.append(']');
    }

    private void print(GeneratorExpression node) throws IOException {
        this.writer.append("(");
        for (GeneratorExpressionLoop loop : node.getLoops()) {
            this.writer.append("for").ws().append("(");
            this.print(loop.getIterator());
            this.writer.append(" of ");
            this.print(loop.getIteratedObject());
            this.writer.append(')');
        }
        if (node.getFilter() != null) {
            this.writer.append("if").ws().append("(");
            this.print(node.getFilter());
            this.writer.append(")");
        }
        this.print(node.getResult());
        this.writer.append(')');
    }

    private void print(NumberLiteral node) throws IOException {
        this.writer.append(node.getValue());
    }

    private void print(StringLiteral node) throws IOException {
        this.writer.append(node.getQuoteCharacter());
        this.writer.append(ScriptRuntime.escapeString(node.getValue(), node.getQuoteCharacter()));
        this.writer.append(node.getQuoteCharacter());
    }

    private void print(Name node, int precedence) throws IOException {
        NameEmitter alias = this.nameMap.get(node.getIdentifier());
        if (alias == null) {
            alias = prec -> this.writer.append(node.getIdentifier());
        }
        alias.emit(precedence);
    }

    private void print(RegExpLiteral node) throws IOException {
        this.writer.append('/').append(node.getValue()).append('/').append(node.getFlags());
    }

    private void print(ArrayLiteral node) throws IOException {
        this.writer.append('[');
        this.printList(node.getElements());
        this.writer.append(']');
    }

    private void print(ObjectLiteral node) throws IOException {
        this.writer.append('{').ws();
        if (node.getElements() != null && !node.getElements().isEmpty()) {
            this.print(node.getElements().get(0));
            for (int i = 1; i < node.getElements().size(); ++i) {
                this.writer.append(',').ws();
                this.print(node.getElements().get(i));
            }
        }
        this.writer.ws().append('}');
    }

    private void print(ObjectProperty node) throws IOException {
        if (node.isGetterMethod()) {
            this.writer.append("get ");
        } else if (node.isSetterMethod()) {
            this.writer.append("set ");
        }
        Map<String, NameEmitter> oldNameMap = this.nameMap;
        this.nameMap = Collections.emptyMap();
        this.print(node.getLeft());
        this.nameMap = oldNameMap;
        if (!node.isMethod()) {
            this.writer.ws().append(':').ws();
        }
        this.print(node.getRight());
    }

    private void print(FunctionNode node) throws IOException {
        if (!node.isMethod()) {
            this.writer.append("function");
        }
        if (node.getFunctionName() != null) {
            this.writer.append(' ');
            this.print(node.getFunctionName());
        }
        this.writer.append('(');
        this.printList(node.getParams());
        this.writer.append(')').ws();
        if (node.isExpressionClosure()) {
            if (node.getBody().getLastChild() instanceof ReturnStatement) {
                this.print(((ReturnStatement)node.getBody().getLastChild()).getReturnValue());
                if (node.getFunctionType() == 1) {
                    this.writer.append(";");
                }
            }
        } else {
            this.print(node.getBody());
        }
    }

    private void print(LetNode node) throws IOException {
        this.writer.append("let").ws().append('(');
        this.printList(node.getVariables().getVariables());
        this.writer.append(')');
        this.print(node.getBody());
    }

    private void print(ParenthesizedExpression node, int precedence) throws IOException {
        this.print(node.getExpression(), precedence);
    }

    private void printUnary(UnaryExpression node, int precedence) throws IOException {
        int innerPrecedence;
        int n = innerPrecedence = node.isPostfix() ? 4 : 5;
        if (innerPrecedence > precedence) {
            this.writer.append('(');
        }
        if (!node.isPostfix()) {
            String op = AstNode.operatorToString(node.getType());
            if (op.startsWith("-")) {
                this.writer.append(' ');
            }
            this.writer.append(op);
            if (this.requiresWhitespaces(node.getType())) {
                this.writer.append(' ');
            }
        }
        this.print(node.getOperand(), innerPrecedence);
        if (node.isPostfix()) {
            this.writer.append(AstNode.operatorToString(node.getType()));
        }
        if (innerPrecedence > precedence) {
            this.writer.append(')');
        }
    }

    private void printInfix(InfixExpression node, int precedence) throws IOException {
        int rightPrecedence;
        int leftPrecedence;
        int innerPrecedence = this.getPrecedence(node.getType());
        if (innerPrecedence > precedence) {
            this.writer.append('(');
        }
        switch (node.getType()) {
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                leftPrecedence = innerPrecedence - 1;
                break;
            }
            default: {
                leftPrecedence = innerPrecedence;
            }
        }
        this.print(node.getLeft(), leftPrecedence);
        String op = AstNode.operatorToString(node.getType());
        boolean ws = this.requiresWhitespaces(node.getType());
        if (ws || op.startsWith("-")) {
            this.writer.append(' ');
        } else {
            this.writer.ws();
        }
        this.writer.append(op);
        if (ws) {
            this.writer.append(' ');
        } else {
            this.writer.ws();
        }
        switch (node.getType()) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 46: 
            case 47: 
            case 52: 
            case 53: {
                rightPrecedence = innerPrecedence - 1;
                break;
            }
            default: {
                rightPrecedence = innerPrecedence;
            }
        }
        this.print(node.getRight(), rightPrecedence);
        if (innerPrecedence > precedence) {
            this.writer.append(')');
        }
    }

    private int getPrecedence(int token) {
        switch (token) {
            case 23: 
            case 24: 
            case 25: {
                return 6;
            }
            case 21: 
            case 22: {
                return 7;
            }
            case 18: 
            case 19: 
            case 20: {
                return 8;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 52: 
            case 53: {
                return 9;
            }
            case 12: 
            case 13: 
            case 46: 
            case 47: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 10: {
                return 12;
            }
            case 9: {
                return 13;
            }
            case 106: {
                return 14;
            }
            case 105: {
                return 15;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return 17;
            }
        }
        return 18;
    }

    private boolean requiresWhitespaces(int token) {
        switch (token) {
            case 31: 
            case 32: 
            case 52: 
            case 53: 
            case 70: 
            case 127: {
                return true;
            }
        }
        return false;
    }
}

