/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.codegen;

import java.util.HashMap;
import java.util.Map;
import org.teavm.backend.javascript.codegen.AliasProvider;
import org.teavm.backend.javascript.codegen.NamingStrategy;
import org.teavm.backend.javascript.codegen.ScopedName;
import org.teavm.model.AccessLevel;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;

public class DefaultNamingStrategy
implements NamingStrategy {
    private static final byte NO_CLASSIFIER = 0;
    private static final byte INIT_CLASSIFIER = 1;
    private final AliasProvider aliasProvider;
    private final ClassReaderSource classSource;
    private final Map<MethodDescriptor, String> aliases = new HashMap<MethodDescriptor, String>();
    private final Map<Key, ScopedName> privateAliases = new HashMap<Key, ScopedName>();
    private final Map<String, ScopedName> classAliases = new HashMap<String, ScopedName>();
    private final Map<FieldReference, String> fieldAliases = new HashMap<FieldReference, String>();
    private final Map<FieldReference, ScopedName> staticFieldAliases = new HashMap<FieldReference, ScopedName>();
    private final Map<String, String> functionAliases = new HashMap<String, String>();
    private final Map<String, ScopedName> classInitAliases = new HashMap<String, ScopedName>();
    private String scopeName;

    public DefaultNamingStrategy(AliasProvider aliasProvider, ClassReaderSource classSource) {
        this.aliasProvider = aliasProvider;
        this.classSource = classSource;
    }

    @Override
    public ScopedName getNameFor(String cls) {
        return this.classAliases.computeIfAbsent(cls, key -> this.aliasProvider.getClassAlias(cls));
    }

    @Override
    public String getNameFor(MethodDescriptor method) {
        String alias = this.aliases.get(method);
        if (alias == null) {
            alias = this.aliasProvider.getMethodAlias(method);
            this.aliases.put(method, alias);
        }
        return alias;
    }

    @Override
    public ScopedName getFullNameFor(MethodReference method) {
        return this.getFullNameFor(method, (byte)0);
    }

    @Override
    public ScopedName getNameForInit(MethodReference method) {
        return this.getFullNameFor(method, (byte)1);
    }

    private ScopedName getFullNameFor(MethodReference method, byte classifier) {
        MethodReference originalMethod = method;
        if ((method = this.getRealMethod(method)) == null) {
            method = originalMethod;
        }
        return this.privateAliases.computeIfAbsent(new Key(classifier, method), key -> this.aliasProvider.getStaticMethodAlias(key.data));
    }

    @Override
    public String getNameFor(FieldReference field) {
        String alias = this.fieldAliases.get(field);
        if (alias == null) {
            FieldReference realField = this.getRealField(field);
            alias = realField.equals(field) ? this.aliasProvider.getFieldAlias(realField) : this.getNameFor(realField);
            this.fieldAliases.put(field, alias);
        }
        return alias;
    }

    @Override
    public ScopedName getFullNameFor(FieldReference field) {
        ScopedName alias = this.staticFieldAliases.get(field);
        if (alias == null) {
            FieldReference realField = this.getRealField(field);
            alias = realField.equals(field) ? this.aliasProvider.getStaticFieldAlias(realField) : this.getFullNameFor(realField);
            this.staticFieldAliases.put(field, alias);
        }
        return alias;
    }

    @Override
    public String getNameForFunction(String name) {
        return this.functionAliases.computeIfAbsent(name, key -> this.aliasProvider.getFunctionAlias((String)key));
    }

    @Override
    public ScopedName getNameForClassInit(String className) {
        return this.classInitAliases.computeIfAbsent(className, key -> this.aliasProvider.getClassInitAlias((String)key));
    }

    @Override
    public String getScopeName() {
        if (this.scopeName == null) {
            this.scopeName = this.aliasProvider.getScopeAlias();
        }
        return this.scopeName;
    }

    private MethodReference getRealMethod(MethodReference methodRef) {
        String className = methodRef.getClassName();
        while (className != null) {
            ClassReader cls = this.classSource.get(className);
            if (cls == null) {
                return null;
            }
            MethodReader method = cls.getMethod(methodRef.getDescriptor());
            if (method != null) {
                if (method.getLevel() == AccessLevel.PRIVATE && !className.equals(methodRef.getClassName())) {
                    return null;
                }
                return method.getReference();
            }
            className = cls.getParent();
        }
        return null;
    }

    private FieldReference getRealField(FieldReference fieldRef) {
        ClassReader clsReader;
        String cls = fieldRef.getClassName();
        while (cls != null && (clsReader = this.classSource.get(cls)) != null) {
            FieldReader fieldReader = clsReader.getField(fieldRef.getFieldName());
            if (fieldReader != null) {
                return fieldReader.getReference();
            }
            cls = clsReader.getParent();
        }
        return fieldRef;
    }

    static final class Key {
        final MethodReference data;
        int hash;
        final byte classifier;

        Key(byte classifier, MethodReference data) {
            this.classifier = classifier;
            this.data = data;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            return this.classifier == key.classifier && this.data.equals(key.data);
        }

        public int hashCode() {
            if (this.hash == 0) {
                this.hash = (this.classifier * 31 + this.data.hashCode()) * 17;
                if (this.hash == 0) {
                    ++this.hash;
                }
            }
            return this.hash;
        }
    }
}

