/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.c.intrinsic;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.c.intrinsic.Intrinsic;
import org.teavm.backend.c.intrinsic.IntrinsicContext;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReference;
import org.teavm.runtime.Allocator;
import org.teavm.runtime.RuntimeClass;

public class AllocatorIntrinsic
implements Intrinsic {
    private static final FieldReference FLAGS_FIELD = new FieldReference(RuntimeClass.class.getName(), "flags");

    @Override
    public boolean canHandle(MethodReference method) {
        if (!method.getClassName().equals(Allocator.class.getName())) {
            return false;
        }
        switch (method.getName()) {
            case "fillZero": 
            case "fill": 
            case "moveMemoryBlock": 
            case "isInitialized": {
                return true;
            }
        }
        return false;
    }

    @Override
    public void apply(IntrinsicContext context, InvocationExpr invocation) {
        switch (invocation.getMethod().getName()) {
            case "fillZero": {
                context.includes().addInclude("<string.h>");
                context.writer().print("memset(");
                context.emit(invocation.getArguments().get(0));
                context.writer().print(", 0, ");
                context.emit(invocation.getArguments().get(1));
                context.writer().print(")");
                break;
            }
            case "fill": {
                context.includes().addInclude("<string.h>");
                context.writer().print("memset(");
                context.emit(invocation.getArguments().get(0));
                context.writer().print(", ");
                context.emit(invocation.getArguments().get(1));
                context.writer().print(", ");
                context.emit(invocation.getArguments().get(2));
                context.writer().print(")");
                break;
            }
            case "moveMemoryBlock": {
                context.includes().addInclude("<string.h>");
                context.writer().print("memmove(");
                context.emit(invocation.getArguments().get(1));
                context.writer().print(", ");
                context.emit(invocation.getArguments().get(0));
                context.writer().print(", ");
                context.emit(invocation.getArguments().get(2));
                context.writer().print(")");
                break;
            }
            case "isInitialized": {
                context.writer().print("(((TeaVM_Class *) ");
                context.emit(invocation.getArguments().get(0));
                context.writer().print(")->").print(context.names().forMemberField(FLAGS_FIELD)).print(" & INT32_C(1))");
            }
        }
    }
}

