/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.c.generate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.teavm.backend.c.generate.FileNameProvider;
import org.teavm.model.ValueType;

public class ShorteningFileNameProvider
implements FileNameProvider {
    private final FileNameProvider nameProvider;
    private final Map<String, String> names = new HashMap<String, String>();
    private final Set<String> usedNames = new HashSet<String>();

    public ShorteningFileNameProvider(FileNameProvider nameProvider) {
        this.nameProvider = nameProvider;
    }

    @Override
    public String fileName(String className) {
        return this.unique(ShorteningFileNameProvider.shorten(this.nameProvider.fileName(className)));
    }

    @Override
    public String fileName(ValueType type) {
        return this.unique(ShorteningFileNameProvider.shorten(this.nameProvider.fileName(type)));
    }

    @Override
    public String escapeName(String name) {
        return this.unique(ShorteningFileNameProvider.shorten(this.nameProvider.escapeName(name)));
    }

    private String unique(String name) {
        return this.names.computeIfAbsent(name, n -> {
            String candidate;
            if (this.usedNames.add((String)n)) {
                return n;
            }
            int suffix = 1;
            while (!this.usedNames.add(candidate = n + "_" + suffix++)) {
            }
            return candidate;
        });
    }

    private static String shorten(String name) {
        int next;
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while ((next = name.indexOf(47, index)) >= 0) {
            if (next > index) {
                sb.append(name.charAt(index));
            }
            sb.append('/');
            index = next + 1;
        }
        return sb.append(name, index, name.length()).toString();
    }
}

