/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.vm;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.teavm.cache.AlwaysStaleCacheStatus;
import org.teavm.cache.AnnotationAwareCacheStatus;
import org.teavm.cache.CacheStatus;
import org.teavm.cache.EmptyProgramCache;
import org.teavm.cache.ProgramDependencyExtractor;
import org.teavm.common.ServiceRepository;
import org.teavm.dependency.BootstrapMethodSubstitutor;
import org.teavm.dependency.ClassSourcePacker;
import org.teavm.dependency.DependencyAnalyzer;
import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.DependencyListener;
import org.teavm.dependency.DependencyPlugin;
import org.teavm.dependency.Linker;
import org.teavm.dependency.MethodDependency;
import org.teavm.diagnostics.AccumulationDiagnostics;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.diagnostics.ProblemProvider;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.FieldReference;
import org.teavm.model.Instruction;
import org.teavm.model.ListableClassHolderSource;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.MutableClassHolderSource;
import org.teavm.model.Program;
import org.teavm.model.ProgramCache;
import org.teavm.model.ValueType;
import org.teavm.model.analysis.ClassInitializerAnalysis;
import org.teavm.model.analysis.ClassInitializerInfo;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.optimization.ArrayUnwrapMotion;
import org.teavm.model.optimization.ClassInitElimination;
import org.teavm.model.optimization.ConstantConditionElimination;
import org.teavm.model.optimization.DefaultInliningStrategy;
import org.teavm.model.optimization.Devirtualization;
import org.teavm.model.optimization.GlobalValueNumbering;
import org.teavm.model.optimization.Inlining;
import org.teavm.model.optimization.LoopInvariantMotion;
import org.teavm.model.optimization.MethodOptimization;
import org.teavm.model.optimization.MethodOptimizationContext;
import org.teavm.model.optimization.RedundantJumpElimination;
import org.teavm.model.optimization.RedundantNullCheckElimination;
import org.teavm.model.optimization.ScalarReplacement;
import org.teavm.model.optimization.UnreachableBasicBlockElimination;
import org.teavm.model.optimization.UnusedVariableElimination;
import org.teavm.model.text.ListingBuilder;
import org.teavm.model.transformation.ClassInitializerInsertionTransformer;
import org.teavm.model.util.MissingItemsProcessor;
import org.teavm.model.util.ModelUtils;
import org.teavm.model.util.ProgramUtils;
import org.teavm.model.util.RegisterAllocator;
import org.teavm.vm.BuildTarget;
import org.teavm.vm.DirectoryBuildTarget;
import org.teavm.vm.TeaVMBuilder;
import org.teavm.vm.TeaVMEntryPoint;
import org.teavm.vm.TeaVMOptimizationLevel;
import org.teavm.vm.TeaVMPhase;
import org.teavm.vm.TeaVMPluginLoader;
import org.teavm.vm.TeaVMProgressFeedback;
import org.teavm.vm.TeaVMProgressListener;
import org.teavm.vm.TeaVMTarget;
import org.teavm.vm.TeaVMTargetController;
import org.teavm.vm.spi.TeaVMHost;
import org.teavm.vm.spi.TeaVMHostExtension;
import org.teavm.vm.spi.TeaVMPlugin;

public class TeaVM
implements TeaVMHost,
ServiceRepository {
    private static final MethodDescriptor MAIN_METHOD_DESC = new MethodDescriptor("main", ValueType.arrayOf(ValueType.object("java.lang.String")), ValueType.VOID);
    private final DependencyAnalyzer dependencyAnalyzer;
    private final AccumulationDiagnostics diagnostics = new AccumulationDiagnostics();
    private final ClassLoader classLoader;
    private final Map<String, TeaVMEntryPoint> entryPoints = new LinkedHashMap<String, TeaVMEntryPoint>();
    private final Map<String, TeaVMEntryPoint> readonlyEntryPoints = Collections.unmodifiableMap(this.entryPoints);
    private final Set<String> preservedClasses = new HashSet<String>();
    private final Set<String> readonlyPreservedClasses = Collections.unmodifiableSet(this.preservedClasses);
    private final Map<Class<?>, Object> services = new HashMap();
    private final Properties properties = new Properties();
    private ProgramCache programCache = EmptyProgramCache.INSTANCE;
    private CacheStatus rawCacheStatus = AlwaysStaleCacheStatus.INSTANCE;
    private TeaVMOptimizationLevel optimizationLevel = TeaVMOptimizationLevel.SIMPLE;
    private TeaVMProgressListener progressListener;
    private boolean cancelled;
    private ListableClassHolderSource writtenClasses;
    private TeaVMTarget target;
    private Map<Class<?>, TeaVMHostExtension> extensions = new HashMap();
    private Set<? extends MethodReference> virtualMethods;
    private AnnotationAwareCacheStatus cacheStatus;
    private ProgramDependencyExtractor programDependencyExtractor = new ProgramDependencyExtractor();
    private List<Predicate<MethodReference>> additionalVirtualMethods = new ArrayList<Predicate<MethodReference>>();
    private int lastKnownClasses;
    private int compileProgressReportStart;
    private int compileProgressReportLimit;
    private int compileProgressLimit;
    private int compileProgressValue;
    private ClassSourcePacker classSourcePacker;
    private ClassInitializerInfo classInitializerInfo;
    private TeaVMTargetController targetController = new TeaVMTargetController(){

        @Override
        public boolean wasCancelled() {
            return TeaVM.this.wasCancelled();
        }

        @Override
        public ClassLoader getClassLoader() {
            return TeaVM.this.classLoader;
        }

        @Override
        public ClassReaderSource getUnprocessedClassSource() {
            return TeaVM.this.dependencyAnalyzer.getClassSource();
        }

        @Override
        public CacheStatus getCacheStatus() {
            return TeaVM.this.cacheStatus;
        }

        @Override
        public DependencyInfo getDependencyInfo() {
            return TeaVM.this.dependencyAnalyzer;
        }

        @Override
        public Diagnostics getDiagnostics() {
            return TeaVM.this.diagnostics;
        }

        @Override
        public Properties getProperties() {
            return TeaVM.this.properties;
        }

        @Override
        public ServiceRepository getServices() {
            return TeaVM.this;
        }

        public Map<String, TeaVMEntryPoint> getEntryPoints() {
            return TeaVM.this.readonlyEntryPoints;
        }

        public Set<String> getPreservedClasses() {
            return TeaVM.this.readonlyPreservedClasses;
        }

        @Override
        public boolean isFriendlyToDebugger() {
            return TeaVM.this.optimizationLevel == TeaVMOptimizationLevel.SIMPLE;
        }

        @Override
        public boolean isVirtual(MethodReference method) {
            return TeaVM.this.isVirtual(method);
        }

        @Override
        public TeaVMProgressFeedback reportProgress(int progress) {
            progress = progress * (TeaVM.this.compileProgressReportLimit - TeaVM.this.compileProgressReportStart) / 1000 + TeaVM.this.compileProgressReportStart;
            return TeaVM.this.progressListener.progressReached(progress);
        }

        @Override
        public void addVirtualMethods(Predicate<MethodReference> methods) {
            TeaVM.this.addVirtualMethods(methods);
        }

        @Override
        public ClassInitializerInfo getClassInitializerInfo() {
            return TeaVM.this.classInitializerInfo;
        }

        @Override
        public TeaVMOptimizationLevel getOptimizationLevel() {
            return TeaVM.this.optimizationLevel;
        }
    };

    TeaVM(TeaVMBuilder builder) {
        this.target = builder.target;
        this.classLoader = builder.classLoader;
        this.classSourcePacker = builder.classSourcePacker;
        this.dependencyAnalyzer = builder.dependencyAnalyzerFactory.create(builder.classSource, this.classLoader, this, this.diagnostics, builder.referenceCache);
        this.progressListener = new TeaVMProgressListener(){

            @Override
            public TeaVMProgressFeedback progressReached(int progress) {
                return TeaVMProgressFeedback.CONTINUE;
            }

            @Override
            public TeaVMProgressFeedback phaseStarted(TeaVMPhase phase, int count) {
                return TeaVMProgressFeedback.CONTINUE;
            }
        };
        for (ClassHolderTransformer transformer : this.target.getTransformers()) {
            this.dependencyAnalyzer.addClassTransformer(transformer);
        }
        for (DependencyListener listener : this.target.getDependencyListeners()) {
            this.dependencyAnalyzer.addDependencyListener(listener);
        }
        for (TeaVMHostExtension extension : this.target.getHostExtensions()) {
            for (Class<? extends TeaVMHostExtension> extensionType : this.getExtensionTypes(extension)) {
                this.extensions.put(extensionType, extension);
            }
        }
    }

    public void addVirtualMethods(Predicate<MethodReference> virtualMethods) {
        this.additionalVirtualMethods.add(virtualMethods);
    }

    @Override
    public void add(DependencyListener listener) {
        this.dependencyAnalyzer.addDependencyListener(listener);
    }

    @Override
    public void add(ClassHolderTransformer transformer) {
        this.dependencyAnalyzer.addClassTransformer(transformer);
    }

    @Override
    public void add(MethodReference methodRef, BootstrapMethodSubstitutor substitutor) {
        this.dependencyAnalyzer.addBootstrapMethodSubstitutor(methodRef, substitutor);
    }

    @Override
    public void add(MethodReference methodRef, DependencyPlugin dependencyPlugin) {
        this.dependencyAnalyzer.addDependencyPlugin(methodRef, dependencyPlugin);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setProperties(Properties properties) {
        this.properties.clear();
        if (properties != null) {
            this.properties.putAll((Map<?, ?>)properties);
        }
    }

    @Override
    public Properties getProperties() {
        return new Properties(this.properties);
    }

    public ProgramCache getProgramCache() {
        return this.programCache;
    }

    public void setProgramCache(ProgramCache programCache) {
        this.programCache = programCache;
    }

    public void setCacheStatus(CacheStatus cacheStatus) {
        this.rawCacheStatus = cacheStatus;
    }

    public TeaVMOptimizationLevel getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public void setOptimizationLevel(TeaVMOptimizationLevel optimizationLevel) {
        this.optimizationLevel = optimizationLevel;
    }

    public TeaVMProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setProgressListener(TeaVMProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public ProblemProvider getProblemProvider() {
        return this.diagnostics;
    }

    @Override
    public String[] getPlatformTags() {
        return this.target.getPlatformTags();
    }

    public void entryPoint(String className, String name) {
        if (this.entryPoints.containsKey(name)) {
            throw new IllegalArgumentException("Entry point with public name `" + name + "' already defined for class " + className);
        }
        ClassReader cls = this.dependencyAnalyzer.getClassSource().get(className);
        if (cls == null) {
            this.diagnostics.error(null, "There's no main class: '{{c0}}'", className);
            return;
        }
        if (cls.getMethod(MAIN_METHOD_DESC) == null) {
            this.diagnostics.error(null, "Specified main class '{{c0}}' does not have method '" + MAIN_METHOD_DESC + "'", cls.getName());
            return;
        }
        MethodDependency mainMethod = this.dependencyAnalyzer.linkMethod(new MethodReference(className, "main", ValueType.parse(String[].class), ValueType.VOID));
        TeaVMEntryPoint entryPoint = new TeaVMEntryPoint(name, mainMethod);
        this.dependencyAnalyzer.defer(() -> {
            this.dependencyAnalyzer.linkClass(className).initClass(null);
            mainMethod.getVariable(1).propagate(this.dependencyAnalyzer.getType("[Ljava/lang/String;"));
            mainMethod.getVariable(1).getArrayItem().propagate(this.dependencyAnalyzer.getType("java.lang.String"));
            mainMethod.use();
        });
        this.entryPoints.put(name, entryPoint);
    }

    public void entryPoint(String className) {
        this.entryPoint(className, "main");
    }

    public void preserveType(String className) {
        this.dependencyAnalyzer.defer(() -> this.dependencyAnalyzer.linkClass(className).initClass(null));
        this.preservedClasses.add(className);
    }

    public ClassReaderSource getDependencyClassSource() {
        return this.dependencyAnalyzer.getClassSource();
    }

    public Collection<String> getClasses() {
        return this.dependencyAnalyzer.getReachableClasses();
    }

    public Collection<MethodReference> getMethods() {
        return this.dependencyAnalyzer.getReachableMethods();
    }

    public DependencyInfo getDependencyInfo() {
        return this.dependencyAnalyzer;
    }

    public ListableClassReaderSource getWrittenClasses() {
        return this.writtenClasses;
    }

    public void setLastKnownClasses(int lastKnownClasses) {
        this.lastKnownClasses = lastKnownClasses;
    }

    public void build(BuildTarget buildTarget, String outputName) {
        ListableClassHolderSource classSet;
        boolean isLazy;
        this.reportPhase(TeaVMPhase.DEPENDENCY_ANALYSIS, this.lastKnownClasses > 0 ? this.lastKnownClasses : 1);
        if (this.wasCancelled()) {
            return;
        }
        this.dependencyAnalyzer.setAsyncSupported(this.target.isAsyncSupported());
        this.dependencyAnalyzer.setInterruptor(() -> {
            int progress = this.lastKnownClasses > 0 ? this.dependencyAnalyzer.getReachableClasses().size() : 0;
            this.cancelled |= this.progressListener.progressReached(progress) != TeaVMProgressFeedback.CONTINUE;
            return !this.cancelled;
        });
        this.target.contributeDependencies(this.dependencyAnalyzer);
        this.dependencyAnalyzer.processDependencies();
        if (this.wasCancelled() || !this.diagnostics.getSevereProblems().isEmpty()) {
            return;
        }
        this.dependencyAnalyzer.setInterruptor(null);
        this.dependencyAnalyzer.cleanup(this.classSourcePacker);
        this.cacheStatus = new AnnotationAwareCacheStatus(this.rawCacheStatus, this.dependencyAnalyzer.getIncrementalDependencies(), this.dependencyAnalyzer.getClassSource());
        this.cacheStatus.addSynthesizedClasses(this.dependencyAnalyzer::isSynthesizedClass);
        if (this.wasCancelled()) {
            return;
        }
        boolean bl = isLazy = this.optimizationLevel == TeaVMOptimizationLevel.SIMPLE;
        if (isLazy) {
            this.classInitializerInfo = ClassInitializerInfo.EMPTY;
            this.target.setController(this.targetController);
            this.target.analyzeBeforeOptimizations(new ListableClassReaderSourceAdapter(this.dependencyAnalyzer.getClassSource(), new LinkedHashSet<String>(this.dependencyAnalyzer.getReachableClasses())));
            this.initCompileProgress(1000);
            classSet = this.lazyPipeline();
        } else {
            this.initCompileProgress(500);
            classSet = this.eagerPipeline();
            if (this.wasCancelled()) {
                return;
            }
        }
        if (this.wasCancelled()) {
            return;
        }
        try {
            if (!isLazy) {
                this.compileProgressReportStart = 500;
                this.compileProgressReportLimit = 1000;
            }
            this.target.emit(classSet, buildTarget, outputName);
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating output files", e);
        }
    }

    private void initCompileProgress(int limit) {
        this.reportPhase(TeaVMPhase.COMPILING, 1000);
        this.compileProgressReportStart = 0;
        this.compileProgressReportLimit = limit;
    }

    private ListableClassHolderSource eagerPipeline() {
        ListableClassHolderSource classSet;
        this.compileProgressValue = 0;
        this.compileProgressLimit = this.dependencyAnalyzer.getReachableClasses().size();
        this.compileProgressLimit = this.optimizationLevel == TeaVMOptimizationLevel.ADVANCED ? (this.compileProgressLimit *= 4) : (this.compileProgressLimit *= 2);
        this.writtenClasses = classSet = this.link(this.dependencyAnalyzer);
        if (this.wasCancelled()) {
            return null;
        }
        if (this.optimizationLevel != TeaVMOptimizationLevel.SIMPLE) {
            this.devirtualize(classSet);
            if (this.wasCancelled()) {
                return null;
            }
            ClassInitializerAnalysis classInitializerAnalysis = new ClassInitializerAnalysis(classSet, this.dependencyAnalyzer.getClassHierarchy());
            classInitializerAnalysis.analyze(this.dependencyAnalyzer);
            this.classInitializerInfo = classInitializerAnalysis;
            this.insertClassInit(classSet);
            this.eliminateClassInit(classSet);
        } else {
            this.insertClassInit(classSet);
            this.classInitializerInfo = ClassInitializerInfo.EMPTY;
        }
        this.dependencyAnalyzer.cleanupTypes();
        this.inline(classSet);
        if (this.wasCancelled()) {
            return null;
        }
        this.target.setController(this.targetController);
        this.target.analyzeBeforeOptimizations(new ListableClassReaderSourceAdapter(this.dependencyAnalyzer.getClassSource(), new LinkedHashSet<String>(this.dependencyAnalyzer.getReachableClasses())));
        this.optimize(classSet);
        if (this.wasCancelled()) {
            return null;
        }
        return classSet;
    }

    private ListableClassHolderSource lazyPipeline() {
        return new PostProcessingClassHolderSource();
    }

    private void insertClassInit(ListableClassHolderSource classes) {
        ClassInitializerInsertionTransformer clinitInsertion = new ClassInitializerInsertionTransformer(this.dependencyAnalyzer.getClassSource(), this.classInitializerInfo);
        for (String className : classes.getClassNames()) {
            ClassHolder cls = classes.get(className);
            for (MethodHolder method : cls.getMethods()) {
                Program program = method.getProgram();
                if (program == null) continue;
                clinitInsertion.apply(method, program);
            }
        }
    }

    private void eliminateClassInit(ListableClassHolderSource classes) {
        for (String className : classes.getClassNames()) {
            ClassHolder cls = classes.get(className);
            for (MethodHolder method : cls.getMethods()) {
                Program program = method.getProgram();
                if (program == null) continue;
                for (BasicBlock block : program.getBasicBlocks()) {
                    for (Instruction instruction : block) {
                        InitClassInstruction clinit;
                        if (!(instruction instanceof InitClassInstruction) || this.classInitializerInfo.isDynamicInitializer((clinit = (InitClassInstruction)instruction).getClassName())) continue;
                        clinit.delete();
                    }
                }
            }
        }
        for (TeaVMEntryPoint entryPoint : this.entryPoints.values()) {
            this.addInitializersToEntryPoint(classes, entryPoint.getMethod());
        }
    }

    private void addInitializersToEntryPoint(ClassHolderSource classes, MethodReference methodRef) {
        ClassHolder cls = classes.get(methodRef.getClassName());
        if (cls == null) {
            return;
        }
        MethodHolder method = cls.getMethod(methodRef.getDescriptor());
        if (method == null) {
            return;
        }
        Program program = method.getProgram();
        BasicBlock block = program.basicBlockAt(0);
        Instruction first = block.getFirstInstruction();
        for (String string : this.classInitializerInfo.getInitializationOrder()) {
            InvokeInstruction invoke = new InvokeInstruction();
            invoke.setMethod(new MethodReference(string, "<clinit>", ValueType.VOID));
            first.insertPrevious(invoke);
        }
    }

    public ListableClassHolderSource link(DependencyAnalyzer dependency) {
        Linker linker = new Linker(dependency);
        MutableClassHolderSource cutClasses = new MutableClassHolderSource();
        MissingItemsProcessor missingItemsProcessor = new MissingItemsProcessor(dependency, dependency.getClassHierarchy(), this.diagnostics, this.target.getPlatformTags());
        if (this.wasCancelled()) {
            return cutClasses;
        }
        if (this.wasCancelled()) {
            return cutClasses;
        }
        for (String className : dependency.getReachableClasses()) {
            ClassReader clsReader = dependency.getClassSource().get(className);
            if (clsReader != null) {
                ClassHolder cls = ModelUtils.copyClass(clsReader);
                cutClasses.putClassHolder(cls);
                missingItemsProcessor.processClass(cls);
                linker.link(cls);
            }
            this.reportCompileProgress(++this.compileProgressValue);
            if (!this.wasCancelled()) continue;
            break;
        }
        return cutClasses;
    }

    private void reportPhase(TeaVMPhase phase, int progressLimit) {
        if (this.progressListener.phaseStarted(phase, progressLimit) == TeaVMProgressFeedback.CANCEL) {
            this.cancelled = true;
        }
    }

    private void reportProgress(int progress) {
        if (this.progressListener.progressReached(progress) == TeaVMProgressFeedback.CANCEL) {
            this.cancelled = true;
        }
    }

    private void reportCompileProgress(int progress) {
        this.reportProgress(this.compileProgressReportStart + progress * (this.compileProgressReportLimit - this.compileProgressReportStart) / this.compileProgressLimit);
    }

    private void devirtualize(ListableClassHolderSource classes) {
        if (this.wasCancelled()) {
            return;
        }
        Devirtualization devirtualization = new Devirtualization(this.dependencyAnalyzer, this.dependencyAnalyzer.getClassHierarchy());
        for (String className : classes.getClassNames()) {
            ClassHolder cls = classes.get(className);
            for (MethodHolder method : cls.getMethods()) {
                if (method.getProgram() == null) continue;
                devirtualization.apply(method);
            }
            this.reportCompileProgress(++this.compileProgressValue);
            if (!this.wasCancelled()) continue;
            break;
        }
        this.virtualMethods = devirtualization.getVirtualMethods();
    }

    private void inline(ListableClassHolderSource classes) {
        if (this.optimizationLevel == TeaVMOptimizationLevel.SIMPLE) {
            return;
        }
        DefaultInliningStrategy inliningStrategy = this.optimizationLevel == TeaVMOptimizationLevel.FULL ? new DefaultInliningStrategy(14, 7, 300, false) : new DefaultInliningStrategy(100, 7, 300, true);
        Inlining inlining = new Inlining(new ClassHierarchy(classes), this.dependencyAnalyzer, inliningStrategy, classes, this::isExternal, this.optimizationLevel == TeaVMOptimizationLevel.FULL);
        List<MethodReference> methodReferences = inlining.getOrder();
        int classCount = classes.getClassNames().size();
        int initialValue = this.compileProgressValue;
        for (int i = 0; i < methodReferences.size(); ++i) {
            int newProgress;
            MethodHolder method;
            MethodReference methodReference = methodReferences.get(i);
            ClassHolder cls = classes.get(methodReference.getClassName());
            if (cls == null || (method = cls.getMethod(methodReference.getDescriptor())) == null) continue;
            if (method.getProgram() != null) {
                if (!inlining.hasUsages(methodReference)) {
                    inlining.removeUsages(method.getProgram());
                    method.setProgram(null);
                } else {
                    Program program = method.getProgram();
                    MethodOptimizationContextImpl context = new MethodOptimizationContextImpl(method);
                    inlining.apply(program, method.getReference());
                    new UnusedVariableElimination().optimize(context, program);
                }
            }
            if ((newProgress = initialValue + classCount * i / methodReferences.size()) <= this.compileProgressValue) continue;
            this.compileProgressValue = newProgress;
            this.reportCompileProgress(++this.compileProgressValue);
            if (this.wasCancelled()) break;
        }
    }

    private void optimize(ListableClassHolderSource classSource) {
        for (String className : classSource.getClassNames()) {
            ClassHolder cls = classSource.get(className);
            for (MethodHolder method : cls.getMethods()) {
                this.optimizeMethod(method);
            }
            this.reportCompileProgress(++this.compileProgressValue);
            if (!this.wasCancelled()) continue;
            break;
        }
    }

    private void optimizeMethod(MethodHolder method) {
        Program optimizedProgram;
        if (method.getProgram() == null) {
            return;
        }
        Program program = optimizedProgram = !this.cacheStatus.isStaleMethod(method.getReference()) ? this.programCache.get(method.getReference(), this.cacheStatus) : null;
        if (optimizedProgram == null) {
            Program finalProgram = optimizedProgram = this.optimizeMethodCacheMiss(method, ProgramUtils.copy(method.getProgram()));
            this.programCache.store(method.getReference(), finalProgram, () -> this.programDependencyExtractor.extractDependencies(finalProgram));
        }
        method.setProgram(optimizedProgram);
    }

    private Program optimizeMethodCacheMiss(MethodHolder method, Program optimizedProgram) {
        this.target.beforeOptimizations(optimizedProgram, method);
        if (optimizedProgram.basicBlockCount() > 0) {
            boolean changed;
            MethodOptimizationContextImpl context = new MethodOptimizationContextImpl(method);
            do {
                changed = false;
                for (MethodOptimization optimization : this.getOptimizations()) {
                    try {
                        changed |= optimization.optimize(context, optimizedProgram);
                    }
                    catch (AssertionError | Exception e) {
                        ListingBuilder listingBuilder = new ListingBuilder();
                        try {
                            String listing = listingBuilder.buildListing(optimizedProgram, "");
                            System.err.println("Error optimizing program for method " + method.getReference() + ":\n" + listing);
                        }
                        catch (RuntimeException e2) {
                            System.err.println("Error optimizing program for method " + method.getReference());
                        }
                        throw new RuntimeException((Throwable)e);
                    }
                }
            } while (changed);
            this.target.afterOptimizations(optimizedProgram, method);
            if (this.target.requiresRegisterAllocation()) {
                RegisterAllocator allocator = new RegisterAllocator();
                allocator.allocateRegisters(method.getReference(), optimizedProgram, this.optimizationLevel == TeaVMOptimizationLevel.SIMPLE);
            }
        }
        return optimizedProgram;
    }

    private List<MethodOptimization> getOptimizations() {
        ArrayList<MethodOptimization> optimizations = new ArrayList<MethodOptimization>();
        optimizations.add(new RedundantJumpElimination());
        optimizations.add(new ArrayUnwrapMotion());
        if (this.optimizationLevel.ordinal() >= TeaVMOptimizationLevel.ADVANCED.ordinal()) {
            optimizations.add(new ScalarReplacement());
            optimizations.add(new LoopInvariantMotion());
        }
        optimizations.add(new GlobalValueNumbering(this.optimizationLevel == TeaVMOptimizationLevel.SIMPLE));
        optimizations.add(new RedundantNullCheckElimination());
        if (this.optimizationLevel.ordinal() >= TeaVMOptimizationLevel.ADVANCED.ordinal()) {
            optimizations.add(new ConstantConditionElimination());
            optimizations.add(new RedundantJumpElimination());
            optimizations.add(new UnusedVariableElimination());
        }
        optimizations.add(new ClassInitElimination());
        optimizations.add(new UnreachableBasicBlockElimination());
        optimizations.add(new UnusedVariableElimination());
        return optimizations;
    }

    public void build(File dir, String fileName) {
        this.build(new DirectoryBuildTarget(dir), fileName);
    }

    public void installPlugins() {
        for (TeaVMPlugin plugin : TeaVMPluginLoader.load(this.classLoader)) {
            plugin.install(this);
        }
    }

    @Override
    public <T> T getService(Class<T> type) {
        Object service = this.services.get(type);
        if (service == null) {
            throw new IllegalArgumentException("Service not registered: " + type.getName());
        }
        return type.cast(service);
    }

    @Override
    public <T> void registerService(Class<T> type, T instance) {
        this.services.put(type, instance);
    }

    @Override
    public <T extends TeaVMHostExtension> T getExtension(Class<T> extensionType) {
        TeaVMHostExtension extension = this.extensions.get(extensionType);
        return (T)(extension != null ? (TeaVMHostExtension)extensionType.cast(extension) : null);
    }

    private Collection<Class<? extends TeaVMHostExtension>> getExtensionTypes(TeaVMHostExtension extension) {
        return Arrays.stream(extension.getClass().getInterfaces()).filter(cls -> cls.isInterface() && TeaVMHostExtension.class.isAssignableFrom((Class<?>)cls)).map(cls -> cls.asSubclass(TeaVMHostExtension.class)).collect(Collectors.toSet());
    }

    boolean isExternal(MethodReference method) {
        MethodDependency dep = this.dependencyAnalyzer.getMethod(method);
        if (dep != null && dep.isCalled()) {
            return true;
        }
        return this.isVirtual(method);
    }

    boolean isVirtual(MethodReference method) {
        if (method.getName().equals("<init>") || method.getName().equals("<clinit>")) {
            return false;
        }
        return this.virtualMethods == null || this.virtualMethods.contains(method) || this.additionalVirtualMethods.stream().anyMatch(p -> p.test(method));
    }

    static class ListableClassReaderSourceAdapter
    implements ListableClassReaderSource {
        private ClassReaderSource classSource;
        private Set<String> classes;

        ListableClassReaderSourceAdapter(ClassReaderSource classSource, Set<String> classes) {
            this.classSource = classSource;
            this.classes = Collections.unmodifiableSet(classes.stream().filter(className -> classSource.get((String)className) != null).collect(Collectors.toSet()));
        }

        @Override
        public Set<String> getClassNames() {
            return this.classes;
        }

        @Override
        public ClassReader get(String name) {
            return this.classes.contains(name) ? this.classSource.get(name) : null;
        }
    }

    class PostProcessingClassHolderSource
    implements ListableClassHolderSource {
        private Linker linker;
        private MissingItemsProcessor missingItemsProcessor;
        private Map<String, ClassHolder> cache;
        private Set<String> classNames;
        private ClassInitializerInsertionTransformer clinitInsertion;

        PostProcessingClassHolderSource() {
            this.linker = new Linker(TeaVM.this.dependencyAnalyzer);
            this.missingItemsProcessor = new MissingItemsProcessor(TeaVM.this.dependencyAnalyzer, TeaVM.this.dependencyAnalyzer.getClassHierarchy(), TeaVM.this.diagnostics, TeaVM.this.target.getPlatformTags());
            this.cache = new HashMap<String, ClassHolder>();
            this.classNames = Collections.unmodifiableSet(new HashSet(TeaVM.this.dependencyAnalyzer.getReachableClasses().stream().filter(className -> TeaVM.this.dependencyAnalyzer.getClassSource().get((String)className) != null).collect(Collectors.toList())));
            this.clinitInsertion = new ClassInitializerInsertionTransformer(TeaVM.this.dependencyAnalyzer.getClassSource(), TeaVM.this.classInitializerInfo);
        }

        @Override
        public ClassHolder get(String name) {
            return this.cache.computeIfAbsent(name, className -> {
                ClassReader classReader = TeaVM.this.dependencyAnalyzer.getClassSource().get((String)className);
                if (classReader == null) {
                    return null;
                }
                ClassHolder cls = ModelUtils.copyClass(classReader, false);
                for (FieldHolder field : cls.getFields().toArray(new FieldHolder[0])) {
                    FieldReference fieldRef = new FieldReference(cls.getName(), field.getName());
                    if (TeaVM.this.dependencyAnalyzer.getField(fieldRef) != null) continue;
                    cls.removeField(field);
                }
                Function<MethodHolder, Program> programSupplier = method -> {
                    Program program;
                    Program program2 = program = !TeaVM.this.cacheStatus.isStaleMethod(method.getReference()) ? TeaVM.this.programCache.get(method.getReference(), TeaVM.this.cacheStatus) : null;
                    if (program == null) {
                        program = ProgramUtils.copy(classReader.getMethod(method.getDescriptor()).getProgram());
                        this.missingItemsProcessor.processMethod(method.getReference(), program);
                        this.linker.link(method.getReference(), program);
                        this.clinitInsertion.apply((MethodReader)method, program);
                        Program finalProgram = program = TeaVM.this.optimizeMethodCacheMiss(method, program);
                        TeaVM.this.programCache.store(method.getReference(), finalProgram, () -> TeaVM.this.programDependencyExtractor.extractDependencies(finalProgram));
                    }
                    return program;
                };
                for (MethodHolder method2 : cls.getMethods().toArray(new MethodHolder[0])) {
                    MethodDependency methodDep = TeaVM.this.dependencyAnalyzer.getMethod(method2.getReference());
                    if (methodDep == null || !methodDep.isUsed()) {
                        if (method2.hasModifier(ElementModifier.STATIC)) {
                            cls.removeMethod(method2);
                            continue;
                        }
                        method2.getModifiers().add(ElementModifier.ABSTRACT);
                        method2.getModifiers().remove((Object)ElementModifier.NATIVE);
                        method2.setProgram(null);
                        continue;
                    }
                    MethodReader methodReader = classReader.getMethod(method2.getDescriptor());
                    if (methodReader == null || methodReader.getProgram() == null) continue;
                    method2.setProgramSupplier(programSupplier);
                }
                return cls;
            });
        }

        @Override
        public Set<String> getClassNames() {
            return this.classNames;
        }
    }

    class MethodOptimizationContextImpl
    implements MethodOptimizationContext {
        private MethodReader method;

        MethodOptimizationContextImpl(MethodReader method) {
            this.method = method;
        }

        @Override
        public MethodReader getMethod() {
            return this.method;
        }

        @Override
        public DependencyInfo getDependencyInfo() {
            return TeaVM.this.dependencyAnalyzer;
        }
    }
}

