/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.lowlevel;

import java.util.Objects;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.lowlevel.CallSiteDescriptor;
import org.teavm.model.lowlevel.CallSiteLocationAnnot;

public class CallSiteLocation {
    private String fileName;
    private String className;
    private String methodName;
    private int lineNumber;

    public CallSiteLocation(String fileName, String className, String methodName, int lineNumber) {
        this.fileName = fileName;
        this.className = className;
        this.methodName = methodName;
        this.lineNumber = lineNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CallSiteLocation)) {
            return false;
        }
        CallSiteLocation other = (CallSiteLocation)obj;
        return Objects.equals(this.fileName, other.fileName) && Objects.equals(this.className, other.className) && Objects.equals(this.methodName, other.methodName) && this.lineNumber == other.lineNumber;
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.className, this.methodName, this.lineNumber);
    }

    public AnnotationReader save() {
        AnnotationHolder annotation = new AnnotationHolder(CallSiteLocationAnnot.class.getName());
        annotation.getValues().put("fileName", CallSiteDescriptor.saveNullableString(this.fileName));
        annotation.getValues().put("className", CallSiteDescriptor.saveNullableString(this.className));
        annotation.getValues().put("methodName", CallSiteDescriptor.saveNullableString(this.methodName));
        annotation.getValues().put("lineNumber", new AnnotationValue(this.lineNumber));
        return annotation;
    }

    public static CallSiteLocation load(AnnotationReader reader) {
        return new CallSiteLocation(CallSiteDescriptor.loadNullableString(reader.getValue("fileName")), CallSiteDescriptor.loadNullableString(reader.getValue("className")), CallSiteDescriptor.loadNullableString(reader.getValue("methodName")), reader.getValue("lineNumber").getInt());
    }
}

