/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import org.teavm.hppc.BitMixer;
import org.teavm.hppc.CharShortHashMap;
import org.teavm.hppc.HashOrderMixing;

public class CharShortScatterMap
extends CharShortHashMap {
    public CharShortScatterMap() {
        this(4);
    }

    public CharShortScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public CharShortScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(char key) {
        return BitMixer.mixPhi(key);
    }

    public static CharShortScatterMap from(char[] keys, short[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharShortScatterMap map = new CharShortScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

