/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import org.teavm.hppc.BitMixer;
import org.teavm.hppc.ByteObjectHashMap;
import org.teavm.hppc.HashOrderMixing;

public class ByteObjectScatterMap<VType>
extends ByteObjectHashMap<VType> {
    public ByteObjectScatterMap() {
        this(4);
    }

    public ByteObjectScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ByteObjectScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(byte key) {
        return BitMixer.mixPhi(key);
    }

    public static <VType> ByteObjectScatterMap<VType> from(byte[] keys, VType[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ByteObjectScatterMap<VType> map = new ByteObjectScatterMap<VType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

