/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import java.util.BitSet;
import org.teavm.common.OptionalPredicate;
import org.teavm.dependency.DependencyAnalyzer;
import org.teavm.dependency.DependencyType;
import org.teavm.dependency.DependencyTypeFilter;

class SuperClassFilter
implements DependencyTypeFilter {
    private static final int[] EMPTY_ARRAY = new int[0];
    private DependencyType superType;
    private OptionalPredicate<String> predicate;
    private BitSet knownTypes = new BitSet();
    private BitSet cache = new BitSet();

    SuperClassFilter(DependencyAnalyzer dependencyAnalyzer, DependencyType superType) {
        this.superType = superType;
        this.predicate = dependencyAnalyzer.getClassHierarchy().getSuperclassPredicate(superType.getName());
    }

    @Override
    public boolean match(DependencyType type) {
        if (!this.superType.subtypeExists) {
            return this.superType.index == type.index;
        }
        if (this.knownTypes.get(type.index)) {
            return this.cache.get(type.index);
        }
        boolean result = this.predicate.test(type.getName(), false);
        this.knownTypes.set(type.index);
        this.cache.set(type.index, result);
        return result;
    }

    @Override
    public int[] tryExtract(BitSet types) {
        int[] nArray;
        if (this.superType.subtypeExists) {
            return null;
        }
        if (types.get(this.superType.index)) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = this.superType.index;
        } else {
            nArray = EMPTY_ARRAY;
        }
        return nArray;
    }
}

