/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.debugging;

import java.util.HashMap;
import java.util.Map;
import org.teavm.common.Promise;
import org.teavm.debugging.Debugger;
import org.teavm.debugging.Variable;
import org.teavm.debugging.information.DebugInformation;
import org.teavm.debugging.javascript.JavaScriptValue;
import org.teavm.debugging.javascript.JavaScriptVariable;

public class Value {
    private Debugger debugger;
    private DebugInformation debugInformation;
    private JavaScriptValue jsValue;
    private Promise<Map<String, Variable>> properties;
    private Promise<String> type;

    Value(Debugger debugger, DebugInformation debugInformation, JavaScriptValue jsValue) {
        this.debugger = debugger;
        this.debugInformation = debugInformation;
        this.jsValue = jsValue;
    }

    private static boolean isNumeric(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public Promise<String> getRepresentation() {
        return this.jsValue.getRepresentation();
    }

    public Promise<String> getType() {
        if (this.type == null) {
            this.type = this.jsValue.getClassName().then(className -> {
                if (className.startsWith("a/")) {
                    String origClassName = className = className.substring(2);
                    int degree = 0;
                    while (className.endsWith("[]")) {
                        className = className.substring(0, className.length() - 2);
                        ++degree;
                    }
                    String javaClassName = this.debugInformation.getClassNameByJsName((String)className);
                    if (javaClassName != null) {
                        if (degree > 0) {
                            StringBuilder sb = new StringBuilder(javaClassName);
                            for (int i = 0; i < degree; ++i) {
                                sb.append("[]");
                            }
                            javaClassName = sb.toString();
                        }
                        className = javaClassName;
                    } else {
                        className = origClassName;
                    }
                }
                return className;
            });
        }
        return this.type;
    }

    public Promise<Map<String, Variable>> getProperties() {
        if (this.properties == null) {
            this.properties = this.jsValue.getProperties().thenAsync(jsVariables -> this.getType().thenAsync(className -> {
                if (!className.startsWith("@") && className.endsWith("[]") && jsVariables.containsKey("data")) {
                    return ((JavaScriptVariable)jsVariables.get("data")).getValue().getProperties().then(arrayData -> this.fillArray((Map<String, ? extends JavaScriptVariable>)arrayData));
                }
                HashMap<String, Variable> vars = new HashMap<String, Variable>();
                for (Map.Entry entry : jsVariables.entrySet()) {
                    JavaScriptVariable jsVar = (JavaScriptVariable)entry.getValue();
                    String name = this.debugger.mapField((String)className, (String)entry.getKey());
                    if (name == null) continue;
                    Value value = new Value(this.debugger, this.debugInformation, jsVar.getValue());
                    vars.put(name, new Variable(name, value));
                }
                return Promise.of(vars);
            }));
        }
        return this.properties;
    }

    private Map<String, Variable> fillArray(Map<String, ? extends JavaScriptVariable> jsVariables) {
        HashMap<String, Variable> vars = new HashMap<String, Variable>();
        for (Map.Entry<String, ? extends JavaScriptVariable> entry : jsVariables.entrySet()) {
            JavaScriptVariable jsVar = entry.getValue();
            if (!Value.isNumeric(entry.getKey())) continue;
            Value value = new Value(this.debugger, this.debugInformation, jsVar.getValue());
            vars.put(entry.getKey(), new Variable(entry.getKey(), value));
        }
        return vars;
    }

    public boolean hasInnerStructure() {
        if (this.getType().equals("long")) {
            return false;
        }
        return this.jsValue.hasInnerStructure();
    }

    public String getInstanceId() {
        if (this.getType().equals("long")) {
            return null;
        }
        return this.jsValue.getInstanceId();
    }

    public JavaScriptValue getOriginalValue() {
        return this.jsValue;
    }
}

