/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.cli;

import org.teavm.apachecommons.cli.CommandLine;
import org.teavm.apachecommons.cli.HelpFormatter;
import org.teavm.apachecommons.cli.OptionBuilder;
import org.teavm.apachecommons.cli.Options;
import org.teavm.apachecommons.cli.ParseException;
import org.teavm.apachecommons.cli.PosixParser;
import org.teavm.tooling.ConsoleTeaVMToolLog;
import org.teavm.tooling.c.incremental.IncrementalCBuilder;

public class TeaVMCBuilderRunner {
    private static Options options = new Options();
    private IncrementalCBuilder builder;
    private CommandLine commandLine;

    private static void setupOptions() {
        OptionBuilder.withArgName("directory");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("a directory in which generated C files will be placed");
        OptionBuilder.withLongOpt("targetdir");
        options.addOption(OptionBuilder.create('d'));
        OptionBuilder.withArgName("classpath");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription("classpath element (either directory or jar file)");
        OptionBuilder.withLongOpt("classpath");
        options.addOption(OptionBuilder.create('p'));
        OptionBuilder.withDescription("display more messages on server log");
        OptionBuilder.withLongOpt("verbose");
        options.addOption(OptionBuilder.create('v'));
        OptionBuilder.withDescription("generate debugger-friendly code");
        OptionBuilder.withLongOpt("debug");
        options.addOption(OptionBuilder.create('g'));
        OptionBuilder.withLongOpt("min-heap");
        OptionBuilder.withArgName("size");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Minimum heap size in bytes");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("no-longjmp");
        OptionBuilder.withDescription("Don't use setjmp/longjmp functions to emulate exception handling");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("entry-point");
        OptionBuilder.withArgName("name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Name of entry point function (main by default)");
        options.addOption(OptionBuilder.create('e'));
        OptionBuilder.withLongOpt("external-tool");
        OptionBuilder.withArgName("path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Process to run after successful build");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("external-tool-workdir");
        OptionBuilder.withArgName("path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Working directory of process");
        options.addOption(OptionBuilder.create());
    }

    private TeaVMCBuilderRunner(CommandLine commandLine) {
        this.commandLine = commandLine;
        this.builder = new IncrementalCBuilder();
    }

    public static void main(String[] args) {
        CommandLine commandLine;
        if (args.length == 0) {
            TeaVMCBuilderRunner.printUsage();
            return;
        }
        PosixParser parser = new PosixParser();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            TeaVMCBuilderRunner.printUsage();
            return;
        }
        TeaVMCBuilderRunner runner = new TeaVMCBuilderRunner(commandLine);
        runner.parseArguments();
        runner.runAll();
    }

    private void parseArguments() {
        String[] args;
        this.parseClassPathOptions();
        this.parseOutputOptions();
        this.parseHeap();
        this.parseExternalTool();
        this.builder.setLog(new ConsoleTeaVMToolLog(this.commandLine.hasOption('v')));
        this.builder.setLineNumbersGenerated(this.commandLine.hasOption('g'));
        if (this.commandLine.hasOption('e')) {
            this.builder.setMainFunctionName(this.commandLine.getOptionValue('e'));
        }
        if (this.commandLine.hasOption("no-longjmp")) {
            this.builder.setLongjmpSupported(false);
        }
        if ((args = this.commandLine.getArgs()).length != 1) {
            System.err.println("Unexpected arguments");
            TeaVMCBuilderRunner.printUsage();
        } else if (args.length == 1) {
            this.builder.setMainClass(args[0]);
        }
    }

    private void parseExternalTool() {
        boolean hasExternalTool = false;
        if (this.commandLine.hasOption("external-tool")) {
            this.builder.setExternalTool(this.commandLine.getOptionValue("external-tool"));
            hasExternalTool = true;
        }
        if (this.commandLine.hasOption("external-tool-workdir")) {
            if (!hasExternalTool) {
                System.err.println("Redundant 'external-tool-workdir' option: no external tool specified");
            } else {
                this.builder.setExternalToolWorkingDir(this.commandLine.getOptionValue("external-tool-workdir"));
            }
        }
    }

    private void parseOutputOptions() {
        if (this.commandLine.hasOption("d")) {
            this.builder.setTargetPath(this.commandLine.getOptionValue("d"));
        }
    }

    private void parseClassPathOptions() {
        if (this.commandLine.hasOption('p')) {
            this.builder.setClassPath(this.commandLine.getOptionValues('p'));
        }
    }

    private void parseHeap() {
        if (this.commandLine.hasOption("min-heap")) {
            int size;
            try {
                size = Integer.parseInt(this.commandLine.getOptionValue("min-heap"));
            }
            catch (NumberFormatException e) {
                System.err.print("Wrong heap size");
                TeaVMCBuilderRunner.printUsage();
                return;
            }
            this.builder.setMinHeapSize(size);
        }
    }

    private void runAll() {
        this.builder.start();
    }

    private static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java " + TeaVMCBuilderRunner.class.getName() + " [OPTIONS] [qualified.main.Class]", options);
        System.exit(-1);
    }

    static {
        TeaVMCBuilderRunner.setupOptions();
    }
}

