/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.Arrays;
import org.teavm.classlib.java.lang.TMath;
import org.teavm.classlib.java.lang.TNullPointerException;
import org.teavm.classlib.java.util.TAbstractCollection;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TConcurrentModificationException;
import org.teavm.classlib.java.util.TDeque;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TNoSuchElementException;

public class TArrayDeque<E>
extends TAbstractCollection<E>
implements TDeque<E> {
    private int version;
    private Object[] array;
    private int head;
    private int tail;

    public TArrayDeque() {
        this(8);
    }

    public TArrayDeque(int numElements) {
        this.array = new Object[numElements + 1];
    }

    public TArrayDeque(TCollection<? extends E> c) {
        if (c.isEmpty()) {
            this.array = new Object[8];
        } else {
            this.array = new Object[c.size() + 1];
            int index = 0;
            TIterator iter = c.iterator();
            while (iter.hasNext()) {
                this.array[index++] = iter.next();
            }
            this.tail = this.array.length - 1;
        }
    }

    @Override
    public void addFirst(E e) {
        if (e == null) {
            throw new TNullPointerException();
        }
        this.ensureCapacity(this.size() + 1);
        --this.head;
        if (this.head < 0) {
            this.head += this.array.length;
        }
        this.array[this.head] = e;
        ++this.version;
    }

    @Override
    public void addLast(E e) {
        if (e == null) {
            throw new TNullPointerException();
        }
        this.ensureCapacity(this.size() + 1);
        this.array[this.tail++] = e;
        if (this.tail >= this.array.length) {
            this.tail = 0;
        }
        ++this.version;
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E removeFirst() {
        E value = this.pollFirst();
        if (value == null) {
            throw new TNoSuchElementException();
        }
        return value;
    }

    @Override
    public E removeLast() {
        E value = this.pollLast();
        if (value == null) {
            throw new TNoSuchElementException();
        }
        return value;
    }

    @Override
    public E pollFirst() {
        if (this.head == this.tail) {
            return null;
        }
        Object result = this.array[this.head];
        this.array[this.head] = null;
        ++this.head;
        if (this.head >= this.array.length) {
            this.head = 0;
        }
        ++this.version;
        return (E)result;
    }

    @Override
    public E pollLast() {
        if (this.head == this.tail) {
            return null;
        }
        --this.tail;
        if (this.tail < 0) {
            this.tail = this.array.length - 1;
        }
        Object result = this.array[this.tail];
        this.array[this.tail] = null;
        ++this.version;
        return (E)result;
    }

    @Override
    public E getFirst() {
        E result = this.peekFirst();
        if (result == null) {
            throw new TNoSuchElementException();
        }
        return result;
    }

    @Override
    public E getLast() {
        E result = this.peekLast();
        if (result == null) {
            throw new TNoSuchElementException();
        }
        return result;
    }

    @Override
    public E peekFirst() {
        return (E)(!this.isEmpty() ? this.array[this.head] : null);
    }

    @Override
    public E peekLast() {
        return (E)(!this.isEmpty() ? this.array[this.tail > 0 ? this.tail - 1 : this.array.length - 1] : null);
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        if (o == null) {
            return false;
        }
        TIterator<E> iter = this.iterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(o)) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        if (o == null) {
            return false;
        }
        TIterator<E> iter = this.descendingIterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(o)) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public int size() {
        return this.tail >= this.head ? this.tail - this.head : this.array.length - this.head + this.tail;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    private void removeAt(int index) {
        if (this.head < this.tail) {
            if (this.tail - index < index - this.head) {
                for (int i = index + 1; i < this.tail; ++i) {
                    this.array[i - 1] = this.array[i];
                }
                this.array[--this.tail] = null;
            } else {
                for (int i = index - 1; i >= this.head; --i) {
                    this.array[i + 1] = this.array[i];
                }
                this.array[this.head++] = null;
            }
        } else if (index >= this.head) {
            for (int i = index - 1; i >= this.head; --i) {
                this.array[i + 1] = this.array[i];
            }
            this.array[this.head++] = null;
            if (this.head >= this.array.length) {
                this.head = 0;
            }
        } else {
            for (int i = index + 1; i < this.tail; ++i) {
                this.array[i - 1] = this.array[i];
            }
            this.array[--this.tail] = null;
            if (this.tail == 0) {
                this.tail += this.array.length;
            }
        }
    }

    @Override
    public TIterator<E> iterator() {
        return new TIterator<E>(){
            private int refVersion;
            private int index;
            private int lastIndex;
            private boolean wrapped;
            {
                this.refVersion = TArrayDeque.this.version;
                this.index = TArrayDeque.this.head;
                this.lastIndex = -1;
                this.wrapped = TArrayDeque.this.head <= TArrayDeque.this.tail;
            }

            @Override
            public boolean hasNext() {
                return !this.wrapped || this.index < TArrayDeque.this.tail;
            }

            @Override
            public E next() {
                if (TArrayDeque.this.version > this.refVersion) {
                    throw new TConcurrentModificationException();
                }
                this.lastIndex = this.index;
                Object result = TArrayDeque.this.array[this.index++];
                if (this.index >= TArrayDeque.this.array.length) {
                    this.index = 0;
                    this.wrapped = true;
                }
                return result;
            }

            @Override
            public void remove() {
                if (this.lastIndex < 0) {
                    throw new IllegalStateException();
                }
                TArrayDeque.this.removeAt(this.lastIndex);
                this.lastIndex = -1;
            }
        };
    }

    @Override
    public TIterator<E> descendingIterator() {
        return new TIterator<E>(){
            private int refVersion;
            private int index;
            private int lastIndex;
            private boolean wrapped;
            {
                this.refVersion = TArrayDeque.this.version;
                this.index = TArrayDeque.this.tail;
                this.lastIndex = -1;
                this.wrapped = TArrayDeque.this.head <= TArrayDeque.this.tail;
            }

            @Override
            public boolean hasNext() {
                return !this.wrapped || this.index > TArrayDeque.this.head;
            }

            @Override
            public E next() {
                if (TArrayDeque.this.version > this.refVersion) {
                    throw new TConcurrentModificationException();
                }
                --this.index;
                if (this.index < 0) {
                    this.index = TArrayDeque.this.array.length - 1;
                    this.wrapped = true;
                }
                this.lastIndex = this.index;
                Object result = TArrayDeque.this.array[this.index];
                return result;
            }

            @Override
            public void remove() {
                TArrayDeque.this.removeAt(this.lastIndex);
                this.lastIndex = -1;
            }
        };
    }

    private void ensureCapacity(int capacity) {
        if (capacity < this.array.length) {
            return;
        }
        int newArraySize = TMath.max(this.array.length * 2, capacity * 3 / 2 + 1);
        if (newArraySize < 1) {
            newArraySize = Integer.MAX_VALUE;
        }
        Object[] newArray = new Object[newArraySize];
        int j = 0;
        if (this.head <= this.tail) {
            for (int i = this.head; i < this.tail; ++i) {
                newArray[j++] = this.array[i];
            }
        } else {
            int i;
            for (i = this.head; i < this.array.length; ++i) {
                newArray[j++] = this.array[i];
            }
            for (i = 0; i < this.tail; ++i) {
                newArray[j++] = this.array[i];
            }
        }
        this.head = 0;
        this.tail = j;
        this.array = newArray;
    }

    @Override
    public void clear() {
        Arrays.fill(this.array, null);
        this.head = this.tail;
    }

    @Override
    protected TArrayDeque<E> clone() {
        return new TArrayDeque<E>(this);
    }
}

