/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.unicode;

import java.util.Map;
import org.teavm.classlib.impl.unicode.CLDRLocale;
import org.teavm.classlib.impl.unicode.CLDRReader;
import org.teavm.classlib.impl.unicode.CLDRTimeZone;
import org.teavm.classlib.impl.unicode.TimeZoneLocalization;
import org.teavm.model.MethodReference;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.MetadataGeneratorContext;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.metadata.ResourceMap;
import org.teavm.platform.metadata.StringResource;

public class TimeZoneLocalizationGenerator
implements MetadataGenerator {
    @Override
    public Resource generateMetadata(MetadataGeneratorContext context, MethodReference method) {
        CLDRReader cldr = context.getService(CLDRReader.class);
        ResourceMap<TimeZoneLocalization> localizations = context.createResourceMap();
        for (Map.Entry<String, CLDRLocale> locale : cldr.getKnownLocales().entrySet()) {
            TimeZoneLocalization localization = context.createResource(TimeZoneLocalization.class);
            ResourceMap<ResourceMap<StringResource>> map = context.createResourceMap();
            localization.setTimeZones(map);
            localizations.put(locale.getKey(), localization);
            for (CLDRTimeZone tz : locale.getValue().getTimeZones()) {
                ResourceMap<Object> area;
                if (!map.has(tz.getArea())) {
                    area = context.createResourceMap();
                    map.put(tz.getArea(), area);
                }
                area = map.get(tz.getArea());
                StringResource name = context.createResource(StringResource.class);
                name.setValue(tz.getName());
                area.put(tz.getLocation(), name);
            }
        }
        return localizations;
    }
}

