/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics;

import org.teavm.ast.InvocationExpr;
import org.teavm.ast.QualificationExpr;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmUnreachable;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReference;
import org.teavm.runtime.RuntimeClass;

public class PlatformClassMetadataIntrinsic
implements WasmIntrinsic {
    private static final String PLATFORM_CLASS_METADATA = "org.teavm.platform.PlatformClassMetadata";
    private static final FieldReference ITEM_TYPE_FIELD = new FieldReference(RuntimeClass.class.getName(), "itemType");
    private static final FieldReference SUPERCLASS_FIELD = new FieldReference(RuntimeClass.class.getName(), "parent");
    private static final FieldReference NAME_FIELD = new FieldReference(RuntimeClass.class.getName(), "name");

    @Override
    public boolean isApplicable(MethodReference methodReference) {
        if (!methodReference.getClassName().equals(PLATFORM_CLASS_METADATA)) {
            return false;
        }
        switch (methodReference.getName()) {
            case "getArrayItem": 
            case "getSuperclass": 
            case "getName": {
                return true;
            }
        }
        return false;
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        switch (invocation.getMethod().getName()) {
            case "getArrayItem": {
                return this.fieldAccess(manager, invocation, ITEM_TYPE_FIELD);
            }
            case "getSuperclass": {
                return this.fieldAccess(manager, invocation, SUPERCLASS_FIELD);
            }
            case "getName": {
                return this.fieldAccess(manager, invocation, NAME_FIELD);
            }
        }
        return new WasmUnreachable();
    }

    private WasmExpression fieldAccess(WasmIntrinsicManager manager, InvocationExpr expr, FieldReference field) {
        QualificationExpr qualification = new QualificationExpr();
        qualification.setField(field);
        qualification.setQualified(expr.getArguments().get(0));
        qualification.setLocation(expr.getLocation());
        return manager.generate(qualification);
    }
}

