/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.vm;

import java.util.ArrayList;
import java.util.List;
import org.teavm.interop.PlatformMarker;
import org.teavm.vm.TeaVMBootstrapPluginLoader;
import org.teavm.vm.TeaVMPluginReader;
import org.teavm.vm.spi.TeaVMPlugin;

public final class TeaVMPluginLoader {
    private TeaVMPluginLoader() {
    }

    public static List<TeaVMPlugin> load(ClassLoader classLoader) {
        if (TeaVMPluginLoader.isBootstrap()) {
            return TeaVMBootstrapPluginLoader.loadPlugins(false);
        }
        ArrayList<TeaVMPlugin> plugins = new ArrayList<TeaVMPlugin>();
        TeaVMPluginReader.load(classLoader, className -> plugins.add(TeaVMPluginLoader.instantiate(classLoader, className)));
        return plugins;
    }

    @PlatformMarker
    private static boolean isBootstrap() {
        return false;
    }

    private static TeaVMPlugin instantiate(ClassLoader classLoader, String className) {
        try {
            return (TeaVMPlugin)Class.forName(className, true, classLoader).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Can't instantiate plugin " + className, e);
        }
    }
}

