/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.runtime;

import org.teavm.interop.Address;
import org.teavm.interop.Export;
import org.teavm.interop.Import;
import org.teavm.interop.StaticInit;
import org.teavm.interop.Structure;
import org.teavm.interop.Unmanaged;
import org.teavm.runtime.Allocator;
import org.teavm.runtime.ExceptionHandling;
import org.teavm.runtime.FreeChunk;
import org.teavm.runtime.FreeChunkHolder;
import org.teavm.runtime.MarkQueue;
import org.teavm.runtime.MemoryTrace;
import org.teavm.runtime.Mutator;
import org.teavm.runtime.Relocation;
import org.teavm.runtime.RelocationBlock;
import org.teavm.runtime.RuntimeArray;
import org.teavm.runtime.RuntimeClass;
import org.teavm.runtime.RuntimeObject;
import org.teavm.runtime.RuntimeReference;
import org.teavm.runtime.RuntimeReferenceQueue;
import org.teavm.runtime.ShadowStack;

@Unmanaged
@StaticInit
public final class GC {
    static Address currentChunkLimit;
    static FreeChunk currentChunk;
    static FreeChunkHolder currentChunkPointer;
    static int freeChunks;
    static int freeMemory;
    static RuntimeReference firstWeakReference;
    static RelocationBlock lastRelocationBlock;

    private GC() {
    }

    static native Address gcStorageAddress();

    static native int gcStorageSize();

    private static native Address heapAddress();

    private static native Region regionsAddress();

    private static native int regionMaxCount();

    public static native long availableBytes();

    private static native int regionSize();

    @Import(name="teavm_outOfMemory")
    private static native void outOfMemory();

    public static int getFreeMemory() {
        return freeMemory;
    }

    public static RuntimeObject alloc(int size) {
        FreeChunk current = currentChunk;
        Address next = current.toAddress().add(size);
        if (!next.add(Structure.sizeOf(FreeChunk.class)).isLessThan(currentChunkLimit)) {
            GC.getNextChunk(size);
            current = currentChunk;
            next = current.toAddress().add(size);
        }
        currentChunk = (FreeChunk)next.toStructure();
        freeMemory -= size;
        MemoryTrace.allocate(current.toAddress(), size);
        return (RuntimeObject)current.toAddress().toStructure();
    }

    private static void getNextChunk(int size) {
        if (GC.getNextChunkIfPossible(size)) {
            return;
        }
        GC.collectGarbage();
        if (GC.currentChunk.size < size && !GC.getNextChunkIfPossible(size)) {
            ExceptionHandling.printStack();
            GC.outOfMemory();
        }
    }

    private static boolean getNextChunkIfPossible(int size) {
        while (true) {
            if (currentChunk.toAddress().isLessThan(currentChunkLimit)) {
                GC.currentChunk.classReference = 0;
                GC.currentChunk.size = (int)(currentChunkLimit.toLong() - currentChunk.toAddress().toLong());
            }
            if (--freeChunks == 0) {
                return false;
            }
            currentChunkPointer = Structure.add(FreeChunkHolder.class, currentChunkPointer, 1);
            currentChunk = GC.currentChunkPointer.value;
            if (GC.currentChunk.size >= size) break;
            freeMemory -= GC.currentChunk.size;
        }
        currentChunkLimit = currentChunk.toAddress().add(GC.currentChunk.size);
        return true;
    }

    public static void collectGarbage() {
        MemoryTrace.gcStarted();
        GC.mark();
        GC.processReferences();
        GC.sweep();
        MemoryTrace.sweepCompleted();
        GC.defragment();
        MemoryTrace.defragCompleted();
        GC.updateFreeMemory();
        currentChunk = GC.currentChunkPointer.value;
        currentChunkLimit = currentChunk.toAddress().add(GC.currentChunk.size);
    }

    @Export(name="teavm_gc_fixHeap")
    public static void fixHeap() {
        if (freeChunks > 0) {
            GC.currentChunk.classReference = 0;
            GC.currentChunk.size = (int)(currentChunkLimit.toLong() - currentChunk.toAddress().toLong());
        }
    }

    private static void mark() {
        MemoryTrace.initMark();
        firstWeakReference = null;
        int regionsCount = (int)((GC.availableBytes() - 1L) / (long)GC.regionSize()) + 1;
        Allocator.fillZero(GC.regionsAddress().toAddress(), regionsCount * Structure.sizeOf(Region.class));
        Address staticRoots = Mutator.getStaticGCRoots();
        int staticCount = staticRoots.getInt();
        staticRoots = staticRoots.add(Address.sizeOf());
        while (staticCount-- > 0) {
            RuntimeObject object = (RuntimeObject)staticRoots.getAddress().getAddress().toStructure();
            if (object != null) {
                GC.mark(object);
            }
            staticRoots = staticRoots.add(Address.sizeOf());
        }
        Address stackRoots = ShadowStack.getStackTop();
        while (stackRoots != null) {
            int count = ShadowStack.getStackRootCount(stackRoots);
            Address stackRootsPtr = ShadowStack.getStackRootPointer(stackRoots);
            while (count-- > 0) {
                RuntimeObject obj = (RuntimeObject)stackRootsPtr.getAddress().toStructure();
                GC.mark(obj);
                stackRootsPtr = stackRootsPtr.add(Address.sizeOf());
            }
            stackRoots = ShadowStack.getNextStackFrame(stackRoots);
        }
    }

    private static void mark(RuntimeObject object) {
        if (object == null || GC.isMarked(object)) {
            return;
        }
        MarkQueue.init();
        MarkQueue.enqueue(object);
        while (!MarkQueue.isEmpty()) {
            object = MarkQueue.dequeue();
            if (GC.isMarked(object)) continue;
            object.classReference |= Integer.MIN_VALUE;
            MemoryTrace.mark(object.toAddress());
            long offset = object.toAddress().toLong() - GC.heapAddress().toLong();
            Region region = Structure.add(Region.class, GC.regionsAddress(), (int)(offset / (long)GC.regionSize()));
            short relativeOffset = (short)(offset % (long)GC.regionSize() + 1L);
            if (region.start == 0 || region.start > relativeOffset) {
                region.start = relativeOffset;
            }
            RuntimeClass cls = RuntimeClass.getClass(object);
            if (cls.itemType == null) {
                GC.markObject(cls, object);
                continue;
            }
            GC.markArray(cls, (RuntimeArray)object);
        }
    }

    private static void markObject(RuntimeClass cls, RuntimeObject object) {
        while (cls != null) {
            int type = cls.flags >> 7 & 7;
            switch (type) {
                case 1: {
                    GC.markWeakReference((RuntimeReference)object);
                    break;
                }
                case 2: {
                    GC.markReferenceQueue((RuntimeReferenceQueue)object);
                    break;
                }
                default: {
                    GC.markFields(cls, object);
                }
            }
            cls = cls.parent;
        }
    }

    private static void markWeakReference(RuntimeReference object) {
        if (object.queue != null) {
            GC.enqueueMark(object.queue);
            if (object.next != null && object.object != null) {
                GC.enqueueMark(object.object);
            }
        }
        if (object.next == null && object.object != null) {
            object.next = firstWeakReference;
            firstWeakReference = object;
        }
    }

    private static void markReferenceQueue(RuntimeReferenceQueue object) {
        RuntimeReference reference = object.first;
        while (reference != null) {
            GC.enqueueMark(reference);
            reference = reference.next;
        }
    }

    private static void markFields(RuntimeClass cls, RuntimeObject object) {
        Address layout = cls.layout;
        if (layout != null) {
            short fieldCount = layout.getShort();
            while (true) {
                short s = fieldCount;
                fieldCount = (short)(fieldCount - 1);
                if (s <= 0) break;
                layout = layout.add(2);
                short fieldOffset = layout.getShort();
                RuntimeObject reference = (RuntimeObject)object.toAddress().add(fieldOffset).getAddress().toStructure();
                GC.enqueueMark(reference);
            }
        }
    }

    private static void markArray(RuntimeClass cls, RuntimeArray array) {
        if ((cls.itemType.flags & 2) != 0) {
            return;
        }
        Address base = Address.align(array.toAddress().add(RuntimeArray.class, 1), Address.sizeOf());
        for (int i = 0; i < array.size; ++i) {
            RuntimeObject reference = (RuntimeObject)base.getAddress().toStructure();
            GC.enqueueMark(reference);
            base = base.add(Address.sizeOf());
        }
    }

    private static void enqueueMark(RuntimeObject object) {
        if (object != null && !GC.isMarked(object)) {
            MarkQueue.enqueue(object);
        }
    }

    private static void processReferences() {
        RuntimeReference reference = firstWeakReference;
        while (reference != null) {
            RuntimeReference next = reference.next;
            reference.next = null;
            if ((reference.object.classReference & Integer.MIN_VALUE) == 0) {
                reference.object = null;
                RuntimeReferenceQueue queue = reference.queue;
                if (queue != null) {
                    if (queue.first == null) {
                        queue.first = reference;
                    } else {
                        queue.last.next = reference;
                    }
                    queue.last = reference;
                }
            }
            reference = next;
        }
    }

    private static void sweep() {
        FreeChunkHolder freeChunkPtr = (FreeChunkHolder)GC.gcStorageAddress().toStructure();
        freeChunks = 0;
        FreeChunk object = (FreeChunk)GC.heapAddress().toStructure();
        Structure lastFreeSpace = null;
        long heapSize = GC.availableBytes();
        long reclaimedSpace = 0L;
        long maxFreeChunk = 0L;
        int regionsCount = (int)((heapSize - 1L) / (long)GC.regionSize()) + 1;
        Address currentRegionEnd = null;
        Address limit = GC.heapAddress().add(heapSize);
        block0: while (object.toAddress().isLessThan(limit)) {
            boolean free;
            int tag;
            if (!object.toAddress().isLessThan(currentRegionEnd)) {
                int currentRegionIndex = (int)((object.toAddress().toLong() - GC.heapAddress().toLong()) / (long)GC.regionSize());
                Region currentRegion = Structure.add(Region.class, GC.regionsAddress(), currentRegionIndex);
                if (currentRegion.start == 0) {
                    if (lastFreeSpace == null) {
                        lastFreeSpace = object;
                    }
                    do {
                        if (++currentRegionIndex == regionsCount) {
                            object = (FreeChunk)limit.toStructure();
                            break block0;
                        }
                        currentRegion = Structure.add(Region.class, GC.regionsAddress(), currentRegionIndex);
                    } while (currentRegion.start == 0);
                    Address newRegionStart = GC.heapAddress().add(currentRegionIndex * GC.regionSize());
                    object = (FreeChunk)newRegionStart.add(currentRegion.start - 1).toStructure();
                    currentRegionEnd = newRegionStart.add(GC.regionSize());
                }
            }
            if ((tag = object.classReference) == 0) {
                free = true;
            } else {
                boolean bl = free = (tag & Integer.MIN_VALUE) == 0;
                if (!free) {
                    tag &= Integer.MAX_VALUE;
                }
                object.classReference = tag;
            }
            if (free) {
                if (lastFreeSpace == null) {
                    lastFreeSpace = object;
                }
            } else if (lastFreeSpace != null) {
                ((FreeChunk)lastFreeSpace).classReference = 0;
                ((FreeChunk)lastFreeSpace).size = (int)(object.toAddress().toLong() - lastFreeSpace.toAddress().toLong());
                MemoryTrace.free(lastFreeSpace.toAddress(), ((FreeChunk)lastFreeSpace).size);
                freeChunkPtr.value = lastFreeSpace;
                freeChunkPtr = Structure.add(FreeChunkHolder.class, freeChunkPtr, 1);
                ++freeChunks;
                reclaimedSpace += (long)((FreeChunk)lastFreeSpace).size;
                if (maxFreeChunk < (long)((FreeChunk)lastFreeSpace).size) {
                    maxFreeChunk = ((FreeChunk)lastFreeSpace).size;
                }
                lastFreeSpace = null;
            }
            int size = GC.objectSize(object);
            object = (FreeChunk)object.toAddress().add(size).toStructure();
        }
        if (lastFreeSpace != null) {
            int freeSize = (int)(object.toAddress().toLong() - lastFreeSpace.toAddress().toLong());
            ((FreeChunk)lastFreeSpace).classReference = 0;
            ((FreeChunk)lastFreeSpace).size = freeSize;
            MemoryTrace.free(lastFreeSpace.toAddress(), ((FreeChunk)lastFreeSpace).size);
            freeChunkPtr.value = lastFreeSpace;
            freeChunkPtr = Structure.add(FreeChunkHolder.class, freeChunkPtr, 1);
            ++freeChunks;
            reclaimedSpace += (long)freeSize;
            if (maxFreeChunk < (long)freeSize) {
                maxFreeChunk = freeSize;
            }
        }
        currentChunkPointer = (FreeChunkHolder)GC.gcStorageAddress().toStructure();
    }

    private static void defragment() {
        GC.markStackRoots();
        GC.calculateRelocationTargets();
        GC.updatePointersFromStaticRoots();
        GC.updatePointersFromObjects();
        GC.restoreObjectHeaders();
        GC.relocateObjects();
        GC.putNewFreeChunks();
    }

    private static void markStackRoots() {
        Address relocationThreshold = GC.currentChunkPointer.value.toAddress();
        Address stackRoots = ShadowStack.getStackTop();
        while (stackRoots != null) {
            int count = ShadowStack.getStackRootCount(stackRoots);
            Address stackRootsPtr = ShadowStack.getStackRootPointer(stackRoots);
            while (count-- > 0) {
                RuntimeObject obj = (RuntimeObject)stackRootsPtr.getAddress().toStructure();
                if (!obj.toAddress().isLessThan(relocationThreshold)) {
                    obj.classReference |= Integer.MIN_VALUE;
                }
                stackRootsPtr = stackRootsPtr.add(Address.sizeOf());
            }
            stackRoots = ShadowStack.getNextStackFrame(stackRoots);
        }
    }

    private static void calculateRelocationTargets() {
        int size;
        Address relocationTarget;
        Address start = GC.heapAddress();
        long heapSize = GC.availableBytes();
        Address limit = start.add(heapSize);
        FreeChunkHolder freeChunkPointer = currentChunkPointer;
        int freeChunks = GC.freeChunks;
        FreeChunk freeChunk = GC.currentChunkPointer.value;
        FreeChunk object = (FreeChunk)freeChunk.toAddress().add(freeChunk.size).toStructure();
        RelocationBlock relocationBlock = (RelocationBlock)Structure.add(FreeChunkHolder.class, currentChunkPointer, freeChunks).toAddress().toStructure();
        relocationBlock.start = relocationTarget = freeChunk.toAddress();
        relocationBlock.end = limit;
        relocationBlock.count = 0;
        RelocationBlock lastRelocationBlock = relocationBlock;
        int countInCurrentRelocationBlock = 0;
        Address relocations = Structure.add(FreeChunk.class, freeChunk, 1).toAddress();
        Address relocationsLimit = freeChunk.toAddress().add(freeChunk.size);
        boolean lastWasLocked = false;
        block0: while (object.toAddress().isLessThan(limit)) {
            size = GC.objectSize(object);
            if (object.classReference != 0) {
                boolean shouldRelocateObject;
                Address nextRelocationTarget = null;
                boolean bl = shouldRelocateObject = (object.classReference & Integer.MIN_VALUE) == 0;
                if (shouldRelocateObject) {
                    while (relocationBlock.end.isLessThan(nextRelocationTarget = relocationTarget.add(size))) {
                        RelocationBlock nextRelocationBlock = Structure.add(RelocationBlock.class, relocationBlock, 1);
                        if (nextRelocationBlock.start == object.toAddress()) {
                            shouldRelocateObject = false;
                            break;
                        }
                        relocationBlock.count = countInCurrentRelocationBlock;
                        countInCurrentRelocationBlock = 0;
                        relocationBlock = nextRelocationBlock;
                        relocationTarget = relocationBlock.start;
                    }
                }
                if (!shouldRelocateObject) {
                    if (!lastWasLocked) {
                        lastRelocationBlock.end = object.toAddress();
                        lastRelocationBlock = Structure.add(RelocationBlock.class, lastRelocationBlock, 1);
                        lastRelocationBlock.end = limit;
                        lastWasLocked = true;
                    }
                    lastRelocationBlock.start = object.toAddress().add(size);
                    lastRelocationBlock.count = 0;
                    object.classReference &= Integer.MAX_VALUE;
                } else {
                    lastWasLocked = false;
                    while (!relocations.add(Structure.sizeOf(Relocation.class)).isLessThan(relocationsLimit)) {
                        if (--freeChunks == 0) {
                            lastRelocationBlock.end = object.toAddress();
                            break block0;
                        }
                        freeChunkPointer = Structure.add(FreeChunkHolder.class, freeChunkPointer, 1);
                        freeChunk = freeChunkPointer.value;
                        relocations = Structure.add(FreeChunk.class, freeChunk, 1).toAddress();
                        relocationsLimit = freeChunk.toAddress().add(freeChunk.size);
                    }
                    Relocation relocation = (Relocation)relocations.toStructure();
                    relocation.classBackup = object.classReference;
                    relocation.sizeBackup = object.size;
                    relocation.newAddress = relocationTarget;
                    ++countInCurrentRelocationBlock;
                    relocations = relocations.add(Structure.sizeOf(Relocation.class));
                    long targetAddress = relocation.toAddress().toLong();
                    object.classReference = (int)(targetAddress >>> 33) | Integer.MIN_VALUE;
                    object.size = (int)(targetAddress >> 1);
                    relocationTarget = nextRelocationTarget;
                }
            } else {
                lastWasLocked = false;
            }
            object = (FreeChunk)object.toAddress().add(size).toStructure();
        }
        relocationBlock.count = countInCurrentRelocationBlock;
        while (object.toAddress().isLessThan(limit)) {
            size = GC.objectSize(object);
            if (object.classReference != 0) {
                object.classReference &= Integer.MAX_VALUE;
            } else {
                lastRelocationBlock = Structure.add(RelocationBlock.class, lastRelocationBlock, 1);
                lastRelocationBlock.start = object.toAddress();
                lastRelocationBlock.count = 0;
                lastRelocationBlock.end = lastRelocationBlock.start.add(size);
            }
            object = (FreeChunk)object.toAddress().add(size).toStructure();
        }
        GC.lastRelocationBlock = lastRelocationBlock;
    }

    private static void updatePointersFromStaticRoots() {
        Address staticRoots = Mutator.getStaticGCRoots();
        int staticCount = staticRoots.getInt();
        staticRoots = staticRoots.add(Address.sizeOf());
        while (staticCount-- > 0) {
            Address staticRoot = staticRoots.getAddress();
            staticRoot.putAddress(GC.updatePointer(staticRoot.getAddress()));
            staticRoots = staticRoots.add(Address.sizeOf());
        }
    }

    private static void updatePointersFromObjects() {
        Address start = GC.heapAddress();
        long heapSize = GC.availableBytes();
        Address limit = start.add(heapSize);
        FreeChunk object = (FreeChunk)GC.heapAddress().toStructure();
        while (object.toAddress().isLessThan(limit)) {
            int size;
            int classRef = object.classReference;
            if (classRef != 0) {
                Relocation relocation = GC.getRelocation(object.toAddress());
                if (relocation != null) {
                    classRef = relocation.classBackup;
                }
                RuntimeClass cls = RuntimeClass.unpack(classRef);
                RuntimeObject realObject = (RuntimeObject)object.toAddress().toStructure();
                GC.updatePointers(cls, realObject);
                size = GC.objectSize(realObject, cls);
            } else {
                size = object.size;
            }
            object = (FreeChunk)object.toAddress().add(size).toStructure();
        }
    }

    private static void updatePointers(RuntimeClass cls, RuntimeObject object) {
        if (cls.itemType == null) {
            GC.updatePointersInObject(cls, object);
        } else {
            GC.updatePointersInArray(cls, (RuntimeArray)object);
        }
    }

    private static void updatePointersInObject(RuntimeClass cls, RuntimeObject object) {
        while (cls != null) {
            int type = cls.flags >> 7 & 7;
            switch (type) {
                case 1: {
                    GC.updatePointersInWeakReference((RuntimeReference)object);
                    break;
                }
                case 2: {
                    GC.updatePointersInReferenceQueue((RuntimeReferenceQueue)object);
                    break;
                }
                default: {
                    GC.updatePointersInFields(cls, object);
                }
            }
            cls = cls.parent;
        }
    }

    private static void updatePointersInWeakReference(RuntimeReference object) {
        object.queue = (RuntimeReferenceQueue)GC.updatePointer(object.queue.toAddress()).toStructure();
        object.next = (RuntimeReference)GC.updatePointer(object.next.toAddress()).toStructure();
        object.object = (RuntimeObject)GC.updatePointer(object.object.toAddress()).toStructure();
    }

    private static void updatePointersInReferenceQueue(RuntimeReferenceQueue object) {
        object.first = (RuntimeReference)GC.updatePointer(object.first.toAddress()).toStructure();
        object.last = (RuntimeReference)GC.updatePointer(object.last.toAddress()).toStructure();
    }

    private static void updatePointersInFields(RuntimeClass cls, RuntimeObject object) {
        Address layout = cls.layout;
        if (layout != null) {
            short fieldCount = layout.getShort();
            while (true) {
                short s = fieldCount;
                fieldCount = (short)(fieldCount - 1);
                if (s <= 0) break;
                layout = layout.add(2);
                short fieldOffset = layout.getShort();
                Address referenceHolder = object.toAddress().add(fieldOffset);
                referenceHolder.putAddress(GC.updatePointer(referenceHolder.getAddress()));
            }
        }
    }

    private static void updatePointersInArray(RuntimeClass cls, RuntimeArray array) {
        if ((cls.itemType.flags & 2) != 0) {
            return;
        }
        Address base = Address.align(array.toAddress().add(RuntimeArray.class, 1), Address.sizeOf());
        int size = array.size;
        for (int i = 0; i < size; ++i) {
            base.putAddress(GC.updatePointer(base.getAddress()));
            base = base.add(Address.sizeOf());
        }
    }

    private static Address updatePointer(Address address) {
        if (address == null) {
            return null;
        }
        Relocation relocation = GC.getRelocation(address);
        return relocation != null ? relocation.newAddress : address;
    }

    private static Relocation getRelocation(Address address) {
        if (address.isLessThan(GC.heapAddress()) || !address.isLessThan(GC.heapAddress().add(GC.availableBytes()))) {
            return null;
        }
        FreeChunk obj = (FreeChunk)address.toStructure();
        if ((obj.classReference & Integer.MIN_VALUE) == 0) {
            return null;
        }
        long result = ((long)obj.classReference & 0xFFFFFFFFL) << 33 | ((long)obj.size & 0xFFFFFFFFL) << 1;
        return (Relocation)Address.fromLong(result).toStructure();
    }

    private static void restoreObjectHeaders() {
        Address start = GC.heapAddress();
        long heapSize = GC.availableBytes();
        Address limit = start.add(heapSize);
        FreeChunk freeChunk = GC.currentChunkPointer.value;
        FreeChunk object = (FreeChunk)freeChunk.toAddress().add(freeChunk.size).toStructure();
        while (object.toAddress().isLessThan(limit)) {
            Relocation relocation = GC.getRelocation(object.toAddress());
            if (relocation != null) {
                object.classReference = relocation.classBackup | Integer.MIN_VALUE;
                object.size = relocation.sizeBackup;
            }
            int size = GC.objectSize(object);
            object = (FreeChunk)object.toAddress().add(size).toStructure();
        }
    }

    private static void relocateObjects() {
        Address start = GC.heapAddress();
        long heapSize = GC.availableBytes();
        Address limit = start.add(heapSize);
        int freeChunks = GC.freeChunks;
        FreeChunk freeChunk = GC.currentChunkPointer.value;
        FreeChunk object = (FreeChunk)freeChunk.toAddress().add(freeChunk.size).toStructure();
        RelocationBlock relocationBlock = (RelocationBlock)Structure.add(FreeChunkHolder.class, currentChunkPointer, freeChunks).toAddress().toStructure();
        int countInRelocationBlock = relocationBlock.count;
        Address relocationTarget = relocationBlock.start;
        Address blockTarget = null;
        Address blockSource = null;
        int blockSize = 0;
        while (object.toAddress().isLessThan(limit)) {
            int size = GC.objectSize(object);
            if ((object.classReference & Integer.MIN_VALUE) != 0) {
                object.classReference &= Integer.MAX_VALUE;
                while (countInRelocationBlock == 0) {
                    if (blockSize != 0) {
                        Allocator.moveMemoryBlock(blockSource, blockTarget, blockSize);
                        MemoryTrace.move(blockSource, blockTarget, blockSize);
                        blockSource = null;
                        blockSize = 0;
                    }
                    relocationBlock.start = relocationTarget;
                    relocationBlock = Structure.add(RelocationBlock.class, relocationBlock, 1);
                    countInRelocationBlock = relocationBlock.count;
                    relocationTarget = relocationBlock.start;
                }
                if (blockSource == null) {
                    blockSource = object.toAddress();
                    blockTarget = relocationTarget;
                }
                relocationTarget = relocationTarget.add(size);
                blockSize += size;
                --countInRelocationBlock;
            } else if (blockSource != null) {
                Allocator.moveMemoryBlock(blockSource, blockTarget, blockSize);
                MemoryTrace.move(blockSource, blockTarget, blockSize);
                blockSource = null;
                blockSize = 0;
            }
            object = (FreeChunk)object.toAddress().add(size).toStructure();
        }
        relocationBlock.start = relocationTarget;
        if (blockSource != null) {
            Allocator.moveMemoryBlock(blockSource, blockTarget, blockSize);
            MemoryTrace.move(blockSource, blockTarget, blockSize);
        }
    }

    private static void putNewFreeChunks() {
        FreeChunkHolder freeChunkPointer = currentChunkPointer;
        RelocationBlock relocationBlock = (RelocationBlock)Structure.add(FreeChunkHolder.class, currentChunkPointer, freeChunks).toAddress().toStructure();
        freeChunks = 0;
        while (!lastRelocationBlock.toAddress().isLessThan(relocationBlock.toAddress())) {
            if (relocationBlock.start.isLessThan(relocationBlock.end)) {
                FreeChunk freeChunk = (FreeChunk)relocationBlock.start.toStructure();
                freeChunk.size = (int)(relocationBlock.end.toLong() - relocationBlock.start.toLong());
                freeChunk.classReference = 0;
                MemoryTrace.assertFree(freeChunk.toAddress(), freeChunk.size);
                freeChunkPointer.value = freeChunk;
                freeChunkPointer = Structure.add(FreeChunkHolder.class, freeChunkPointer, 1);
                ++freeChunks;
            }
            relocationBlock = Structure.add(RelocationBlock.class, relocationBlock, 1);
        }
    }

    private static void sortFreeChunks() {
        currentChunkPointer = (FreeChunkHolder)GC.gcStorageAddress().toStructure();
        GC.sortFreeChunks(0, freeChunks - 1);
    }

    private static void updateFreeMemory() {
        freeMemory = 0;
        FreeChunkHolder freeChunkPtr = currentChunkPointer;
        for (int i = 0; i < freeChunks; ++i) {
            freeMemory += freeChunkPtr.value.size;
            freeChunkPtr = Structure.add(FreeChunkHolder.class, freeChunkPtr, 1);
        }
    }

    private static void sortFreeChunks(int lower, int upper) {
        int start = lower;
        int end = upper;
        int mid = (lower + upper) / 2;
        int midSize = GC.getFreeChunk((int)mid).value.size;
        int firstSize = GC.getFreeChunk((int)lower).value.size;
        int lastSize = GC.getFreeChunk((int)upper).value.size;
        if (midSize < firstSize) {
            int tmp = firstSize;
            firstSize = midSize;
            midSize = tmp;
        }
        if (lastSize < firstSize) {
            lastSize = firstSize;
        }
        if (midSize > lastSize) {
            midSize = lastSize;
        }
        block0: while (lower != upper) {
            if (GC.getFreeChunk((int)lower).value.size > midSize) {
                ++lower;
                continue;
            }
            while (lower != upper) {
                if (GC.getFreeChunk((int)upper).value.size <= midSize) {
                    --upper;
                    continue;
                }
                FreeChunk tmp = GC.getFreeChunk((int)lower).value;
                GC.getFreeChunk((int)lower).value = GC.getFreeChunk((int)upper).value;
                GC.getFreeChunk((int)upper).value = tmp;
                continue block0;
            }
            break block0;
        }
        if (lower == end || upper == start) {
            return;
        }
        if (lower - start > 0) {
            GC.sortFreeChunks(start, lower);
        }
        if (end - lower - 1 > 0) {
            GC.sortFreeChunks(lower + 1, end);
        }
    }

    private static FreeChunkHolder getFreeChunk(int index) {
        return Structure.add(FreeChunkHolder.class, currentChunkPointer, index);
    }

    private static int objectSize(FreeChunk object) {
        if (object.classReference == 0) {
            return object.size;
        }
        RuntimeObject realObject = (RuntimeObject)object.toAddress().toStructure();
        RuntimeClass cls = RuntimeClass.getClass(realObject);
        return GC.objectSize(realObject, cls);
    }

    private static int objectSize(RuntimeObject object, RuntimeClass cls) {
        if (cls.itemType == null) {
            return cls.size;
        }
        int itemSize = (cls.itemType.flags & 2) == 0 ? Address.sizeOf() : cls.itemType.size;
        RuntimeArray array = (RuntimeArray)object.toAddress().toStructure();
        Address address = Address.fromInt(Structure.sizeOf(RuntimeArray.class));
        address = Address.align(address, itemSize);
        address = address.add(itemSize * array.size);
        address = Address.align(address, Address.sizeOf());
        return address.toInt();
    }

    private static boolean isMarked(RuntimeObject object) {
        return (object.classReference & Integer.MIN_VALUE) != 0;
    }

    static {
        freeMemory = (int)GC.availableBytes();
        currentChunk = (FreeChunk)GC.heapAddress().toStructure();
        GC.currentChunk.classReference = 0;
        GC.currentChunk.size = (int)GC.availableBytes();
        currentChunkLimit = currentChunk.toAddress().add(GC.currentChunk.size);
        currentChunkPointer = (FreeChunkHolder)GC.gcStorageAddress().toStructure();
        GC.currentChunkPointer.value = currentChunk;
        freeChunks = 1;
    }

    static class Region
    extends Structure {
        short start;

        Region() {
        }
    }
}

