/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.parsing.resource;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.teavm.parsing.resource.ResourceReader;

public class ClasspathResourceReader
implements ResourceReader {
    private ClassLoader classLoader;

    public ClasspathResourceReader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClasspathResourceReader() {
        this(ClasspathResourceReader.class.getClassLoader());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasResource(String name) {
        if (this.classLoader.getResource(name) == null) {
            return false;
        }
        try (InputStream input = this.classLoader.getResourceAsStream(name);){
            if (input == null) {
                boolean bl = false;
                return bl;
            }
            input.read();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public InputStream openResource(String name) throws IOException {
        InputStream result = this.classLoader.getResourceAsStream(name);
        return result != null ? new BufferedInputStream(result) : null;
    }
}

