/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.lowlevel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.teavm.model.AnnotationContainer;
import org.teavm.model.AnnotationContainerReader;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodReader;
import org.teavm.model.Program;
import org.teavm.model.lowlevel.CallSiteDescriptorAnnot;
import org.teavm.model.lowlevel.CallSiteDescriptorsAnnot;
import org.teavm.model.lowlevel.CallSiteLocation;
import org.teavm.model.lowlevel.ExceptionHandlerDescriptor;

public class CallSiteDescriptor {
    private int id;
    private List<ExceptionHandlerDescriptor> handlers = new ArrayList<ExceptionHandlerDescriptor>();
    private CallSiteLocation location;

    public CallSiteDescriptor(int id, CallSiteLocation location) {
        this.id = id;
        this.location = location;
    }

    public int getId() {
        return this.id;
    }

    public CallSiteLocation getLocation() {
        return this.location;
    }

    public List<ExceptionHandlerDescriptor> getHandlers() {
        return this.handlers;
    }

    public static void save(Collection<? extends CallSiteDescriptor> descriptors, AnnotationContainer annotations) {
        ArrayList<AnnotationValue> descriptorsValue = new ArrayList<AnnotationValue>();
        for (CallSiteDescriptor callSiteDescriptor : descriptors) {
            AnnotationHolder descriptorAnnot = new AnnotationHolder(CallSiteDescriptorAnnot.class.getName());
            descriptorAnnot.getValues().put("id", new AnnotationValue(callSiteDescriptor.id));
            descriptorAnnot.getValues().put("location", new AnnotationValue(callSiteDescriptor.location.save()));
            List<AnnotationValue> handlersValue = callSiteDescriptor.handlers.stream().map(h -> new AnnotationValue(h.save())).collect(Collectors.toList());
            descriptorAnnot.getValues().put("handlers", new AnnotationValue(handlersValue));
            descriptorsValue.add(new AnnotationValue(descriptorAnnot));
        }
        AnnotationHolder descriptorsAnnot = new AnnotationHolder(CallSiteDescriptorsAnnot.class.getName());
        descriptorsAnnot.getValues().put("value", new AnnotationValue(descriptorsValue));
        annotations.add(descriptorsAnnot);
    }

    public static Collection<? extends CallSiteDescriptor> load(AnnotationContainerReader annotations) {
        AnnotationReader descriptorsAnnot = annotations.get(CallSiteDescriptorsAnnot.class.getName());
        if (descriptorsAnnot == null) {
            return Collections.emptyList();
        }
        ArrayList<CallSiteDescriptor> descriptors = new ArrayList<CallSiteDescriptor>();
        for (AnnotationValue descriptorValue : descriptorsAnnot.getValue("value").getList()) {
            AnnotationReader descriptorAnnot = descriptorValue.getAnnotation();
            int id = descriptorAnnot.getValue("id").getInt();
            CallSiteLocation location = CallSiteLocation.load(descriptorAnnot.getValue("location").getAnnotation());
            List handlers = descriptorAnnot.getValue("handlers").getList().stream().map(a -> ExceptionHandlerDescriptor.load(a.getAnnotation())).collect(Collectors.toList());
            CallSiteDescriptor descriptor = new CallSiteDescriptor(id, location);
            descriptor.getHandlers().addAll(handlers);
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    public static List<? extends CallSiteDescriptor> extract(Program program) {
        ArrayList<CallSiteDescriptor> result = new ArrayList<CallSiteDescriptor>();
        CallSiteDescriptor.extractTo(CallSiteDescriptor.load(program.getAnnotations()), result);
        return result;
    }

    public static List<? extends CallSiteDescriptor> extract(ClassReaderSource classes, Collection<? extends String> classNames) {
        ArrayList<CallSiteDescriptor> result = new ArrayList<CallSiteDescriptor>();
        for (String string : classNames) {
            ClassReader cls = classes.get(string);
            if (cls == null) continue;
            for (MethodReader methodReader : cls.getMethods()) {
                if (methodReader.getProgram() == null) continue;
                CallSiteDescriptor.extractTo(CallSiteDescriptor.load(methodReader.getProgram().getAnnotations()), result);
            }
        }
        return result;
    }

    private static void extractTo(Collection<? extends CallSiteDescriptor> descriptors, List<CallSiteDescriptor> result) {
        for (CallSiteDescriptor callSiteDescriptor : descriptors) {
            if (callSiteDescriptor.id >= result.size()) {
                result.addAll(Collections.nCopies(callSiteDescriptor.id - result.size() + 1, null));
            }
            result.set(callSiteDescriptor.id, callSiteDescriptor);
        }
    }

    static AnnotationValue saveNullableString(String s) {
        return new AnnotationValue(s != null ? "1" + s : "0");
    }

    static String loadNullableString(AnnotationValue value) {
        String s = value.getString();
        return s.startsWith("0") ? null : s.substring(1);
    }
}

