/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.teavm.dependency.ConsumerWithNode;
import org.teavm.dependency.DependencyAnalyzer;
import org.teavm.dependency.DependencyConsumer;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.DependencyType;
import org.teavm.dependency.DependencyTypeFilter;
import org.teavm.dependency.Transition;
import org.teavm.hppc.ObjectArrayList;
import org.teavm.hppc.cursors.ObjectCursor;

class TypeSet {
    private static final int SMALL_TYPES_THRESHOLD = 3;
    static final DependencyType[] EMPTY_TYPES = new DependencyType[0];
    private DependencyAnalyzer dependencyAnalyzer;
    DependencyNode origin;
    private int[] smallTypes;
    private BitSet types;
    private int typesCount;
    Set<DependencyNode> domain = new LinkedHashSet<DependencyNode>();
    ObjectArrayList<Transition> transitions;
    ArrayList<ConsumerWithNode> consumers;

    TypeSet(DependencyAnalyzer dependencyAnalyzer, DependencyNode origin) {
        this.dependencyAnalyzer = dependencyAnalyzer;
        this.origin = origin;
        this.domain.add(origin);
    }

    void addType(DependencyType type) {
        if (this.types == null && this.smallTypes == null) {
            this.smallTypes = new int[]{type.index};
            return;
        }
        if (this.smallTypes != null) {
            if (this.smallTypes.length == 3) {
                this.types = new BitSet(this.dependencyAnalyzer.types.size() * 2);
                for (int existingType : this.smallTypes) {
                    this.types.set(existingType);
                }
                this.typesCount = this.smallTypes.length;
                this.smallTypes = null;
            } else {
                this.smallTypes = Arrays.copyOf(this.smallTypes, this.smallTypes.length + 1);
                this.smallTypes[this.smallTypes.length - 1] = type.index;
                return;
            }
        }
        this.types.set(type.index);
        ++this.typesCount;
    }

    DependencyType[] getTypes() {
        if (this.types != null) {
            DependencyType[] types = new DependencyType[this.types.cardinality()];
            int j = 0;
            int index = this.types.nextSetBit(0);
            while (index >= 0) {
                DependencyType type = this.dependencyAnalyzer.types.get(index);
                types[j++] = type;
                index = this.types.nextSetBit(index + 1);
            }
            return types;
        }
        if (this.smallTypes != null) {
            DependencyType[] types = new DependencyType[this.smallTypes.length];
            for (int i = 0; i < types.length; ++i) {
                DependencyType type;
                types[i] = type = this.dependencyAnalyzer.types.get(this.smallTypes[i]);
            }
            return types;
        }
        return EMPTY_TYPES;
    }

    DependencyType[] getTypesForNode(DependencyNode sourceNode, DependencyNode targetNode, DependencyTypeFilter filter) {
        DependencyType[] types;
        int j = 0;
        if (this.types != null) {
            int[] filteredTypes = null;
            if (this.typesCount > 15) {
                int[] nArray = filteredTypes = filter != null ? filter.tryExtract(this.types) : null;
                if (filteredTypes == null) {
                    filteredTypes = sourceNode.getFilter().tryExtract(this.types);
                }
                if (filteredTypes == null) {
                    filteredTypes = targetNode.getFilter().tryExtract(this.types);
                }
            }
            if (filteredTypes != null) {
                types = new DependencyType[filteredTypes.length];
                for (int index : filteredTypes) {
                    DependencyType type = this.dependencyAnalyzer.types.get(index);
                    if (!sourceNode.filter(type) || targetNode.hasType(type) || !targetNode.filter(type) || filter != null && !filter.match(type)) continue;
                    types[j++] = type;
                }
            } else {
                types = new DependencyType[this.typesCount];
                int index = this.types.nextSetBit(0);
                while (index >= 0) {
                    DependencyType type = this.dependencyAnalyzer.types.get(index);
                    if (sourceNode.filter(type) && !targetNode.hasType(type) && targetNode.filter(type) && (filter == null || filter.match(type))) {
                        types[j++] = type;
                    }
                    index = this.types.nextSetBit(index + 1);
                }
            }
        } else if (this.smallTypes != null) {
            types = new DependencyType[this.smallTypes.length];
            for (int i = 0; i < types.length; ++i) {
                DependencyType type = this.dependencyAnalyzer.types.get(this.smallTypes[i]);
                if (!sourceNode.filter(type) || targetNode.hasType(type) || !targetNode.filter(type) || filter != null && !filter.match(type)) continue;
                types[j++] = type;
            }
        } else {
            return EMPTY_TYPES;
        }
        if (j == 0) {
            return EMPTY_TYPES;
        }
        if (j < types.length) {
            types = Arrays.copyOf(types, j);
        }
        return types;
    }

    boolean hasType(DependencyType type) {
        if (this.smallTypes != null) {
            for (int i = 0; i < this.smallTypes.length; ++i) {
                if (this.smallTypes[i] != type.index) continue;
                return true;
            }
            return false;
        }
        return this.types != null && this.types.get(type.index);
    }

    boolean hasAnyType() {
        return this.types != null || this.smallTypes != null;
    }

    TypeSet copy(DependencyNode origin) {
        TypeSet result = new TypeSet(this.dependencyAnalyzer, origin);
        result.types = this.types != null ? (BitSet)this.types.clone() : null;
        result.smallTypes = this.smallTypes;
        result.typesCount = this.typesCount;
        return result;
    }

    void invalidate() {
        this.transitions = null;
        this.consumers = null;
    }

    ObjectArrayList<Transition> getTransitions() {
        if (this.transitions == null) {
            this.transitions = new ObjectArrayList(this.domain.size() * 2);
            for (DependencyNode node : this.domain) {
                if (node.transitions == null) continue;
                for (ObjectCursor<Transition> objectCursor : node.transitionList) {
                    Transition transition = (Transition)objectCursor.value;
                    if (transition.filter == null && transition.destination.typeSet == this) continue;
                    this.transitions.add(transition);
                }
            }
        }
        return this.transitions;
    }

    List<ConsumerWithNode> getConsumers() {
        if (this.consumers == null) {
            this.consumers = new ArrayList();
            for (DependencyNode node : this.domain) {
                if (node.followers == null) continue;
                this.consumers.add(new ConsumerWithNode(node.followers.toArray(new DependencyConsumer[0]), node));
            }
            this.consumers.trimToSize();
        }
        return this.consumers;
    }

    int typeCount() {
        return this.smallTypes != null ? this.smallTypes.length : (this.types != null ? this.typesCount : 0);
    }

    void cleanup() {
        this.origin = null;
        this.domain = null;
        this.transitions = null;
        this.consumers = null;
    }
}

