/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

import java.util.ArrayList;
import java.util.List;
import org.teavm.common.Graph;
import org.teavm.common.GraphBuilder;
import org.teavm.hppc.IntHashSet;
import org.teavm.hppc.IntSet;
import org.teavm.hppc.cursors.IntCursor;

public class MutableDirectedGraph
implements Graph {
    private List<IntSet> successors = new ArrayList<IntSet>();
    private List<IntSet> predecessors = new ArrayList<IntSet>();

    public MutableDirectedGraph() {
    }

    public MutableDirectedGraph(Graph graph) {
        int[] data = new int[graph.size()];
        for (int i = 0; i < graph.size(); ++i) {
            int sz = graph.copyOutgoingEdges(i, data);
            for (int j = 0; j < sz; ++j) {
                this.addEdge(i, data[j]);
            }
        }
    }

    public Graph copyToImmutable() {
        GraphBuilder builder = new GraphBuilder(this.successors.size());
        for (int i = 0; i < this.successors.size(); ++i) {
            for (IntCursor cursor : this.successors.get(i)) {
                builder.addEdge(i, cursor.value);
            }
        }
        return builder.build();
    }

    @Override
    public int size() {
        return this.successors.size();
    }

    public void addEdge(int from, int to) {
        int max = Math.max(from, to);
        while (max >= this.successors.size()) {
            this.successors.add(new IntHashSet(1));
            this.predecessors.add(new IntHashSet(1));
        }
        this.successors.get(from).add(to);
        this.predecessors.get(to).add(from);
    }

    public void deleteEdge(int from, int to) {
        if (from >= this.successors.size() || to >= this.successors.size()) {
            return;
        }
        this.successors.get(from).removeAll(to);
        this.predecessors.get(to).removeAll(from);
    }

    public void detachNode(int node) {
        for (IntCursor succ : this.successors.get(node)) {
            this.predecessors.get(succ.value).removeAll(node);
        }
        for (IntCursor pred : this.predecessors.get(node)) {
            this.successors.get(pred.value).removeAll(node);
        }
        this.predecessors.get(node).clear();
        this.successors.get(node).clear();
    }

    @Override
    public int[] incomingEdges(int node) {
        return this.predecessors.get(node).toArray();
    }

    @Override
    public int copyIncomingEdges(int node, int[] target) {
        int index = 0;
        for (IntCursor cursor : this.predecessors.get(node)) {
            target[index++] = cursor.value;
        }
        return index;
    }

    @Override
    public int[] outgoingEdges(int node) {
        return this.successors.get(node).toArray();
    }

    @Override
    public int copyOutgoingEdges(int node, int[] target) {
        int index = 0;
        for (IntCursor cursor : this.successors.get(node)) {
            target[index++] = cursor.value;
        }
        return index;
    }

    @Override
    public int incomingEdgesCount(int node) {
        return this.predecessors.get(node).size();
    }

    @Override
    public int outgoingEdgesCount(int node) {
        return this.successors.get(node).size();
    }
}

