/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.zip;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.teavm.classlib.java.util.zip.TDeflater;

public class TDeflaterOutputStream
extends FilterOutputStream {
    static final int BUF_SIZE = 512;
    protected byte[] buf;
    protected TDeflater def;
    boolean done;

    public TDeflaterOutputStream(OutputStream os, TDeflater def) {
        this(os, def, 512);
    }

    public TDeflaterOutputStream(OutputStream os) {
        this(os, new TDeflater());
    }

    public TDeflaterOutputStream(OutputStream os, TDeflater def, int bsize) {
        super(os);
        if (os == null || def == null) {
            throw new NullPointerException();
        }
        if (bsize <= 0) {
            throw new IllegalArgumentException();
        }
        this.def = def;
        this.buf = new byte[bsize];
    }

    protected void deflate() throws IOException {
        do {
            int x = this.def.deflate(this.buf);
            this.out.write(this.buf, 0, x);
        } while (!this.def.needsInput());
    }

    @Override
    public void close() throws IOException {
        if (!this.def.finished()) {
            this.finish();
        }
        this.def.end();
        this.out.close();
    }

    public void finish() throws IOException {
        if (this.done) {
            return;
        }
        this.def.finish();
        int x = 0;
        while (!this.def.finished()) {
            if (this.def.needsInput()) {
                this.def.setInput(this.buf, 0, 0);
            }
            x = this.def.deflate(this.buf);
            this.out.write(this.buf, 0, x);
        }
        this.done = true;
    }

    @Override
    public void write(int i) throws IOException {
        byte[] b = new byte[]{(byte)i};
        this.write(b, 0, 1);
    }

    @Override
    public void write(byte[] buffer, int off, int nbytes) throws IOException {
        if (this.done) {
            throw new IOException();
        }
        if (off <= buffer.length && nbytes >= 0 && off >= 0 && buffer.length - off >= nbytes) {
            if (!this.def.needsInput()) {
                throw new IOException();
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.def.setInput(buffer, off, nbytes);
        this.deflate();
    }
}

