/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.longimpl;

import java.util.PrimitiveIterator;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import org.teavm.classlib.java.util.stream.TLongStream;
import org.teavm.classlib.java.util.stream.longimpl.TSimpleLongStreamImpl;

public class TFlatMappingLongStreamImpl
extends TSimpleLongStreamImpl {
    private TSimpleLongStreamImpl sourceStream;
    private TLongStream current;
    private PrimitiveIterator.OfLong iterator;
    private LongFunction<? extends TLongStream> mapper;
    private boolean done;

    public TFlatMappingLongStreamImpl(TSimpleLongStreamImpl sourceStream, LongFunction<? extends TLongStream> mapper) {
        this.sourceStream = sourceStream;
        this.mapper = mapper;
    }

    @Override
    public boolean next(LongPredicate consumer) {
        while (true) {
            if (this.current == null) {
                if (this.done) {
                    return false;
                }
                boolean hasMore = this.sourceStream.next(e -> {
                    this.current = this.mapper.apply(e);
                    return false;
                });
                if (!hasMore) {
                    this.done = true;
                }
                if (this.current == null) {
                    this.done = true;
                    return false;
                }
            }
            if (this.current instanceof TSimpleLongStreamImpl) {
                TSimpleLongStreamImpl castCurrent = (TSimpleLongStreamImpl)this.current;
                if (castCurrent.next(consumer)) {
                    return true;
                }
                this.current = null;
                continue;
            }
            this.iterator = this.current.iterator();
            while (this.iterator.hasNext()) {
                long e2 = this.iterator.nextLong();
                if (consumer.test(e2)) continue;
                return true;
            }
            this.iterator = null;
            this.current = null;
        }
    }

    @Override
    public void close() throws Exception {
        this.current = null;
        this.iterator = null;
        this.sourceStream.close();
    }
}

