/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.intimpl;

import java.util.PrimitiveIterator;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import org.teavm.classlib.java.util.stream.TIntStream;
import org.teavm.classlib.java.util.stream.intimpl.TSimpleIntStreamImpl;

public class TFlatMappingIntStreamImpl
extends TSimpleIntStreamImpl {
    private TSimpleIntStreamImpl sourceStream;
    private TIntStream current;
    private PrimitiveIterator.OfInt iterator;
    private IntFunction<? extends TIntStream> mapper;
    private boolean done;

    public TFlatMappingIntStreamImpl(TSimpleIntStreamImpl sourceStream, IntFunction<? extends TIntStream> mapper) {
        this.sourceStream = sourceStream;
        this.mapper = mapper;
    }

    @Override
    public boolean next(IntPredicate consumer) {
        while (true) {
            if (this.current == null) {
                if (this.done) {
                    return false;
                }
                boolean hasMore = this.sourceStream.next(e -> {
                    this.current = this.mapper.apply(e);
                    return false;
                });
                if (!hasMore) {
                    this.done = true;
                }
                if (this.current == null) {
                    this.done = true;
                    return false;
                }
            }
            if (this.current instanceof TSimpleIntStreamImpl) {
                TSimpleIntStreamImpl castCurrent = (TSimpleIntStreamImpl)this.current;
                if (castCurrent.next(consumer)) {
                    return true;
                }
                this.current = null;
                continue;
            }
            this.iterator = this.current.iterator();
            while (this.iterator.hasNext()) {
                int e2 = this.iterator.nextInt();
                if (consumer.test(e2)) continue;
                return true;
            }
            this.iterator = null;
            this.current = null;
        }
    }

    @Override
    public void close() throws Exception {
        this.current = null;
        this.iterator = null;
        this.sourceStream.close();
    }
}

