/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.impl;

import java.util.PrimitiveIterator;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import org.teavm.classlib.java.util.stream.TDoubleStream;
import org.teavm.classlib.java.util.stream.doubleimpl.TSimpleDoubleStreamImpl;
import org.teavm.classlib.java.util.stream.impl.TSimpleStreamImpl;

public class TFlatMappingToDoubleStreamImpl<T>
extends TSimpleDoubleStreamImpl {
    private TSimpleStreamImpl<T> sourceStream;
    private TDoubleStream current;
    private PrimitiveIterator.OfDouble iterator;
    private Function<? super T, ? extends TDoubleStream> mapper;
    private boolean done;

    public TFlatMappingToDoubleStreamImpl(TSimpleStreamImpl<T> sourceStream, Function<? super T, ? extends TDoubleStream> mapper) {
        this.sourceStream = sourceStream;
        this.mapper = mapper;
    }

    @Override
    public boolean next(DoublePredicate consumer) {
        while (true) {
            if (this.current == null) {
                if (this.done) {
                    return false;
                }
                boolean hasMore = this.sourceStream.next((? super T e) -> {
                    this.current = this.mapper.apply(e);
                    return false;
                });
                if (!hasMore) {
                    this.done = true;
                }
                if (this.current == null) {
                    this.done = true;
                    return false;
                }
            }
            if (this.current instanceof TSimpleDoubleStreamImpl) {
                TSimpleDoubleStreamImpl castCurrent = (TSimpleDoubleStreamImpl)this.current;
                if (castCurrent.next(consumer)) {
                    return true;
                }
                this.current = null;
                continue;
            }
            this.iterator = this.current.iterator();
            while (this.iterator.hasNext()) {
                double e2 = this.iterator.nextDouble();
                if (consumer.test(e2)) continue;
                return true;
            }
            this.iterator = null;
            this.current = null;
        }
    }

    @Override
    public void close() throws Exception {
        this.current = null;
        this.iterator = null;
        this.sourceStream.close();
    }
}

