/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.jar;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import org.teavm.classlib.java.util.jar.TJarEntry;
import org.teavm.classlib.java.util.jar.TManifest;
import org.teavm.classlib.java.util.zip.TZipEntry;
import org.teavm.classlib.java.util.zip.TZipFile;

public class TJarFile
extends TZipFile {
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    static final String META_DIR = "META-INF/";
    private TManifest manifest;
    private TZipEntry manifestEntry;
    private boolean closed;

    public TJarFile(File file) throws IOException {
        this(file, true);
    }

    public TJarFile(File file, boolean verify) throws IOException {
        super(file);
        this.readMetaEntries();
    }

    public TJarFile(File file, boolean verify, int mode) throws IOException {
        super(file, mode);
        this.readMetaEntries();
    }

    public TJarFile(String filename) throws IOException {
        this(filename, true);
    }

    public TJarFile(String filename, boolean verify) throws IOException {
        super(filename);
        this.readMetaEntries();
    }

    public Enumeration<TJarEntry> entries() {
        class JarFileEnumerator
        implements Enumeration<TJarEntry> {
            Enumeration<? extends TZipEntry> ze;
            TJarFile jf;

            JarFileEnumerator(Enumeration<? extends TZipEntry> zenum, TJarFile jf) {
                this.ze = zenum;
                this.jf = jf;
            }

            @Override
            public boolean hasMoreElements() {
                return this.ze.hasMoreElements();
            }

            @Override
            public TJarEntry nextElement() {
                TJarEntry je = new TJarEntry(this.ze.nextElement());
                je.parentJar = this.jf;
                return je;
            }
        }
        return new JarFileEnumerator(super.entries(), this);
    }

    public TJarEntry getJarEntry(String name) {
        return (TJarEntry)this.getEntry(name);
    }

    public TManifest getManifest() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("JarFile has been closed");
        }
        if (this.manifest != null) {
            return this.manifest;
        }
        try {
            try (InputStream is = super.getInputStream(this.manifestEntry);){
                this.manifest = new TManifest(is, false);
            }
            this.manifestEntry = null;
        }
        catch (NullPointerException e) {
            this.manifestEntry = null;
        }
        return this.manifest;
    }

    private void readMetaEntries() throws IOException {
        TZipEntry[] metaEntries = this.getMetaEntriesImpl();
        if (metaEntries == null) {
            return;
        }
        boolean signed = false;
        for (TZipEntry entry : metaEntries) {
            String entryName = entry.getName();
            if (this.manifestEntry != null || !MANIFEST_NAME.equalsIgnoreCase(entryName)) continue;
            this.manifestEntry = entry;
            break;
        }
    }

    @Override
    public InputStream getInputStream(TZipEntry ze) throws IOException {
        if (this.manifestEntry != null) {
            this.getManifest();
        }
        return super.getInputStream(ze);
    }

    @Override
    public TZipEntry getEntry(String name) {
        TZipEntry ze = super.getEntry(name);
        if (ze == null) {
            return ze;
        }
        TJarEntry je = new TJarEntry(ze);
        je.parentJar = this;
        return je;
    }

    private TZipEntry[] getMetaEntriesImpl() {
        ArrayList<TZipEntry> list = new ArrayList<TZipEntry>(8);
        Enumeration<TJarEntry> allEntries = this.entries();
        while (allEntries.hasMoreElements()) {
            TZipEntry ze = allEntries.nextElement();
            if (!ze.getName().startsWith(META_DIR) || ze.getName().length() <= META_DIR.length()) continue;
            list.add(ze);
        }
        if (list.size() == 0) {
            return null;
        }
        TZipEntry[] result = new TZipEntry[list.size()];
        list.toArray(result);
        return result;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.closed = true;
    }

    static final class JarFileInputStream
    extends FilterInputStream {
        private long count;
        private TZipEntry zipEntry;
        private boolean done;

        JarFileInputStream(InputStream is, TZipEntry ze) {
            super(is);
            this.zipEntry = ze;
            this.count = this.zipEntry.getSize();
        }

        @Override
        public int read() throws IOException {
            if (this.done) {
                return -1;
            }
            if (this.count > 0L) {
                int r = super.read();
                this.count = r != -1 ? --this.count : 0L;
                if (this.count == 0L) {
                    this.done = true;
                }
                return r;
            }
            this.done = true;
            return -1;
        }

        @Override
        public int read(byte[] buf, int off, int nbytes) throws IOException {
            if (this.done) {
                return -1;
            }
            if (this.count > 0L) {
                int r = super.read(buf, off, nbytes);
                if (r != -1) {
                    int size = r;
                    if (this.count < (long)size) {
                        size = (int)this.count;
                    }
                    this.count -= (long)size;
                } else {
                    this.count = 0L;
                }
                if (this.count == 0L) {
                    this.done = true;
                }
                return r;
            }
            this.done = true;
            return -1;
        }

        @Override
        public int available() throws IOException {
            if (this.done) {
                return 0;
            }
            return super.available();
        }
    }
}

