/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.text;

import java.util.ArrayList;
import org.teavm.classlib.java.text.TDecimalFormat;

class TDecimalFormatParser {
    private TDecimalFormat.FormatField[] positivePrefix;
    private TDecimalFormat.FormatField[] positiveSuffix;
    private TDecimalFormat.FormatField[] negativePrefix;
    private TDecimalFormat.FormatField[] negativeSuffix;
    private int groupSize;
    private int minimumIntLength;
    private int intLength;
    private int minimumFracLength;
    private int fracLength;
    private int exponentLength;
    private boolean decimalSeparatorRequired;
    private String string;
    private int index;
    private int multiplier;

    TDecimalFormatParser() {
    }

    public void parse(String string) {
        this.groupSize = 0;
        this.minimumFracLength = 0;
        this.fracLength = 0;
        this.exponentLength = 0;
        this.decimalSeparatorRequired = false;
        this.multiplier = 1;
        this.string = string;
        this.index = 0;
        this.positivePrefix = this.parseText(false, false);
        if (this.index == string.length()) {
            throw new IllegalArgumentException("Positive number pattern not found in " + string);
        }
        this.parseNumber(true);
        this.negativePrefix = null;
        this.negativeSuffix = null;
        if (this.index < string.length() && string.charAt(this.index) != ';') {
            this.positiveSuffix = this.parseText(true, false);
        }
        if (this.index < string.length()) {
            if (string.charAt(this.index++) != ';') {
                throw new IllegalArgumentException("Expected ';' at " + this.index + " in " + string);
            }
            this.negativePrefix = this.parseText(false, true);
            this.parseNumber(false);
            this.negativeSuffix = this.parseText(true, true);
        }
    }

    public void apply(TDecimalFormat format) {
        format.positivePrefix = this.positivePrefix;
        format.positiveSuffix = this.positiveSuffix;
        if (this.negativePrefix != null) {
            format.negativePrefix = this.negativePrefix;
        } else {
            format.negativePrefix = new TDecimalFormat.FormatField[this.positivePrefix.length + 1];
            System.arraycopy(this.positivePrefix, 0, format.negativePrefix, 1, this.positivePrefix.length);
            format.negativePrefix[0] = new TDecimalFormat.MinusField();
        }
        format.negativeSuffix = this.negativeSuffix != null ? this.negativeSuffix : this.positiveSuffix;
        format.setGroupingSize(this.groupSize);
        format.setGroupingUsed(this.groupSize > 0);
        format.setMinimumIntegerDigits(!this.decimalSeparatorRequired ? this.minimumIntLength : Math.max(1, this.minimumIntLength));
        format.setMaximumIntegerDigits(this.intLength);
        format.setMinimumFractionDigits(this.minimumFracLength);
        format.setMaximumFractionDigits(this.fracLength);
        format.setDecimalSeparatorAlwaysShown(this.decimalSeparatorRequired);
        format.exponentDigits = this.exponentLength;
        format.setMultiplier(this.multiplier);
    }

    TDecimalFormat.FormatField[] parseText(boolean suffix, boolean end) {
        ArrayList<TDecimalFormat.FormatField> fields = new ArrayList<TDecimalFormat.FormatField>();
        StringBuilder sb = new StringBuilder();
        block10: while (this.index < this.string.length()) {
            char c = this.string.charAt(this.index);
            switch (c) {
                case '#': 
                case '0': {
                    if (!suffix) break block10;
                    throw new IllegalArgumentException("Prefix contains special character at " + this.index + " in " + this.string);
                }
                case ';': {
                    if (!end) break block10;
                    throw new IllegalArgumentException("Prefix contains special character at " + this.index + " in " + this.string);
                }
                case '.': 
                case 'E': {
                    throw new IllegalArgumentException("Prefix contains special character at " + this.index + " in " + this.string);
                }
                case '\'': {
                    ++this.index;
                    int next = this.string.indexOf(39, this.index);
                    if (next < 0) {
                        throw new IllegalArgumentException("Quote opened at " + this.index + " was not closed in " + this.string);
                    }
                    if (next == this.index) {
                        sb.append('\'');
                    } else {
                        sb.append(this.string.substring(this.index, next));
                    }
                    this.index = next + 1;
                    continue block10;
                }
                case '\u00a4': {
                    if (sb.length() > 0) {
                        fields.add(new TDecimalFormat.TextField(sb.toString()));
                        sb.setLength(0);
                    }
                    fields.add(new TDecimalFormat.CurrencyField());
                    ++this.index;
                    continue block10;
                }
                case '%': {
                    if (sb.length() > 0) {
                        fields.add(new TDecimalFormat.TextField(sb.toString()));
                        sb.setLength(0);
                    }
                    fields.add(new TDecimalFormat.PercentField());
                    ++this.index;
                    this.multiplier = 100;
                    continue block10;
                }
                case '\u2030': {
                    if (sb.length() > 0) {
                        fields.add(new TDecimalFormat.TextField(sb.toString()));
                        sb.setLength(0);
                    }
                    fields.add(new TDecimalFormat.PerMillField());
                    ++this.index;
                    this.multiplier = 1000;
                    continue block10;
                }
                case '-': {
                    if (sb.length() > 0) {
                        fields.add(new TDecimalFormat.TextField(sb.toString()));
                        sb.setLength(0);
                    }
                    fields.add(new TDecimalFormat.MinusField());
                    ++this.index;
                    continue block10;
                }
                default: {
                    sb.append(c);
                    ++this.index;
                    continue block10;
                }
            }
        }
        if (sb.length() > 0) {
            fields.add(new TDecimalFormat.TextField(sb.toString()));
        }
        return fields.toArray(new TDecimalFormat.FormatField[fields.size()]);
    }

    private void parseNumber(boolean apply) {
        this.parseIntegerPart(apply);
        if (this.index < this.string.length() && this.string.charAt(this.index) == '.') {
            ++this.index;
            this.parseFractionalPart(apply);
        }
        if (this.index < this.string.length() && this.string.charAt(this.index) == 'E') {
            ++this.index;
            this.parseExponent(apply);
        }
    }

    private void parseIntegerPart(boolean apply) {
        int start = this.index;
        int lastGroup = this.index;
        boolean optionalDigits = true;
        int length = 0;
        int minimumLength = 0;
        block5: while (this.index < this.string.length()) {
            switch (this.string.charAt(this.index)) {
                case '#': {
                    if (!optionalDigits) {
                        throw new IllegalArgumentException("Unexpected '#' at non-optional digit part at " + this.index + " in " + this.string);
                    }
                    ++length;
                    break;
                }
                case ',': {
                    if (lastGroup == this.index) {
                        throw new IllegalArgumentException("Two group separators at " + this.index + " in " + this.string);
                    }
                    if (apply) {
                        this.groupSize = this.index - lastGroup;
                    }
                    lastGroup = this.index + 1;
                    break;
                }
                case '0': {
                    optionalDigits = false;
                    ++length;
                    ++minimumLength;
                    break;
                }
                default: {
                    break block5;
                }
            }
            ++this.index;
        }
        if (length == 0) {
            throw new IllegalArgumentException("Pattern does not specify integer digits at " + this.index + " in " + this.string);
        }
        if (lastGroup == this.index) {
            throw new IllegalArgumentException("Group separator at the end of number at " + this.index + " in " + this.string);
        }
        if (apply && lastGroup > start) {
            this.groupSize = this.index - lastGroup;
        }
        if (apply) {
            this.intLength = length;
            this.minimumIntLength = minimumLength;
        }
    }

    private void parseFractionalPart(boolean apply) {
        boolean optionalDigits = false;
        int length = 0;
        int minimumLength = 0;
        block6: while (this.index < this.string.length()) {
            switch (this.string.charAt(this.index)) {
                case '#': {
                    ++length;
                    optionalDigits = true;
                    break;
                }
                case ',': {
                    throw new IllegalArgumentException("Group separator found at fractional part at " + this.index + " in " + this.string);
                }
                case '0': {
                    if (optionalDigits) {
                        throw new IllegalArgumentException("Unexpected '0' at optional digit part at " + this.index + " in " + this.string);
                    }
                    ++length;
                    ++minimumLength;
                    break;
                }
                case '.': {
                    throw new IllegalArgumentException("Unexpected second decimal separator at " + this.index + " in " + this.string);
                }
                default: {
                    break block6;
                }
            }
            ++this.index;
        }
        if (apply) {
            this.fracLength = length;
            this.minimumFracLength = minimumLength;
            this.decimalSeparatorRequired = length == 0;
        }
    }

    private void parseExponent(boolean apply) {
        int length = 0;
        block4: while (this.index < this.string.length()) {
            switch (this.string.charAt(this.index)) {
                case '#': 
                case ',': 
                case '.': 
                case 'E': {
                    throw new IllegalArgumentException("Unexpected char at exponent at " + this.index + " in " + this.string);
                }
                case '0': {
                    ++length;
                    break;
                }
                default: {
                    break block4;
                }
            }
            ++this.index;
        }
        if (length == 0) {
            throw new IllegalArgumentException("Pattern does not specify exponent digits at " + this.index + " in " + this.string);
        }
        if (apply) {
            this.exponentLength = length;
        }
    }
}

