/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.io;

import java.io.IOException;
import org.teavm.classlib.java.io.TReader;
import org.teavm.classlib.java.lang.TIllegalArgumentException;
import org.teavm.classlib.java.lang.TMath;
import org.teavm.classlib.java.lang.TStringBuilder;
import org.teavm.classlib.java.util.TArrays;

public class TBufferedReader
extends TReader {
    private TReader innerReader;
    private char[] buffer;
    private int index;
    private int count;
    private boolean eof;
    private int mark = -1;

    public TBufferedReader(TReader innerReader, int size) {
        if (size < 0) {
            throw new TIllegalArgumentException();
        }
        this.innerReader = innerReader;
        this.buffer = new char[TMath.max(64, size)];
    }

    public TBufferedReader(TReader innerReader) {
        this(innerReader, 1024);
    }

    @Override
    public int read() throws IOException {
        this.requireOpened();
        if (this.index >= this.count && !this.fillBuffer(0)) {
            return -1;
        }
        return this.buffer[this.index++];
    }

    @Override
    public void close() throws IOException {
        this.requireOpened();
        this.innerReader.close();
        this.innerReader = null;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int charsRead;
        int n;
        this.requireOpened();
        if (this.index == this.count && this.eof) {
            return -1;
        }
        for (charsRead = 0; charsRead < len; charsRead += n) {
            n = TMath.min(this.count - this.index, len - charsRead);
            for (int i = 0; i < n; ++i) {
                cbuf[off++] = this.buffer[this.index++];
            }
            if (this.fillBuffer(0)) continue;
            break;
        }
        return charsRead;
    }

    public String readLine() throws IOException {
        char ch;
        this.requireOpened();
        if (this.eof && this.index >= this.count) {
            return null;
        }
        TStringBuilder line = new TStringBuilder();
        while ((this.index < this.count || this.fillBuffer(0)) && (ch = this.buffer[this.index++]) != '\n') {
            if (ch == '\r') {
                if (this.index >= this.count && !this.fillBuffer(0) || this.buffer[this.index] != '\n') break;
                ++this.index;
                break;
            }
            line.append(ch);
        }
        return line.toString();
    }

    @Override
    public long skip(long n) throws IOException {
        this.requireOpened();
        if (n < (long)(this.count - this.index)) {
            this.index = (int)((long)this.index + n);
            return n;
        }
        long skipped = this.innerReader.skip(n -= (long)(this.count - this.index));
        if (skipped == n) {
            this.fillBuffer(0);
        } else {
            this.eof = true;
        }
        return skipped;
    }

    @Override
    public boolean ready() {
        return this.index < this.count;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        if (readAheadLimit > this.buffer.length) {
            this.buffer = TArrays.copyOf(this.buffer, readAheadLimit);
        }
        if (this.count - this.index < readAheadLimit) {
            for (int i = this.index; i < this.count; ++i) {
                this.buffer[i - this.index] = this.buffer[i];
            }
            this.fillBuffer(this.count - this.index);
        }
        this.mark = this.index;
    }

    @Override
    public void reset() throws IOException {
        if (this.mark == -1) {
            throw new IOException();
        }
        this.index = this.mark;
    }

    private boolean fillBuffer(int offset) throws IOException {
        if (this.eof) {
            return false;
        }
        while (offset < this.buffer.length) {
            int charsRead = this.innerReader.read(this.buffer, offset, this.buffer.length - offset);
            if (charsRead == -1) {
                this.eof = true;
                break;
            }
            if (charsRead == 0) break;
            offset += charsRead;
        }
        this.count = offset;
        this.index = 0;
        this.mark = -1;
        return true;
    }

    private void requireOpened() throws IOException {
        if (this.innerReader == null) {
            throw new IOException();
        }
    }
}

