/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.tz;

import org.teavm.classlib.impl.Base46;
import org.teavm.classlib.impl.CharFlow;
import org.teavm.classlib.impl.tz.DateTimeZone;
import org.teavm.classlib.impl.tz.DateTimeZoneBuilder;
import org.teavm.classlib.impl.tz.FixedDateTimeZone;

public abstract class StorableDateTimeZone
extends DateTimeZone {
    public static final int PRECALCULATED = 0;
    public static final int FIXED = 1;
    public static final int DST = 3;
    public static final int ALIAS = 4;

    public StorableDateTimeZone(String id) {
        super(id);
    }

    public abstract void write(StringBuilder var1);

    public static void writeTime(StringBuilder sb, long time) {
        if (time % 1800000L == 0L) {
            Base46.encode(sb, (int)(time / 1800000L << 1));
        } else {
            Base46.encode(sb, (int)(time / 60000L << 1 | 1L));
        }
    }

    public static long readTime(CharFlow flow) {
        long value = Base46.decodeLong(flow);
        if ((value & 1L) == 0L) {
            return (value >> 1) * 1800000L;
        }
        return (value >> 1) * 60000L;
    }

    public static void writeUnsignedTime(StringBuilder sb, long time) {
        if (time % 1800000L == 0L) {
            Base46.encodeUnsigned(sb, (int)(time / 1800000L << 1));
        } else {
            Base46.encodeUnsigned(sb, (int)(time / 60000L << 1 | 1L));
        }
    }

    public static long readUnsignedTime(CharFlow flow) {
        long value = Base46.decodeUnsignedLong(flow);
        if ((value & 1L) == 0L) {
            return (value >>> 1) * 1800000L;
        }
        return (value >>> 1) * 60000L;
    }

    public static void writeTimeArray(StringBuilder sb, int[] timeArray) {
        int last = 0;
        for (int i = 1; i < timeArray.length; ++i) {
            int j;
            for (j = i + 1; j < timeArray.length && timeArray[i] == timeArray[j]; ++j) {
            }
            if (j - i < 3) continue;
            if (i > last) {
                Base46.encode(sb, ~(i - last));
                while (last < i) {
                    StorableDateTimeZone.writeTime(sb, timeArray[last++]);
                }
            }
            Base46.encode(sb, j - i);
            StorableDateTimeZone.writeTime(sb, timeArray[i]);
            last = j;
            i = j;
        }
        if (timeArray.length > last) {
            Base46.encode(sb, ~(timeArray.length - last));
            while (last < timeArray.length) {
                StorableDateTimeZone.writeTime(sb, timeArray[last++]);
            }
        }
    }

    public static void readTimeArray(CharFlow flow, int[] array) {
        int index = 0;
        while (index < array.length) {
            int count = Base46.decode(flow);
            if (count >= 0) {
                int t = (int)StorableDateTimeZone.readTime(flow);
                while (count-- > 0) {
                    array[index++] = t;
                }
                continue;
            }
            count ^= 0xFFFFFFFF;
            while (count-- > 0) {
                array[index++] = (int)StorableDateTimeZone.readTime(flow);
            }
        }
    }

    public static StorableDateTimeZone read(String id, String text) {
        CharFlow flow = new CharFlow(text.toCharArray());
        int type = Base46.decodeUnsigned(flow);
        switch (type) {
            case 0: {
                return DateTimeZoneBuilder.PrecalculatedZone.readZone(id, flow);
            }
            case 3: {
                return DateTimeZoneBuilder.DSTZone.readZone(id, flow);
            }
            case 1: {
                return FixedDateTimeZone.readZone(id, flow);
            }
        }
        throw new IllegalArgumentException("Unknown zone type: " + type);
    }
}

