/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import java.util.Arrays;
import org.teavm.common.DisjointSet;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassHolderTransformerContext;
import org.teavm.model.Instruction;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.StringConstantInstruction;

public class ClassForNameTransformer
implements ClassHolderTransformer {
    private static final MethodReference getNameMethod = new MethodReference(Class.class, "getName", String.class);
    private static final MethodReference forNameMethod = new MethodReference(Class.class, "forName", String.class, Boolean.TYPE, ClassLoader.class, Class.class);
    private static final MethodReference forNameShortMethod = new MethodReference(Class.class, "forName", String.class, Class.class);
    private static final MethodReference initMethod = new MethodReference(Class.class, "initialize", Void.TYPE);

    @Override
    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        for (MethodHolder method : cls.getMethods()) {
            Program program = method.getProgram();
            if (program == null) continue;
            this.transformProgram(program, context.getHierarchy());
        }
    }

    private void transformProgram(Program program, ClassHierarchy hierarchy) {
        if (!this.hasForNameCall(program)) {
            return;
        }
        DisjointSet varSet = new DisjointSet();
        for (int i = 0; i < program.variableCount(); ++i) {
            varSet.create();
        }
        int[] nameIndexes = new int[program.variableCount()];
        String[] constants = new String[program.variableCount()];
        Arrays.fill(nameIndexes, -1);
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Instruction instruction : block) {
                if (instruction instanceof InvokeInstruction) {
                    InvokeInstruction invoke = (InvokeInstruction)instruction;
                    if (!invoke.getMethod().equals(getNameMethod) || invoke.getReceiver() == null) continue;
                    nameIndexes[invoke.getReceiver().getIndex()] = invoke.getInstance().getIndex();
                    continue;
                }
                if (instruction instanceof StringConstantInstruction) {
                    StringConstantInstruction stringConstant = (StringConstantInstruction)instruction;
                    constants[stringConstant.getReceiver().getIndex()] = stringConstant.getConstant();
                    continue;
                }
                if (!(instruction instanceof AssignInstruction)) continue;
                AssignInstruction assign = (AssignInstruction)instruction;
                varSet.union(assign.getAssignee().getIndex(), assign.getReceiver().getIndex());
            }
        }
        nameIndexes = Arrays.copyOf(nameIndexes, varSet.size());
        int[] nameRepresentatives = new int[nameIndexes.length];
        Arrays.fill(nameRepresentatives, -1);
        String[] constantsByClasses = new String[varSet.size()];
        for (int i = 0; i < program.variableCount(); ++i) {
            int varClass = varSet.find(i);
            if (nameRepresentatives[varClass] < 0) {
                nameRepresentatives[varClass] = i;
            }
            if (nameIndexes[i] >= 0) {
                nameIndexes[varClass] = varSet.find(nameIndexes[i]);
            }
            constantsByClasses[varClass] = constants[i];
        }
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Instruction instruction : block) {
                Variable representative;
                InvokeInstruction invoke;
                if (!(instruction instanceof InvokeInstruction) || !(invoke = (InvokeInstruction)instruction).getMethod().equals(forNameMethod) && !invoke.getMethod().equals(forNameShortMethod)) continue;
                int classNameIndex = invoke.getArguments().get(0).getIndex();
                int nameIndex = nameIndexes[classNameIndex];
                String constant = constantsByClasses[invoke.getArguments().get(0).getIndex()];
                if (nameIndex >= 0) {
                    representative = program.variableAt(nameRepresentatives[nameIndex]);
                } else {
                    if (constant == null || hierarchy.getClassSource().get(constant) == null || !this.filterClassName(constant)) continue;
                    ClassConstantInstruction classConstant = new ClassConstantInstruction();
                    classConstant.setConstant(ValueType.object(constant));
                    classConstant.setReceiver(program.createVariable());
                    classConstant.setLocation(invoke.getLocation());
                    invoke.insertPrevious(classConstant);
                    representative = classConstant.getReceiver();
                }
                InvokeInstruction initInvoke = new InvokeInstruction();
                initInvoke.setLocation(invoke.getLocation());
                initInvoke.setType(InvocationType.SPECIAL);
                initInvoke.setMethod(initMethod);
                initInvoke.setInstance(representative);
                invoke.insertPrevious(initInvoke);
                if (invoke.getReceiver() == null) {
                    invoke.delete();
                    continue;
                }
                AssignInstruction assign = new AssignInstruction();
                assign.setLocation(invoke.getLocation());
                assign.setAssignee(representative);
                assign.setReceiver(invoke.getReceiver());
                invoke.replace(assign);
            }
        }
    }

    private boolean hasForNameCall(Program program) {
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Instruction instruction : block) {
                InvokeInstruction invoke;
                if (!(instruction instanceof InvokeInstruction) || !(invoke = (InvokeInstruction)instruction).getMethod().equals(forNameMethod) && !invoke.getMethod().equals(forNameShortMethod)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean filterClassName(String className) {
        switch (className) {
            case "kotlin.reflect.jvm.internal.ReflectionFactoryImpl": {
                return false;
            }
        }
        return true;
    }
}

