/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.teavm.ast.AsyncMethodNode;
import org.teavm.ast.ControlFlowEntry;
import org.teavm.ast.RegularMethodNode;
import org.teavm.ast.analysis.LocationGraphBuilder;
import org.teavm.ast.decompilation.DecompilationException;
import org.teavm.ast.decompilation.Decompiler;
import org.teavm.backend.javascript.ProviderContext;
import org.teavm.backend.javascript.TeaVMJavaScriptHost;
import org.teavm.backend.javascript.codegen.AliasProvider;
import org.teavm.backend.javascript.codegen.DefaultAliasProvider;
import org.teavm.backend.javascript.codegen.DefaultNamingStrategy;
import org.teavm.backend.javascript.codegen.MinifyingAliasProvider;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.codegen.SourceWriterBuilder;
import org.teavm.backend.javascript.decompile.PreparedClass;
import org.teavm.backend.javascript.decompile.PreparedMethod;
import org.teavm.backend.javascript.rendering.Renderer;
import org.teavm.backend.javascript.rendering.RenderingContext;
import org.teavm.backend.javascript.rendering.RuntimeRenderer;
import org.teavm.backend.javascript.spi.GeneratedBy;
import org.teavm.backend.javascript.spi.Generator;
import org.teavm.backend.javascript.spi.InjectedBy;
import org.teavm.backend.javascript.spi.Injector;
import org.teavm.backend.javascript.spi.VirtualMethodContributor;
import org.teavm.backend.javascript.spi.VirtualMethodContributorContext;
import org.teavm.cache.AstCacheEntry;
import org.teavm.cache.AstDependencyExtractor;
import org.teavm.cache.CacheStatus;
import org.teavm.cache.EmptyMethodNodeCache;
import org.teavm.cache.MethodNodeCache;
import org.teavm.debugging.information.DebugInformationEmitter;
import org.teavm.debugging.information.DummyDebugInformationEmitter;
import org.teavm.debugging.information.SourceLocation;
import org.teavm.dependency.AbstractDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyAnalyzer;
import org.teavm.dependency.DependencyListener;
import org.teavm.dependency.DependencyType;
import org.teavm.dependency.MethodDependency;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.interop.PlatformMarker;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.BasicBlock;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReference;
import org.teavm.model.ListableClassHolderSource;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.TextLocation;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.util.AsyncMethodFinder;
import org.teavm.model.util.ProgramUtils;
import org.teavm.vm.BuildTarget;
import org.teavm.vm.RenderingException;
import org.teavm.vm.TeaVMEntryPoint;
import org.teavm.vm.TeaVMTarget;
import org.teavm.vm.TeaVMTargetController;
import org.teavm.vm.spi.RendererListener;
import org.teavm.vm.spi.TeaVMHostExtension;

public class JavaScriptTarget
implements TeaVMTarget,
TeaVMJavaScriptHost {
    private static final NumberFormat STATS_NUM_FORMAT = new DecimalFormat("#,##0");
    private static final NumberFormat STATS_PERCENT_FORMAT = new DecimalFormat("0.000 %");
    private static final MethodReference CURRENT_THREAD = new MethodReference(Thread.class, "currentThread", Thread.class);
    private TeaVMTargetController controller;
    private boolean minifying = true;
    private boolean stackTraceIncluded;
    private final Map<MethodReference, Generator> methodGenerators = new HashMap<MethodReference, Generator>();
    private final Map<MethodReference, Injector> methodInjectors = new HashMap<MethodReference, Injector>();
    private final List<Function<ProviderContext, Generator>> generatorProviders = new ArrayList<Function<ProviderContext, Generator>>();
    private final List<Function<ProviderContext, Injector>> injectorProviders = new ArrayList<Function<ProviderContext, Injector>>();
    private final List<RendererListener> rendererListeners = new ArrayList<RendererListener>();
    private DebugInformationEmitter debugEmitter;
    private MethodNodeCache astCache = EmptyMethodNodeCache.INSTANCE;
    private final Set<MethodReference> asyncMethods = new HashSet<MethodReference>();
    private final Set<MethodReference> asyncFamilyMethods = new HashSet<MethodReference>();
    private List<VirtualMethodContributor> customVirtualMethods = new ArrayList<VirtualMethodContributor>();
    private int topLevelNameLimit = 10000;
    private AstDependencyExtractor dependencyExtractor = new AstDependencyExtractor();

    @Override
    public List<ClassHolderTransformer> getTransformers() {
        return Collections.emptyList();
    }

    @Override
    public List<DependencyListener> getDependencyListeners() {
        return Collections.emptyList();
    }

    @Override
    public void setController(TeaVMTargetController controller) {
        this.controller = controller;
    }

    @Override
    public void add(RendererListener listener) {
        this.rendererListeners.add(listener);
    }

    @Override
    public void add(MethodReference methodRef, Generator generator) {
        this.methodGenerators.put(methodRef, generator);
    }

    @Override
    public void add(MethodReference methodRef, Injector injector) {
        this.methodInjectors.put(methodRef, injector);
    }

    @Override
    public void addGeneratorProvider(Function<ProviderContext, Generator> provider) {
        this.generatorProviders.add(provider);
    }

    @Override
    public void addInjectorProvider(Function<ProviderContext, Injector> provider) {
        this.injectorProviders.add(provider);
    }

    public boolean isMinifying() {
        return this.minifying;
    }

    public void setMinifying(boolean minifying) {
        this.minifying = minifying;
    }

    public MethodNodeCache getAstCache() {
        return this.astCache;
    }

    public void setAstCache(MethodNodeCache methodAstCache) {
        this.astCache = methodAstCache;
    }

    public DebugInformationEmitter getDebugEmitter() {
        return this.debugEmitter;
    }

    public void setDebugEmitter(DebugInformationEmitter debugEmitter) {
        this.debugEmitter = debugEmitter;
    }

    public void setTopLevelNameLimit(int topLevelNameLimit) {
        this.topLevelNameLimit = topLevelNameLimit;
    }

    @Override
    public boolean requiresRegisterAllocation() {
        return true;
    }

    public void setStackTraceIncluded(boolean stackTraceIncluded) {
        this.stackTraceIncluded = stackTraceIncluded;
    }

    @Override
    public List<TeaVMHostExtension> getHostExtensions() {
        return Collections.singletonList(this);
    }

    @Override
    public void contributeDependencies(DependencyAnalyzer dependencyAnalyzer) {
        DependencyType stringType = dependencyAnalyzer.getType("java.lang.String");
        MethodDependency dep = dependencyAnalyzer.linkMethod(new MethodReference(Class.class.getName(), "getClass", ValueType.object("org.teavm.platform.PlatformClass"), ValueType.parse(Class.class)));
        dep.getVariable(0).propagate(dependencyAnalyzer.getType("org.teavm.platform.PlatformClass"));
        dep.getResult().propagate(dependencyAnalyzer.getType("java.lang.Class"));
        dep.use();
        dep = dependencyAnalyzer.linkMethod(new MethodReference(String.class, "<init>", char[].class, Void.TYPE));
        dep.getVariable(0).propagate(stringType);
        dep.getVariable(1).propagate(dependencyAnalyzer.getType("[C"));
        dep.use();
        dependencyAnalyzer.linkField(new FieldReference(String.class.getName(), "characters"));
        dependencyAnalyzer.linkMethod(new MethodReference(String.class, "hashCode", Integer.TYPE)).propagate(0, "java.lang.String").use();
        dependencyAnalyzer.linkMethod(new MethodReference(String.class, "equals", Object.class, Boolean.TYPE)).propagate(0, "java.lang.String").propagate(1, "java.lang.String").use();
        dependencyAnalyzer.linkMethod(new MethodReference(Object.class, "clone", Object.class));
        MethodDependency exceptionCons = dependencyAnalyzer.linkMethod(new MethodReference(NoClassDefFoundError.class, "<init>", String.class, Void.TYPE));
        dep = dependencyAnalyzer.linkMethod(new MethodReference(Object.class, "toString", String.class));
        dep.getVariable(0).propagate(dependencyAnalyzer.getType("java.lang.Object"));
        dep.use();
        exceptionCons.getVariable(0).propagate(dependencyAnalyzer.getType(NoClassDefFoundError.class.getName()));
        exceptionCons.getVariable(1).propagate(stringType);
        exceptionCons = dependencyAnalyzer.linkMethod(new MethodReference(NoSuchFieldError.class, "<init>", String.class, Void.TYPE));
        exceptionCons.use();
        exceptionCons.getVariable(0).propagate(dependencyAnalyzer.getType(NoSuchFieldError.class.getName()));
        exceptionCons.getVariable(1).propagate(stringType);
        exceptionCons = dependencyAnalyzer.linkMethod(new MethodReference(NoSuchMethodError.class, "<init>", String.class, Void.TYPE));
        exceptionCons.use();
        exceptionCons.getVariable(0).propagate(dependencyAnalyzer.getType(NoSuchMethodError.class.getName()));
        exceptionCons.getVariable(1).propagate(stringType);
        exceptionCons = dependencyAnalyzer.linkMethod(new MethodReference(RuntimeException.class, "<init>", String.class, Void.TYPE));
        exceptionCons.getVariable(0).propagate(dependencyAnalyzer.getType(RuntimeException.class.getName()));
        exceptionCons.getVariable(1).propagate(stringType);
        exceptionCons.use();
        if (this.stackTraceIncluded) {
            JavaScriptTarget.includeStackTraceMethods(dependencyAnalyzer);
        }
        dependencyAnalyzer.addDependencyListener(new AbstractDependencyListener(){

            @Override
            public void methodReached(DependencyAgent agent, MethodDependency method) {
                if (method.getReference().equals(CURRENT_THREAD)) {
                    method.use();
                    agent.linkMethod(new MethodReference(Thread.class, "setCurrentThread", Thread.class, Void.TYPE)).use();
                }
            }
        });
    }

    public static void includeStackTraceMethods(DependencyAnalyzer dependencyAnalyzer) {
        DependencyType stringType = dependencyAnalyzer.getType("java.lang.String");
        MethodDependency dep = dependencyAnalyzer.linkMethod(new MethodReference(StackTraceElement.class, "<init>", String.class, String.class, String.class, Integer.TYPE, Void.TYPE));
        dep.getVariable(0).propagate(dependencyAnalyzer.getType(StackTraceElement.class.getName()));
        dep.getVariable(1).propagate(stringType);
        dep.getVariable(2).propagate(stringType);
        dep.getVariable(3).propagate(stringType);
        dep.use();
        dep = dependencyAnalyzer.linkMethod(new MethodReference(Throwable.class, "setStackTrace", StackTraceElement[].class, Void.TYPE));
        dep.getVariable(0).propagate(dependencyAnalyzer.getType(Throwable.class.getName()));
        dep.getVariable(1).propagate(dependencyAnalyzer.getType("[Ljava/lang/StackTraceElement;"));
        dep.getVariable(1).getArrayItem().propagate(dependencyAnalyzer.getType(StackTraceElement.class.getName()));
        dep.use();
    }

    @Override
    public void emit(ListableClassHolderSource classes, BuildTarget target, String outputName) {
        try (OutputStream output = target.createResource(outputName);
             OutputStreamWriter writer = new OutputStreamWriter(output, StandardCharsets.UTF_8);){
            this.emit(classes, writer, target);
        }
        catch (IOException e) {
            throw new RenderingException(e);
        }
    }

    @Override
    public void beforeOptimizations(Program program, MethodReader method) {
    }

    @Override
    public void afterOptimizations(Program program, MethodReader method) {
    }

    private void emit(ListableClassHolderSource classes, Writer writer, BuildTarget target) {
        List<PreparedClass> clsNodes = this.modelToAst(classes);
        if (this.controller.wasCancelled()) {
            return;
        }
        AliasProvider aliasProvider = this.minifying ? new MinifyingAliasProvider(this.topLevelNameLimit) : new DefaultAliasProvider(this.topLevelNameLimit);
        DefaultNamingStrategy naming = new DefaultNamingStrategy(aliasProvider, this.controller.getUnprocessedClassSource());
        SourceWriterBuilder builder = new SourceWriterBuilder(naming);
        builder.setMinified(this.minifying);
        SourceWriter sourceWriter = builder.build(writer);
        DebugInformationEmitter debugEmitterToUse = this.debugEmitter;
        if (debugEmitterToUse == null) {
            debugEmitterToUse = new DummyDebugInformationEmitter();
        }
        VirtualMethodContributorContextImpl virtualMethodContributorContext = new VirtualMethodContributorContextImpl(classes);
        RenderingContext renderingContext = new RenderingContext(debugEmitterToUse, this.controller.getUnprocessedClassSource(), classes, this.controller.getClassLoader(), this.controller.getServices(), this.controller.getProperties(), naming, this.controller.getDependencyInfo(), m -> this.isVirtual(virtualMethodContributorContext, (MethodReference)m), this.controller.getClassInitializerInfo());
        renderingContext.setMinifying(this.minifying);
        Renderer renderer = new Renderer(sourceWriter, this.asyncMethods, this.asyncFamilyMethods, this.controller.getDiagnostics(), renderingContext);
        RuntimeRenderer runtimeRenderer = new RuntimeRenderer(classes, sourceWriter);
        renderer.setProperties(this.controller.getProperties());
        renderer.setMinifying(this.minifying);
        renderer.setProgressConsumer(this.controller::reportProgress);
        if (this.debugEmitter != null) {
            for (PreparedClass preparedClass : clsNodes) {
                for (PreparedMethod preparedMethod : preparedClass.getMethods()) {
                    if (preparedMethod.cfg == null) continue;
                    this.emitCFG(this.debugEmitter, preparedMethod.cfg);
                }
                if (!this.controller.wasCancelled()) continue;
                return;
            }
            renderer.setDebugEmitter(this.debugEmitter);
        }
        renderer.getDebugEmitter().setLocationProvider(sourceWriter);
        for (Map.Entry entry : this.methodInjectors.entrySet()) {
            renderingContext.addInjector((MethodReference)entry.getKey(), (Injector)entry.getValue());
        }
        try {
            this.printWrapperStart(sourceWriter);
            for (RendererListener rendererListener : this.rendererListeners) {
                rendererListener.begin(renderer, target);
            }
            int start = sourceWriter.getOffset();
            renderer.prepare(clsNodes);
            runtimeRenderer.renderRuntime();
            sourceWriter.append("var ").append(renderer.getNaming().getScopeName()).ws().append("=").ws().append("Object.create(null);").newLine();
            if (!renderer.render(clsNodes)) {
                return;
            }
            runtimeRenderer.renderHandWrittenRuntime("array.js");
            renderer.renderStringPool();
            renderer.renderStringConstants();
            renderer.renderCompatibilityStubs();
            if (renderer.isLongLibraryUsed()) {
                runtimeRenderer.renderHandWrittenRuntime("long.js");
            }
            if (renderer.isThreadLibraryUsed()) {
                runtimeRenderer.renderHandWrittenRuntime("thread.js");
            } else {
                runtimeRenderer.renderHandWrittenRuntime("simpleThread.js");
            }
            for (Map.Entry<? extends String, ? extends TeaVMEntryPoint> entry : this.controller.getEntryPoints().entrySet()) {
                sourceWriter.append("").append(entry.getKey()).ws().append("=").ws();
                MethodReference ref = entry.getValue().getMethod();
                sourceWriter.append("$rt_mainStarter(").appendMethodBody(ref);
                sourceWriter.append(");").newLine();
            }
            for (RendererListener rendererListener : this.rendererListeners) {
                rendererListener.complete();
            }
            this.printWrapperEnd(sourceWriter);
            int n = sourceWriter.getOffset() - start;
            this.printStats(renderer, n);
        }
        catch (IOException e) {
            throw new RenderingException("IO Error occurred", e);
        }
    }

    private void printWrapperStart(SourceWriter writer) throws IOException {
        writer.append("\"use strict\";").newLine();
        for (String string : this.controller.getEntryPoints().keySet()) {
            writer.append("var ").append(string).append(";").softNewLine();
        }
        writer.append("(function()").ws().append("{").newLine();
    }

    private void printWrapperEnd(SourceWriter writer) throws IOException {
        writer.append("})();").newLine();
    }

    private void printStats(Renderer renderer, int totalSize) {
        if (!Boolean.parseBoolean(System.getProperty("teavm.js.stats", "false"))) {
            return;
        }
        System.out.println("Total output size: " + STATS_NUM_FORMAT.format(totalSize));
        System.out.println("Metadata size: " + this.getSizeWithPercentage(renderer.getMetadataSize(), totalSize));
        System.out.println("String pool size: " + this.getSizeWithPercentage(renderer.getStringPoolSize(), totalSize));
        ObjectIntHashMap<String> packageSizeMap = new ObjectIntHashMap<String>();
        for (String className : renderer.getClassesInStats()) {
            String packageName = className.substring(0, className.lastIndexOf(46) + 1);
            int classSize = renderer.getClassSize(className);
            packageSizeMap.put(packageName, packageSizeMap.getOrDefault(packageName, 0) + classSize);
        }
        String[] packageNames = packageSizeMap.keys().toArray(String.class);
        Arrays.sort(packageNames, Comparator.comparing(p -> -packageSizeMap.getOrDefault((String)p, 0)));
        for (String packageName : packageNames) {
            System.out.println("Package '" + packageName + "' size: " + this.getSizeWithPercentage(packageSizeMap.get(packageName), totalSize));
        }
    }

    private String getSizeWithPercentage(int size, int totalSize) {
        return STATS_NUM_FORMAT.format(size) + " (" + STATS_PERCENT_FORMAT.format((double)size / (double)totalSize) + ")";
    }

    private List<PreparedClass> modelToAst(ListableClassHolderSource classes) {
        AsyncMethodFinder asyncFinder = new AsyncMethodFinder(this.controller.getDependencyInfo().getCallGraph());
        asyncFinder.find(classes);
        this.asyncMethods.addAll(asyncFinder.getAsyncMethods());
        this.asyncFamilyMethods.addAll(asyncFinder.getAsyncFamilyMethods());
        HashSet<MethodReference> splitMethods = new HashSet<MethodReference>(this.asyncMethods);
        splitMethods.addAll(this.asyncFamilyMethods);
        Decompiler decompiler = new Decompiler(classes, splitMethods, this.controller.isFriendlyToDebugger());
        ArrayList<PreparedClass> classNodes = new ArrayList<PreparedClass>();
        for (String className : this.getClassOrdering(classes)) {
            ClassHolder cls = classes.get(className);
            for (MethodHolder method : cls.getMethods()) {
                this.preprocessNativeMethod(method);
                if (!this.controller.wasCancelled()) continue;
                break;
            }
            classNodes.add(this.decompile(decompiler, cls));
        }
        return classNodes;
    }

    private List<String> getClassOrdering(ListableClassHolderSource classes) {
        ArrayList<String> sequence = new ArrayList<String>();
        HashSet<String> visited = new HashSet<String>();
        for (String className : classes.getClassNames()) {
            this.orderClasses(classes, className, visited, sequence);
        }
        return sequence;
    }

    private void orderClasses(ClassHolderSource classes, String className, Set<String> visited, List<String> order) {
        if (!visited.add(className)) {
            return;
        }
        ClassHolder cls = classes.get(className);
        if (cls == null) {
            return;
        }
        if (cls.getParent() != null) {
            this.orderClasses(classes, cls.getParent(), visited, order);
        }
        for (String iface : cls.getInterfaces()) {
            this.orderClasses(classes, iface, visited, order);
        }
        order.add(className);
    }

    private PreparedClass decompile(Decompiler decompiler, ClassHolder cls) {
        PreparedClass clsNode = new PreparedClass(cls);
        for (MethodHolder method : cls.getMethods()) {
            if (method.getModifiers().contains((Object)ElementModifier.ABSTRACT) || !JavaScriptTarget.isBootstrap() && method.getAnnotations().get(InjectedBy.class.getName()) != null || this.methodInjectors.containsKey(method.getReference()) || !method.hasModifier(ElementModifier.NATIVE) && !method.hasProgram()) continue;
            PreparedMethod preparedMethod = method.hasModifier(ElementModifier.NATIVE) ? this.decompileNative(method) : this.decompile(decompiler, method);
            clsNode.getMethods().add(preparedMethod);
        }
        return clsNode;
    }

    private PreparedMethod decompileNative(MethodHolder method) {
        MethodReference reference = method.getReference();
        Generator generator = this.methodGenerators.get(reference);
        if (generator == null && !JavaScriptTarget.isBootstrap()) {
            AnnotationHolder annotHolder = method.getAnnotations().get(GeneratedBy.class.getName());
            if (annotHolder == null) {
                throw new DecompilationException("Method " + method.getOwnerName() + "." + method.getDescriptor() + " is native, but no " + GeneratedBy.class.getName() + " annotation found");
            }
            ValueType annotValue = annotHolder.getValues().get("value").getJavaClass();
            String generatorClassName = ((ValueType.Object)annotValue).getClassName();
            try {
                Class<?> generatorClass = Class.forName(generatorClassName, true, this.controller.getClassLoader());
                generator = (Generator)generatorClass.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new DecompilationException("Error instantiating generator " + generatorClassName + " for native method " + method.getOwnerName() + "." + method.getDescriptor());
            }
        }
        return new PreparedMethod(method, null, generator, this.asyncMethods.contains(reference), null);
    }

    private PreparedMethod decompile(Decompiler decompiler, MethodHolder method) {
        MethodReference reference = method.getReference();
        if (this.asyncMethods.contains(reference)) {
            AsyncMethodNode node = this.decompileAsync(decompiler, method);
            ControlFlowEntry[] cfg = ProgramUtils.getLocationCFG(method.getProgram());
            return new PreparedMethod(method, node, null, false, cfg);
        }
        AstCacheEntry entry = this.decompileRegular(decompiler, method);
        return new PreparedMethod(method, entry.method, null, false, entry.cfg);
    }

    private AstCacheEntry decompileRegular(Decompiler decompiler, MethodHolder method) {
        AstCacheEntry entry;
        if (this.astCache == null) {
            return this.decompileRegularCacheMiss(decompiler, method);
        }
        CacheStatus cacheStatus = this.controller.getCacheStatus();
        AstCacheEntry astCacheEntry = entry = !cacheStatus.isStaleMethod(method.getReference()) ? this.astCache.get(method.getReference(), cacheStatus) : null;
        if (entry == null) {
            entry = this.decompileRegularCacheMiss(decompiler, method);
            RegularMethodNode finalNode = entry.method;
            this.astCache.store(method.getReference(), entry, () -> this.dependencyExtractor.extract(finalNode));
        }
        return entry;
    }

    private AstCacheEntry decompileRegularCacheMiss(Decompiler decompiler, MethodHolder method) {
        RegularMethodNode node = decompiler.decompileRegular(method);
        ControlFlowEntry[] cfg = LocationGraphBuilder.build(node.getBody());
        return new AstCacheEntry(node, cfg);
    }

    private AsyncMethodNode decompileAsync(Decompiler decompiler, MethodHolder method) {
        AsyncMethodNode node;
        if (this.astCache == null) {
            return decompiler.decompileAsync(method);
        }
        CacheStatus cacheStatus = this.controller.getCacheStatus();
        AsyncMethodNode asyncMethodNode = node = !cacheStatus.isStaleMethod(method.getReference()) ? this.astCache.getAsync(method.getReference(), cacheStatus) : null;
        if (node == null) {
            AsyncMethodNode finalNode = node = decompiler.decompileAsync(method);
            this.astCache.storeAsync(method.getReference(), node, () -> this.dependencyExtractor.extract(finalNode));
        }
        return node;
    }

    /*
     * WARNING - void declaration
     */
    private void preprocessNativeMethod(MethodHolder method) {
        void var5_9;
        if (!method.getModifiers().contains((Object)ElementModifier.NATIVE) || this.methodGenerators.get(method.getReference()) != null || this.methodInjectors.get(method.getReference()) != null) {
            return;
        }
        boolean found = false;
        ProviderContextImpl context = new ProviderContextImpl(method.getReference());
        for (Function<ProviderContext, Generator> function : this.generatorProviders) {
            Generator generator = function.apply(context);
            if (generator == null) continue;
            this.methodGenerators.put(method.getReference(), generator);
            found = true;
            break;
        }
        for (Function<ProviderContext, Object> function : this.injectorProviders) {
            Injector injector = (Injector)function.apply(context);
            if (injector == null) continue;
            this.methodInjectors.put(method.getReference(), injector);
            found = true;
            break;
        }
        if (found) {
            return;
        }
        if (!(JavaScriptTarget.isBootstrap() || method.getAnnotations().get(GeneratedBy.class.getName()) == null && method.getAnnotations().get(InjectedBy.class.getName()) == null)) {
            return;
        }
        method.getModifiers().remove((Object)ElementModifier.NATIVE);
        Program program = new Program();
        method.setProgram(program);
        boolean bl = false;
        while (var5_9 <= method.parameterCount()) {
            program.createVariable();
            ++var5_9;
        }
        BasicBlock basicBlock = program.createBasicBlock();
        Variable exceptionVar = program.createVariable();
        ConstructInstruction newExceptionInsn = new ConstructInstruction();
        newExceptionInsn.setType(NoSuchMethodError.class.getName());
        newExceptionInsn.setReceiver(exceptionVar);
        basicBlock.add(newExceptionInsn);
        Variable constVar = program.createVariable();
        StringConstantInstruction constInsn = new StringConstantInstruction();
        constInsn.setConstant("Native method implementation not found: " + method.getReference());
        constInsn.setReceiver(constVar);
        basicBlock.add(constInsn);
        InvokeInstruction initExceptionInsn = new InvokeInstruction();
        initExceptionInsn.setInstance(exceptionVar);
        initExceptionInsn.setMethod(new MethodReference(NoSuchMethodError.class, "<init>", String.class, Void.TYPE));
        initExceptionInsn.setType(InvocationType.SPECIAL);
        initExceptionInsn.setArguments(constVar);
        basicBlock.add(initExceptionInsn);
        RaiseInstruction raiseInsn = new RaiseInstruction();
        raiseInsn.setException(exceptionVar);
        basicBlock.add(raiseInsn);
        this.controller.getDiagnostics().error(new CallLocation(method.getReference()), "Native method {{m0}} has no implementation", method.getReference());
    }

    @PlatformMarker
    private static boolean isBootstrap() {
        return false;
    }

    private void emitCFG(DebugInformationEmitter emitter, ControlFlowEntry[] cfg) {
        for (ControlFlowEntry entry : cfg) {
            SourceLocation location = JavaScriptTarget.map(entry.from);
            SourceLocation[] successors = new SourceLocation[entry.to.length];
            for (int i = 0; i < entry.to.length; ++i) {
                successors[i] = JavaScriptTarget.map(entry.to[i]);
            }
            emitter.addSuccessors(location, successors);
        }
    }

    private static SourceLocation map(TextLocation location) {
        if (location == null) {
            return null;
        }
        return new SourceLocation(location.getFileName(), location.getLine());
    }

    @Override
    public String[] getPlatformTags() {
        return new String[]{"javascript"};
    }

    @Override
    public void addVirtualMethods(VirtualMethodContributor virtualMethods) {
        this.customVirtualMethods.add(virtualMethods);
    }

    @Override
    public boolean isAsyncSupported() {
        return true;
    }

    private boolean isVirtual(VirtualMethodContributorContext context, MethodReference method) {
        if (this.controller.isVirtual(method)) {
            return true;
        }
        for (VirtualMethodContributor predicate : this.customVirtualMethods) {
            if (!predicate.isVirtual(context, method)) continue;
            return true;
        }
        return false;
    }

    static class VirtualMethodContributorContextImpl
    implements VirtualMethodContributorContext {
        private ClassReaderSource classSource;

        VirtualMethodContributorContextImpl(ClassReaderSource classSource) {
            this.classSource = classSource;
        }

        @Override
        public ClassReaderSource getClassSource() {
            return this.classSource;
        }
    }

    class ProviderContextImpl
    implements ProviderContext {
        private MethodReference method;

        ProviderContextImpl(MethodReference method) {
            this.method = method;
        }

        @Override
        public MethodReference getMethod() {
            return this.method;
        }

        @Override
        public ClassReaderSource getClassSource() {
            return JavaScriptTarget.this.controller.getUnprocessedClassSource();
        }
    }
}

