/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.c.intrinsic;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.c.generate.CodeGeneratorUtil;
import org.teavm.backend.c.intrinsic.Intrinsic;
import org.teavm.backend.c.intrinsic.IntrinsicContext;
import org.teavm.backend.c.util.ConstantUtil;
import org.teavm.interop.Structure;
import org.teavm.model.ClassReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.model.lowlevel.Characteristics;

public class StructureIntrinsic
implements Intrinsic {
    private Characteristics characteristics;

    public StructureIntrinsic(Characteristics characteristics) {
        this.characteristics = characteristics;
    }

    @Override
    public boolean canHandle(MethodReference method) {
        if (!this.characteristics.isStructure(method.getClassName())) {
            return false;
        }
        switch (method.getName()) {
            case "cast": 
            case "toAddress": {
                return method.parameterCount() == 0;
            }
            case "sizeOf": {
                return method.parameterCount() == 1 && method.parameterType(0).equals(ValueType.parse(Class.class));
            }
            case "add": {
                return method.parameterCount() == 3 && method.parameterType(0).equals(ValueType.parse(Class.class)) && method.parameterType(1).equals(ValueType.parse(Structure.class)) && method.parameterType(2).equals(ValueType.INTEGER);
            }
        }
        return false;
    }

    @Override
    public void apply(IntrinsicContext context, InvocationExpr invocation) {
        switch (invocation.getMethod().getName()) {
            case "cast": 
            case "toAddress": {
                context.emit(invocation.getArguments().get(0));
                break;
            }
            case "sizeOf": {
                String className = ConstantUtil.getClassLiteral(context, invocation, invocation.getArguments().get(0));
                if (className == null) break;
                context.writer().print("sizeof(");
                ClassReader cls = context.classes().get(className);
                CodeGeneratorUtil.printClassReference(context.writer(), context.includes(), context.names(), cls, className);
                context.writer().print(")");
                break;
            }
            case "add": {
                String className = ConstantUtil.getClassLiteral(context, invocation, invocation.getArguments().get(0));
                if (className == null) break;
                ClassReader cls = context.classes().get(className);
                context.writer().print("TEAVM_STRUCTURE_ADD(");
                CodeGeneratorUtil.printClassReference(context.writer(), context.includes(), context.names(), cls, className);
                context.writer().print(", ");
                context.emit(invocation.getArguments().get(1));
                context.writer().print(", ");
                context.emit(invocation.getArguments().get(2));
                context.writer().print(")");
                break;
            }
        }
    }
}

