/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.c.generate;

import org.teavm.backend.c.generate.CodeWriter;
import org.teavm.backend.c.generate.GenerationContext;
import org.teavm.backend.c.generate.IncludeManager;
import org.teavm.backend.c.util.InteropUtil;
import org.teavm.backend.lowlevel.generate.NameProvider;
import org.teavm.model.ClassReader;
import org.teavm.model.ValueType;

public final class CodeGeneratorUtil {
    private CodeGeneratorUtil() {
    }

    public static void writeIntValue(CodeWriter writer, int i) {
        if (i == Integer.MIN_VALUE) {
            writer.print("(int32_t) INT32_C(0x80000000)");
        } else {
            long v = i;
            if (i < 0) {
                writer.print("-");
                v = -v;
            }
            writer.print("INT32_C(");
            CodeGeneratorUtil.writeLongConstant(writer, v);
            writer.print(")");
        }
    }

    public static void writeValue(CodeWriter writer, GenerationContext context, IncludeManager includes, Object value) {
        if (value == null) {
            writer.print("NULL");
        } else if (value instanceof String) {
            includes.includePath("strings.h");
            int index = context.getStringPool().getStringIndex((String)value);
            writer.print("TEAVM_GET_STRING(" + index + ")");
        } else if (value instanceof Integer) {
            CodeGeneratorUtil.writeIntValue(writer, (Integer)value);
        } else if (value instanceof Long) {
            long v = (Long)value;
            if (v == Long.MIN_VALUE) {
                writer.print("(int64_t) INT64_C(0x8000000000000000)");
            } else {
                if (v < 0L) {
                    writer.print("-");
                    v = -v;
                }
                writer.print("INT64_C(");
                CodeGeneratorUtil.writeLongConstant(writer, v);
                writer.print(")");
            }
        } else if (value instanceof Float) {
            float f = ((Float)value).floatValue();
            if (Float.isInfinite(f)) {
                if (f < 0.0f) {
                    writer.print("-");
                }
                writer.print("INFINITY");
            } else if (Float.isNaN(f)) {
                writer.print("NAN");
            } else if ((float)((int)f) == f) {
                writer.print(f + "f");
            } else {
                writer.print(Float.toHexString(f) + "f");
            }
        } else if (value instanceof Double) {
            double d = (Double)value;
            if (Double.isInfinite(d)) {
                if (d < 0.0) {
                    writer.print("-");
                }
                writer.print("INFINITY");
            } else if (Double.isNaN(d)) {
                writer.print("NAN");
            } else if ((double)((int)d) == d) {
                writer.print(value.toString());
            } else {
                writer.print(Double.toHexString(d));
            }
        } else if (value instanceof Boolean) {
            writer.print((Boolean)value != false ? "1" : "0");
        } else if (value instanceof Character) {
            CodeGeneratorUtil.writeIntValue(writer, ((Character)value).charValue());
        } else if (value instanceof ValueType) {
            includes.includeType((ValueType)value);
            writer.print("&").print(context.getNames().forClassInstance((ValueType)value));
        }
    }

    private static void writeLongConstant(CodeWriter writer, long v) {
        if (v == Long.MIN_VALUE) {
            writer.print("0x8000000000000000");
            return;
        }
        writer.print(String.valueOf(v));
    }

    public static void printClassReference(CodeWriter writer, IncludeManager includes, NameProvider names, ClassReader cls, String className) {
        if (cls != null && InteropUtil.isNative(cls)) {
            InteropUtil.processInclude(cls.getAnnotations(), includes);
            InteropUtil.printNativeReference(writer, cls);
        } else {
            includes.includeClass(className);
            writer.print(names.forClass(className));
        }
    }
}

