/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.cli;

import java.io.File;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.teavm.cli.ConsoleTeaVMToolLog;
import org.teavm.tooling.RuntimeCopyOperation;
import org.teavm.tooling.TeaVMTool;
import org.teavm.tooling.TeaVMToolLog;

public final class TeaVMRunner {
    private TeaVMRunner() {
    }

    public static void main(String[] args) {
        CommandLine commandLine;
        Options options = new Options();
        OptionBuilder.withArgName((String)"directory");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"a directory where to put generated files (current directory by default)");
        OptionBuilder.withLongOpt((String)"targetdir");
        options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"a file where to put decompiled classes (classes.js by default)");
        OptionBuilder.withLongOpt((String)"targetfile");
        options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.withDescription((String)"causes TeaVM to generate minimized JavaScript file");
        OptionBuilder.withLongOpt((String)"minify");
        options.addOption(OptionBuilder.create((String)"m"));
        OptionBuilder.withArgName((String)"separate|merge|none");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"how to attach runtime. Possible values are: separate|merge|none");
        OptionBuilder.withLongOpt((String)"runtime");
        options.addOption(OptionBuilder.create((String)"r"));
        OptionBuilder.withDescription((String)"causes TeaVM to include default main page");
        OptionBuilder.withLongOpt((String)"mainpage");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"causes TeaVM to log bytecode");
        OptionBuilder.withLongOpt((String)"logbytecode");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"Generate debug information");
        OptionBuilder.withLongOpt((String)"debug");
        options.addOption(OptionBuilder.create((char)'D'));
        OptionBuilder.withDescription((String)"Generate source maps");
        OptionBuilder.withLongOpt((String)"sourcemaps");
        options.addOption(OptionBuilder.create((char)'S'));
        OptionBuilder.withDescription((String)"Incremental build");
        OptionBuilder.withLongOpt((String)"incremental");
        options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.withArgName((String)"directory");
        OptionBuilder.withDescription((String)"Incremental build cache directory");
        OptionBuilder.withLongOpt((String)"cachedir");
        options.addOption(OptionBuilder.create((char)'c'));
        if (args.length == 0) {
            TeaVMRunner.printUsage(options);
            return;
        }
        PosixParser parser = new PosixParser();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            TeaVMRunner.printUsage(options);
            return;
        }
        TeaVMTool tool = new TeaVMTool();
        tool.setBytecodeLogging(commandLine.hasOption("logbytecode"));
        if (commandLine.hasOption("d")) {
            tool.setTargetDirectory(new File(commandLine.getOptionValue("d")));
        }
        if (commandLine.hasOption("f")) {
            tool.setTargetFileName(commandLine.getOptionValue("f"));
        }
        if (commandLine.hasOption("m")) {
            tool.setMinifying(true);
        } else {
            tool.setMinifying(false);
        }
        if (commandLine.hasOption("r")) {
            switch (commandLine.getOptionValue("r")) {
                case "separate": {
                    tool.setRuntime(RuntimeCopyOperation.SEPARATE);
                    break;
                }
                case "merge": {
                    tool.setRuntime(RuntimeCopyOperation.MERGED);
                    break;
                }
                case "none": {
                    tool.setRuntime(RuntimeCopyOperation.NONE);
                    break;
                }
                default: {
                    System.err.println("Wrong parameter for -r option specified");
                    TeaVMRunner.printUsage(options);
                    return;
                }
            }
        }
        if (commandLine.hasOption("mainpage")) {
            tool.setMainPageIncluded(true);
        }
        if (commandLine.hasOption('D')) {
            tool.setDebugInformationGenerated(true);
        }
        if (commandLine.hasOption('S')) {
            tool.setSourceMapsFileGenerated(true);
        }
        if (commandLine.hasOption('i')) {
            tool.setIncremental(true);
        }
        if (commandLine.hasOption('c')) {
            tool.setCacheDirectory(new File(commandLine.getOptionValue('c')));
        } else {
            tool.setCacheDirectory(new File(tool.getTargetDirectory(), "teavm-cache"));
        }
        args = commandLine.getArgs();
        if (args.length > 1) {
            System.err.println("Unexpected arguments");
            TeaVMRunner.printUsage(options);
            return;
        }
        if (args.length == 1) {
            tool.setMainClass(args[0]);
        }
        tool.setLog((TeaVMToolLog)new ConsoleTeaVMToolLog());
        tool.getProperties().putAll((Map<?, ?>)System.getProperties());
        try {
            tool.generate();
            tool.checkForMissingItems();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(-2);
        }
    }

    private static void printUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java " + TeaVMRunner.class.getName() + " [OPTIONS] [qualified.main.Class]", options);
        System.exit(-1);
    }
}

