/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.concurrent.atomic;

import java.io.Serializable;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;

public class TAtomicReference<V>
implements Serializable {
    private V value;
    private volatile int version;

    public TAtomicReference() {
    }

    public TAtomicReference(V value) {
        this.value = value;
    }

    public final V get() {
        return this.value;
    }

    public final void set(V newValue) {
        this.value = newValue;
        ++this.version;
    }

    public final void lazySet(V newValue) {
        this.value = newValue;
        ++this.version;
    }

    public final V getAndSet(V newValue) {
        V result = this.value;
        this.value = newValue;
        ++this.version;
        return result;
    }

    public final boolean compareAndSet(V expect, V update) {
        if (this.value != expect) {
            return false;
        }
        this.value = update;
        ++this.version;
        return true;
    }

    public final boolean weakCompareAndSet(V expect, V update) {
        if (this.value != expect) {
            return false;
        }
        this.value = update;
        ++this.version;
        return true;
    }

    public final V getAndUpdate(UnaryOperator<V> updateFunction) {
        Object newValue;
        V result;
        int expectedVersion;
        do {
            expectedVersion = this.version;
            result = this.value;
            newValue = updateFunction.apply(this.value);
        } while (expectedVersion != this.version);
        ++this.version;
        this.value = newValue;
        return result;
    }

    public final V updateAndGet(UnaryOperator<V> updateFunction) {
        Object newValue;
        int expectedVersion;
        do {
            expectedVersion = this.version;
            newValue = updateFunction.apply(this.value);
        } while (expectedVersion != this.version);
        ++this.version;
        this.value = newValue;
        return (V)newValue;
    }

    public final V getAndAccumulate(V x, BinaryOperator<V> accumulatorFunction) {
        Object newValue;
        V result;
        int expectedVersion;
        do {
            expectedVersion = this.version;
            result = this.value;
            newValue = accumulatorFunction.apply(this.value, x);
        } while (expectedVersion != this.version);
        ++this.version;
        this.value = newValue;
        return result;
    }

    public final V accumulateAndGet(V x, BinaryOperator<V> accumulatorFunction) {
        Object newValue;
        int expectedVersion;
        do {
            expectedVersion = this.version;
            newValue = accumulatorFunction.apply(this.value, x);
        } while (expectedVersion != this.version);
        ++this.version;
        this.value = newValue;
        return (V)newValue;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public final V getPlain() {
        return this.value;
    }

    public final void setPlain(V value) {
        this.value = value;
    }

    public final V getOpaque() {
        return this.value;
    }

    public final void setOpaque(V value) {
        this.value = value;
    }

    public final V getAcquire() {
        return this.value;
    }

    public final void setRelease(V value) {
        this.value = value;
    }

    public final V compareAndExchange(V expectedValue, V newValue) {
        if (this.value == expectedValue) {
            this.value = newValue;
            return expectedValue;
        }
        return this.value;
    }
}

