/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.concurrent.atomic;

import java.lang.reflect.Modifier;
import java.util.function.LongBinaryOperator;
import java.util.function.LongUnaryOperator;
import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.lang.TIllegalAccessException;
import org.teavm.classlib.java.lang.TNoSuchFieldException;
import org.teavm.classlib.java.lang.reflect.TField;
import org.teavm.classlib.java.util.concurrent.atomic.TReflectionBasedAtomicLongFieldUpdater;

public abstract class TAtomicLongFieldUpdater<T> {
    protected TAtomicLongFieldUpdater() {
    }

    public static <U> TAtomicLongFieldUpdater<U> newUpdater(TClass<U> tclass, String fieldName) {
        try {
            TField field = tclass.getDeclaredField(fieldName);
            if (!Modifier.isVolatile(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || !field.getType().equals(Long.TYPE)) {
                throw new IllegalArgumentException();
            }
            field.checkGetAccess();
            field.checkSetAccess();
            return new TReflectionBasedAtomicLongFieldUpdater(field);
        }
        catch (TIllegalAccessException | TNoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract boolean compareAndSet(T var1, long var2, long var4);

    public abstract boolean weakCompareAndSet(T var1, long var2, long var4);

    public abstract void set(T var1, long var2);

    public abstract void lazySet(T var1, long var2);

    public abstract long get(T var1);

    public long getAndSet(T obj, long newValue) {
        long currentValue;
        while (!this.compareAndSet(obj, currentValue = this.get(obj), newValue)) {
        }
        return currentValue;
    }

    public long getAndIncrement(T obj) {
        return this.getAndAdd(obj, 1L);
    }

    public long getAndDecrement(T obj) {
        return this.getAndAdd(obj, -1L);
    }

    public long getAndAdd(T obj, long delta) {
        long currentValue;
        while (!this.compareAndSet(obj, currentValue = this.get(obj), currentValue + delta)) {
        }
        return currentValue;
    }

    public long incrementAndGet(T obj) {
        return this.addAndGet(obj, 1L);
    }

    public long decrementAndGet(T obj) {
        return this.addAndGet(obj, -1L);
    }

    public long addAndGet(T obj, long delta) {
        long currentValue;
        while (!this.compareAndSet(obj, currentValue = this.get(obj), currentValue + delta)) {
        }
        return currentValue + delta;
    }

    public final long getAndUpdate(T obj, LongUnaryOperator updateFunction) {
        long newValue;
        long currentValue;
        while (!this.compareAndSet(obj, currentValue = this.get(obj), newValue = updateFunction.applyAsLong(currentValue))) {
        }
        return currentValue;
    }

    public final long updateAndGet(T obj, LongUnaryOperator updateFunction) {
        long newValue;
        long currentValue;
        while (!this.compareAndSet(obj, currentValue = this.get(obj), newValue = updateFunction.applyAsLong(currentValue))) {
        }
        return newValue;
    }

    public final long getAndAccumulate(T obj, long x, LongBinaryOperator accumulatorFunction) {
        long newValue;
        long currentValue;
        while (!this.compareAndSet(obj, currentValue = this.get(obj), newValue = accumulatorFunction.applyAsLong(currentValue, x))) {
        }
        return currentValue;
    }

    public final long accumulateAndGet(T obj, long x, LongBinaryOperator accumulatorFunction) {
        long newValue;
        long currentValue;
        while (!this.compareAndSet(obj, currentValue = this.get(obj), newValue = accumulatorFunction.applyAsLong(currentValue, x))) {
        }
        return newValue;
    }
}

