/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import org.teavm.backend.wasm.runtime.WasmSupport;
import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.impl.RandomUtils;
import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.util.random.TRandomGenerator;
import org.teavm.interop.Import;
import org.teavm.interop.Unmanaged;
import org.teavm.jso.JSBody;

public class TRandom
extends TObject
implements TRandomGenerator,
TSerializable {
    private double storedGaussian;
    private boolean haveStoredGaussian;

    public TRandom() {
    }

    public TRandom(long seed) {
    }

    public void setSeed(long seed) {
    }

    @Override
    public int nextInt() {
        return (int)(4.294967296E9 * this.nextDouble() + -2.147483648E9);
    }

    @Override
    public int nextInt(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        return (int)(this.nextDouble() * (double)n);
    }

    @Override
    public long nextLong() {
        return (long)this.nextInt() << 32 | (long)this.nextInt();
    }

    @Override
    public float nextFloat() {
        return (float)this.nextDouble();
    }

    @Override
    public double nextDouble() {
        if (PlatformDetector.isC()) {
            return TRandom.crand();
        }
        if (PlatformDetector.isWebAssembly()) {
            return WasmSupport.random();
        }
        return TRandom.random();
    }

    @Import(name="teavm_rand")
    @Unmanaged
    private static native double crand();

    @Override
    public double nextGaussian() {
        if (this.haveStoredGaussian) {
            this.haveStoredGaussian = false;
            return this.storedGaussian;
        }
        double[] pair = RandomUtils.pairGaussian(this::nextDouble);
        this.haveStoredGaussian = true;
        this.storedGaussian = pair[1];
        return pair[0];
    }

    @JSBody(script="return Math.random();")
    @Import(module="teavmMath", name="random")
    @Unmanaged
    private static native double random();
}

