/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.io.Serializable;
import java.util.Arrays;
import org.teavm.classlib.java.lang.TCloneNotSupportedException;
import org.teavm.classlib.java.util.TAbstractCollection;
import org.teavm.classlib.java.util.TAbstractMap;
import org.teavm.classlib.java.util.TAbstractSet;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TGenericEnumSet;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TMap;
import org.teavm.classlib.java.util.TNoSuchElementException;
import org.teavm.classlib.java.util.TObjects;
import org.teavm.classlib.java.util.TSet;
import org.teavm.interop.Rename;

public class TEnumMap<K extends Enum<K>, V>
extends TAbstractMap<K, V>
implements Serializable,
Cloneable {
    private Class<K> keyType;
    private Object[] data;
    private boolean[] provided;
    private int size;
    private TSet<TMap.Entry<K, V>> entrySet;

    public TEnumMap(Class<K> keyType) {
        this.initFromKeyType(keyType);
    }

    public TEnumMap(TEnumMap<K, V> m) {
        this.initFromOtherEnumMap(m);
    }

    public TEnumMap(TMap<K, V> m) {
        if (m instanceof TEnumMap) {
            this.initFromOtherEnumMap((TEnumMap)m);
        } else {
            if (m.isEmpty()) {
                throw new IllegalArgumentException();
            }
            TIterator it = m.entrySet().iterator();
            while (it.hasNext()) {
                Class<?> cls;
                TMap.Entry entry = (TMap.Entry)it.next();
                Enum key = (Enum)entry.getKey();
                if (this.keyType == null) {
                    this.initFromKeyType(key.getDeclaringClass());
                }
                if ((cls = key.getClass()) != this.keyType && cls.getSuperclass() != this.keyType) {
                    throw new ClassCastException();
                }
                int index = key.ordinal();
                this.provided[index] = true;
                this.data[index] = entry.getValue();
            }
            this.size = m.size();
        }
    }

    private void initFromKeyType(Class<K> keyType) {
        this.keyType = keyType;
        this.data = new Object[TGenericEnumSet.getConstants(keyType).length];
        this.provided = new boolean[this.data.length];
    }

    private void initFromOtherEnumMap(TEnumMap<K, V> m) {
        this.keyType = m.keyType;
        this.data = Arrays.copyOf(m.data, m.data.length);
        this.provided = Arrays.copyOf(m.provided, m.provided.length);
        this.size = m.size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = 0; i < this.data.length; ++i) {
            if (!this.provided[i] || !TObjects.equals(value, this.data[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (!this.keyType.isInstance(key)) {
            return false;
        }
        int index = ((Enum)key).ordinal();
        return this.provided[index];
    }

    @Override
    public V get(Object key) {
        if (!this.keyType.isInstance(key)) {
            return null;
        }
        int index = ((Enum)key).ordinal();
        Object value = this.data[index];
        return (V)value;
    }

    @Override
    public V put(K key, V value) {
        Class<?> cls = key.getClass();
        if (cls != this.keyType && cls.getSuperclass() != this.keyType) {
            throw new ClassCastException();
        }
        int index = ((Enum)key).ordinal();
        Object old = this.data[index];
        if (!this.provided[index]) {
            this.provided[index] = true;
            ++this.size;
        }
        this.data[index] = value;
        return (V)old;
    }

    @Override
    public V remove(Object key) {
        if (!this.keyType.isInstance(key)) {
            return null;
        }
        int index = ((Enum)key).ordinal();
        Object old = this.data[index];
        if (this.provided[index]) {
            this.provided[index] = false;
            this.data[index] = null;
            --this.size;
        }
        return (V)old;
    }

    @Override
    public void putAll(TMap<? extends K, ? extends V> m) {
        if (m instanceof TEnumMap) {
            TEnumMap em = (TEnumMap)m;
            if (!em.isEmpty() && this.keyType != em.keyType) {
                throw new ClassCastException(em.keyType + " != " + this.keyType);
            }
            for (int i = 0; i < this.data.length; ++i) {
                if (!em.provided[i]) continue;
                this.data[i] = em.data[i];
                if (this.provided[i]) continue;
                this.provided[i] = true;
                ++this.size;
            }
        } else {
            super.putAll(m);
        }
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            this.size = 0;
            Arrays.fill(this.provided, false);
            Arrays.fill(this.data, null);
        }
    }

    @Rename(value="clone")
    public TEnumMap<K, V> clone0() {
        try {
            TEnumMap map = (TEnumMap)super.clone();
            map.keyType = this.keyType;
            map.provided = (boolean[])this.provided.clone();
            map.data = (Object[])this.data.clone();
            map.size = this.size;
            return map;
        }
        catch (TCloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public TSet<TMap.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new TAbstractSet<TMap.Entry<K, V>>(){

                @Override
                public TIterator<TMap.Entry<K, V>> iterator() {
                    return new TIterator<TMap.Entry<K, V>>(){
                        int index;
                        int removeIndex = -1;
                        {
                            this.find();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.index < TEnumMap.this.data.length;
                        }

                        @Override
                        public TMap.Entry<K, V> next() {
                            if (this.index >= TEnumMap.this.data.length) {
                                throw new TNoSuchElementException();
                            }
                            this.removeIndex = this.index;
                            EntryImpl result = new EntryImpl(this.index++);
                            this.find();
                            return result;
                        }

                        private void find() {
                            while (this.index < TEnumMap.this.provided.length && !TEnumMap.this.provided[this.index]) {
                                ++this.index;
                            }
                        }

                        @Override
                        public void remove() {
                            if (this.removeIndex < 0) {
                                throw new IllegalStateException();
                            }
                            if (TEnumMap.this.provided[this.removeIndex]) {
                                TEnumMap.this.data[this.removeIndex] = null;
                                TEnumMap.this.provided[this.removeIndex] = false;
                                --TEnumMap.this.size;
                            }
                            this.removeIndex = -1;
                        }
                    };
                }

                @Override
                public int size() {
                    return TEnumMap.this.size;
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof TMap.Entry)) {
                        return false;
                    }
                    TMap.Entry e = (TMap.Entry)o;
                    Class<?> cls = e.getKey().getClass();
                    if (cls != TEnumMap.this.keyType && cls.getSuperclass() != TEnumMap.this.keyType) {
                        return false;
                    }
                    int index = ((Enum)e.getKey()).ordinal();
                    return TEnumMap.this.provided[index] && TObjects.equals(TEnumMap.this.data[index], e.getValue());
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof TMap.Entry)) {
                        return false;
                    }
                    TMap.Entry e = (TMap.Entry)o;
                    Class<?> cls = e.getKey().getClass();
                    if (cls != TEnumMap.this.keyType && cls.getSuperclass() != TEnumMap.this.keyType) {
                        return false;
                    }
                    int index = ((Enum)e.getKey()).ordinal();
                    if (TEnumMap.this.provided[index] && TObjects.equals(e.getValue(), TEnumMap.this.data[index])) {
                        TEnumMap.this.provided[index] = false;
                        TEnumMap.this.data[index] = null;
                        --TEnumMap.this.size;
                        return true;
                    }
                    return false;
                }

                @Override
                public void clear() {
                    TEnumMap.this.clear();
                }

                class EntryImpl
                implements TMap.Entry<K, V> {
                    int index;

                    EntryImpl(int index) {
                        this.index = index;
                    }

                    private K key() {
                        return TGenericEnumSet.getConstants(TEnumMap.this.keyType)[this.index];
                    }

                    private V value() {
                        return TEnumMap.this.data[this.index];
                    }

                    @Override
                    public K getKey() {
                        if (!TEnumMap.this.provided[this.index]) {
                            throw new IllegalStateException();
                        }
                        return this.key();
                    }

                    @Override
                    public V getValue() {
                        if (!TEnumMap.this.provided[this.index]) {
                            throw new IllegalStateException();
                        }
                        return this.value();
                    }

                    @Override
                    public V setValue(V value) {
                        if (!TEnumMap.this.provided[this.index]) {
                            throw new IllegalStateException();
                        }
                        Object old = TEnumMap.this.data[this.index];
                        TEnumMap.this.data[this.index] = value;
                        return old;
                    }

                    public boolean equals(Object obj) {
                        if (this == obj) {
                            return true;
                        }
                        if (obj instanceof TMap.Entry) {
                            TMap.Entry entry = (TMap.Entry)obj;
                            return TObjects.equals(this.key(), entry.getKey()) && TObjects.equals(this.value(), entry.getValue());
                        }
                        return false;
                    }

                    public int hashCode() {
                        return TObjects.hashCode(this.key()) ^ TObjects.hashCode(this.value());
                    }

                    public String toString() {
                        return this.key() + "=" + this.value();
                    }
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public TCollection<V> values() {
        if (this.cachedValues == null) {
            this.cachedValues = new TAbstractCollection<V>(){

                @Override
                public int size() {
                    return TEnumMap.this.size;
                }

                @Override
                public boolean contains(Object o) {
                    return TEnumMap.this.containsValue(o);
                }

                @Override
                public boolean remove(Object o) {
                    for (int i = 0; i < TEnumMap.this.data.length; ++i) {
                        if (!TEnumMap.this.provided[i] || !TObjects.equals(o, TEnumMap.this.data[i])) continue;
                        TEnumMap.this.data[i] = null;
                        TEnumMap.this.provided[i] = false;
                        --TEnumMap.this.size;
                        return true;
                    }
                    return false;
                }

                @Override
                public void clear() {
                    TEnumMap.this.clear();
                }

                @Override
                public TIterator<V> iterator() {
                    final TIterator it = TEnumMap.this.entrySet().iterator();
                    return new TIterator<V>(){

                        @Override
                        public boolean hasNext() {
                            return it.hasNext();
                        }

                        @Override
                        public V next() {
                            return ((TMap.Entry)it.next()).getValue();
                        }

                        @Override
                        public void remove() {
                            it.remove();
                        }
                    };
                }
            };
        }
        return this.cachedValues;
    }
}

