/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.teavm.classlib.impl.currency.CurrencyHelper;
import org.teavm.classlib.impl.currency.CurrencyResource;
import org.teavm.classlib.impl.unicode.CLDRHelper;
import org.teavm.classlib.impl.unicode.CurrencyLocalization;
import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.util.TLocale;
import org.teavm.platform.metadata.ResourceArray;
import org.teavm.platform.metadata.ResourceMap;
import org.teavm.platform.metadata.StringResource;

public final class TCurrency
implements TSerializable {
    private static Map<String, TCurrency> currencies;
    private CurrencyResource resource;

    private TCurrency(CurrencyResource resource) {
        this.resource = resource;
    }

    private static void initCurrencies() {
        if (currencies != null) {
            return;
        }
        currencies = new HashMap<String, TCurrency>();
        ResourceArray<CurrencyResource> resources = CurrencyHelper.getCurrencies();
        for (int i = 0; i < resources.size(); ++i) {
            CurrencyResource resource = (CurrencyResource)resources.get(i);
            currencies.put(resource.getCode(), new TCurrency(resource));
        }
    }

    public static TCurrency getInstance(String currencyCode) {
        if (currencyCode == null) {
            throw new NullPointerException();
        }
        TCurrency.initCurrencies();
        TCurrency currency = currencies.get(currencyCode);
        if (currency == null) {
            throw new IllegalArgumentException("Currency not found: " + currencyCode);
        }
        return currency;
    }

    public static TCurrency getInstance(TLocale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        String coutry = CLDRHelper.resolveCountry(locale.getLanguage(), locale.getCountry());
        ResourceMap<StringResource> countryMap = CurrencyHelper.getCountryToCurrencyMap();
        if (!countryMap.has(coutry)) {
            return null;
        }
        return TCurrency.getInstance(((StringResource)countryMap.get(coutry)).getValue());
    }

    public static Set<TCurrency> getAvailableCurrencies() {
        TCurrency.initCurrencies();
        return new HashSet<TCurrency>(currencies.values());
    }

    public String getCurrencyCode() {
        return this.resource.getCode();
    }

    public String getSymbol() {
        return this.getSymbol(TLocale.getDefault());
    }

    public String getSymbol(TLocale locale) {
        CurrencyLocalization localization = CLDRHelper.resolveCurrency(locale.getLanguage(), locale.getCountry(), this.getCurrencyCode());
        return localization != null && !localization.getSymbol().isEmpty() ? localization.getSymbol() : this.getCurrencyCode();
    }

    public int getDefaultFractionDigits() {
        return this.resource.getFractionDigits();
    }

    public int getNumericCode() {
        return this.resource.getNumericCode();
    }

    public String getDisplayName() {
        return this.getDisplayName(TLocale.getDefault());
    }

    public String getDisplayName(TLocale locale) {
        CurrencyLocalization localization = CLDRHelper.resolveCurrency(locale.getLanguage(), locale.getCountry(), this.getCurrencyCode());
        return localization != null ? localization.getName() : this.getCurrencyCode();
    }

    public String toString() {
        return this.resource.getCode();
    }
}

